/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.lang.reflect.Modifier;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.FieldNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.refmap.IMixinContext;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorStandard;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidInterfaceMixinException;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidMixinException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Bytecode;

class MixinPreProcessorInterface
extends MixinPreProcessorStandard {
    MixinPreProcessorInterface(MixinInfo mixin, MixinInfo.MixinClassNode classNode) {
        super(mixin, classNode);
    }

    @Override
    protected void prepareMethod(MixinInfo.MixinMethodNode mixinMethod, ClassInfo.Method method) {
        if (!Bytecode.hasFlag(mixinMethod, 1)) {
            if (Bytecode.hasFlag(mixinMethod, 4096)) {
                MixinEnvironment.CompatibilityLevel requiredLevel = MixinEnvironment.CompatibilityLevel.requiredFor(2);
                if (MixinEnvironment.getCompatibilityLevel().isLessThan(requiredLevel)) {
                    throw new InvalidInterfaceMixinException((IMixinInfo)this.mixin, String.format("Interface mixin contains a synthetic private method but compatibility level %s is required! Found %s in %s", new Object[]{requiredLevel, method, this.mixin}));
                }
            } else {
                if ("<clinit>".equals(mixinMethod.name) && "()V".equals(mixinMethod.desc)) {
                    return;
                }
                if (!Bytecode.hasFlag(mixinMethod, 2) || !MixinEnvironment.getCompatibilityLevel().supports(4)) {
                    throw new InvalidInterfaceMixinException((IMixinInfo)this.mixin, "Interface mixin contains a non-public method! Found " + method + " in " + this.mixin);
                }
            }
        }
        super.prepareMethod(mixinMethod, method);
    }

    @Override
    protected boolean validateField(MixinTargetContext context, FieldNode field, AnnotationNode shadow) {
        if (!(Bytecode.isStatic(field) && Bytecode.hasFlag(field, 1) && Bytecode.hasFlag(field, 16))) {
            throw new InvalidInterfaceMixinException((IMixinInfo)this.mixin, String.format("Interface mixin contains an illegal field! Found %s %s in %s", Modifier.toString(field.access), field.name, this.mixin));
        }
        if (shadow == null) {
            throw new InvalidInterfaceMixinException((IMixinInfo)this.mixin, String.format("Interface mixin %s contains a non-shadow field: %s", this.mixin, field.name));
        }
        if (Annotations.getVisible(field, Mutable.class) != null) {
            throw new InvalidInterfaceMixinException((IMixinInfo)this.mixin, String.format("@Shadow field %s.%s is marked as mutable. This is not allowed.", this.mixin, field.name));
        }
        String prefix = (String)Annotations.getValue(shadow, "prefix", Shadow.class);
        if (field.name.startsWith(prefix)) {
            throw new InvalidMixinException((IMixinContext)context, String.format("@Shadow field %s.%s has a shadow prefix. This is not allowed.", context, field.name));
        }
        if ("super$".equals(field.name)) {
            throw new InvalidInterfaceMixinException((IMixinInfo)this.mixin, String.format("Interface mixin %s contains an imaginary super. This is not allowed", this.mixin));
        }
        return true;
    }
}

