/*
 * Decompiled with CFR 0.152.
 */
package am2;

import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.spell.component.interfaces.IRitualInteraction;
import am2.blocks.BlocksCommonProxy;
import am2.utility.InventoryUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class RitualShapeHelper {
    public MultiblockStructureDefinition ringedCross;
    public MultiblockStructureDefinition hourglass;
    public MultiblockStructureDefinition corruption;
    public MultiblockStructureDefinition purification;
    public static final RitualShapeHelper instance = new RitualShapeHelper();

    private RitualShapeHelper() {
        this.init();
    }

    public ItemStack[] checkForRitual(IRitualInteraction interaction, World world, int x, int y, int z, boolean itemsMustMatch) {
        if (interaction.getRitualShape().checkStructure(world, x, y, z)) {
            ItemStack[] reagents = interaction.getReagents();
            if (reagents.length == 0) {
                return reagents;
            }
            int r = interaction.getReagentSearchRadius();
            ArrayList items = (ArrayList)world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - r), (double)y, (double)(z - r), (double)(x + r + 1), (double)(y + 1), (double)(z + r + 1)));
            Collections.sort(items, new EntityItemComparator());
            if (!itemsMustMatch || this.matchReagents((List)items.clone(), reagents)) {
                ItemStack[] toReturn = new ItemStack[items.size()];
                for (int i = 0; i < items.size(); ++i) {
                    toReturn[i] = ((EntityItem)items.get(i)).func_92059_d();
                }
                return toReturn;
            }
        }
        return null;
    }

    public ItemStack[] checkForRitual(IRitualInteraction interaction, World world, int x, int y, int z) {
        return this.checkForRitual(interaction, world, x, y, z, true);
    }

    private boolean matchReagents(List<EntityItem> items, ItemStack[] check) {
        if (items.size() != check.length) {
            return false;
        }
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (ItemStack stack : check) {
            itemList.add(stack);
        }
        for (ItemStack stack : itemList) {
            Iterator<EntityItem> eIt = items.iterator();
            boolean found = false;
            while (eIt.hasNext()) {
                EntityItem eItem = eIt.next();
                if (!InventoryUtilities.compareItemStacks(eItem.func_92059_d(), stack, true, false, true, true)) continue;
                found = true;
                eIt.remove();
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void consumeRitualShape(IRitualInteraction interaction, World world, int x, int y, int z) {
        for (int i : interaction.getRitualShape().getMutexList()) {
            interaction.getRitualShape().removeMutex(i, world, x, y, z);
        }
    }

    public void consumeRitualReagents(IRitualInteraction interaction, World world, int x, int y, int z) {
        int r = interaction.getReagentSearchRadius();
        List items = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - r), (double)y, (double)(z - r), (double)(x + r + 1), (double)(y + 1), (double)(z + r + 1)));
        for (EntityItem item : items) {
            item.func_70106_y();
        }
    }

    public void init() {
        this.initRingedCross();
        this.initHourglass();
        this.initCorruption();
        this.initPurification();
    }

    private void initRingedCross() {
        this.ringedCross = new MultiblockStructureDefinition("ringedCross");
        this.ringedCross.addAllowedBlock(1, 0, 0, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(-1, 0, 0, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(0, 0, 1, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(0, 0, -1, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(1, 0, 2, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(0, 0, 2, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(-1, 0, 2, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(1, 0, -2, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(0, 0, -2, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(-1, 0, -2, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(2, 0, 1, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(2, 0, 0, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(2, 0, -1, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(-2, 0, 1, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(-2, 0, 0, BlocksCommonProxy.wizardChalk);
        this.ringedCross.addAllowedBlock(-2, 0, -1, BlocksCommonProxy.wizardChalk);
    }

    private void initHourglass() {
        this.hourglass = new MultiblockStructureDefinition("hourglass");
        MultiblockStructureDefinition.StructureGroup eastWest = this.hourglass.createGroup("WE", 2);
        MultiblockStructureDefinition.StructureGroup northSouth = this.hourglass.createGroup("NS", 2);
        this.hourglass.addAllowedBlock(eastWest, 0, 0, 0, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(eastWest, -1, 0, 1, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(eastWest, -1, 0, -1, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(eastWest, 1, 0, 1, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(eastWest, 1, 0, -1, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(eastWest, -2, 0, 1, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(eastWest, -2, 0, 0, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(eastWest, -2, 0, -1, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(eastWest, 2, 0, 1, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(eastWest, 2, 0, 0, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(eastWest, 2, 0, -1, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(northSouth, 0, 0, 0, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(northSouth, 1, 0, -1, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(northSouth, -1, 0, -1, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(northSouth, 1, 0, 1, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(northSouth, -1, 0, 1, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(northSouth, 1, 0, -2, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(northSouth, 0, 0, -2, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(northSouth, -1, 0, -2, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(northSouth, 1, 0, 2, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(northSouth, 0, 0, 2, BlocksCommonProxy.wizardChalk);
        this.hourglass.addAllowedBlock(northSouth, -1, 0, 2, BlocksCommonProxy.wizardChalk);
    }

    private void initCorruption() {
        this.corruption = new MultiblockStructureDefinition("corruption");
        MultiblockStructureDefinition.StructureGroup NS = this.corruption.createGroup("NS", 2);
        MultiblockStructureDefinition.StructureGroup WE = this.corruption.createGroup("WE", 2);
        this.corruption.addAllowedBlock(NS, 0, 0, 1, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, 0, 0, -1, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, 1, 0, 2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, 1, 0, -2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, -1, 0, 2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, -1, 0, -2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, 2, 0, 2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, 2, 0, 1, (Block)BlocksCommonProxy.candle);
        this.corruption.addAllowedBlock(NS, 2, 0, 0, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, 2, 0, -1, (Block)BlocksCommonProxy.candle);
        this.corruption.addAllowedBlock(NS, 2, 0, -2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, -2, 0, 2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, -2, 0, 1, (Block)BlocksCommonProxy.candle);
        this.corruption.addAllowedBlock(NS, -2, 0, 0, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, -2, 0, -1, (Block)BlocksCommonProxy.candle);
        this.corruption.addAllowedBlock(NS, -2, 0, -2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, 3, 0, 1, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, 3, 0, -1, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, -3, 0, 1, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(NS, -3, 0, -1, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, 1, 0, 0, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, -1, 0, 0, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, 2, 0, 1, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, -2, 0, 1, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, 2, 0, -1, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, -2, 0, -1, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, 2, 0, 2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, 1, 0, 2, (Block)BlocksCommonProxy.candle);
        this.corruption.addAllowedBlock(WE, 0, 0, 2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, -1, 0, 2, (Block)BlocksCommonProxy.candle);
        this.corruption.addAllowedBlock(WE, -2, 0, 2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, 2, 0, -2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, 1, 0, -2, (Block)BlocksCommonProxy.candle);
        this.corruption.addAllowedBlock(WE, 0, 0, -2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, -1, 0, -2, (Block)BlocksCommonProxy.candle);
        this.corruption.addAllowedBlock(WE, -2, 0, -2, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, 1, 0, 3, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, -1, 0, 3, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, 1, 0, -3, BlocksCommonProxy.wizardChalk);
        this.corruption.addAllowedBlock(WE, -1, 0, -3, BlocksCommonProxy.wizardChalk);
    }

    private void initPurification() {
        this.purification = new MultiblockStructureDefinition("purification");
        this.purification.addAllowedBlock(-1, 0, 1, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(-1, 0, -1, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(1, 0, 1, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(1, 0, -1, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(-2, 0, 1, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(-2, 0, -1, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(2, 0, 1, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(2, 0, -1, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(1, 0, -2, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(-1, 0, -2, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(1, 0, 2, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(-1, 0, 2, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(-3, 0, 1, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(-3, 0, 0, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(-3, 0, -1, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(3, 0, 1, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(3, 0, 0, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(3, 0, -1, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(1, 0, -3, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(0, 0, -3, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(-1, 0, -3, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(1, 0, 3, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(0, 0, 3, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(-1, 0, 3, BlocksCommonProxy.wizardChalk);
        this.purification.addAllowedBlock(-2, 0, 2, (Block)BlocksCommonProxy.candle);
        this.purification.addAllowedBlock(-2, 0, -2, (Block)BlocksCommonProxy.candle);
        this.purification.addAllowedBlock(2, 0, 2, (Block)BlocksCommonProxy.candle);
        this.purification.addAllowedBlock(2, 0, -2, (Block)BlocksCommonProxy.candle);
    }

    private class EntityItemComparator
    implements Comparator<EntityItem> {
        private EntityItemComparator() {
        }

        @Override
        public int compare(EntityItem o1, EntityItem o2) {
            if (o1.field_70173_aa == o2.field_70173_aa) {
                return 0;
            }
            if (o1.field_70173_aa > o2.field_70173_aa) {
                return -1;
            }
            return 1;
        }
    }
}

