/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.api.math.AMVector3;
import am2.blocks.BlockCrystalMarker;
import am2.blocks.tileentities.TileEntityFlickerHabitat;
import am2.utility.InventoryUtilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class TileEntityCrystalMarker
extends TileEntity
implements IInventory,
ISidedInventory {
    private static final int SEARCH_RADIUS = 400;
    public static final int FILTER_SIZE = 9;
    private int facing = 0;
    private int priority = 0;
    private AMVector3 elementalAttuner = null;
    protected ItemStack[] filterItems = new ItemStack[9];
    private int markerType;
    private AxisAlignedBB connectedBoundingBox;

    public boolean canUpdate() {
        return false;
    }

    public void setFacing(int face) {
        this.facing = face;
    }

    public int getFacing() {
        return this.facing;
    }

    public int getPriority() {
        return this.priority;
    }

    public void cyclePriority() {
        ++this.priority;
        this.priority %= 10;
        if (!this.field_145850_b.field_72995_K) {
            for (EntityPlayerMP player : this.field_145850_b.func_72872_a(EntityPlayerMP.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(64.0, 64.0, 64.0))) {
                player.field_71135_a.func_147359_a(this.func_145844_m());
            }
        }
    }

    public AxisAlignedBB GetConnectedBoundingBox() {
        if (this.connectedBoundingBox != null) {
            return this.connectedBoundingBox;
        }
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public void SetConnectedBoundingBox(AxisAlignedBB boundingBox) {
        this.connectedBoundingBox = boundingBox;
    }

    public void SetConnectedBoundingBox(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.connectedBoundingBox = AxisAlignedBB.func_72330_a((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz);
    }

    public int getMarkerType() {
        return this.markerType;
    }

    public void setElementalAttuner(AMVector3 vector) {
        this.elementalAttuner = new AMVector3(vector.x, vector.y, vector.z);
    }

    public AMVector3 getElementalAttuner() {
        return this.elementalAttuner;
    }

    public void removeElementalAttuner() {
        this.elementalAttuner = null;
    }

    public boolean hasFilterItems() {
        boolean retVar = false;
        if (this.filterItems != null) {
            for (int i = 0; i < this.filterItems.length; ++i) {
                if (this.filterItems[i] == null) continue;
                retVar = true;
                break;
            }
        }
        return retVar;
    }

    public boolean filterHasItem(ItemStack stack) {
        boolean retVal = false;
        if (stack != null && this.hasFilterItems()) {
            for (int i = 0; i < this.filterItems.length; ++i) {
                if (this.filterItems[i] == null || !InventoryUtilities.compareItemStacks(this.filterItems[i], stack, true, false, true, true)) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public int getFilterCount(ItemStack stack) {
        int totalCount = 0;
        if (this.hasFilterItems()) {
            for (int i = 0; i < this.filterItems.length; ++i) {
                if (this.filterItems[i] == null || !InventoryUtilities.compareItemStacks(this.filterItems[i], stack, true, false, true, true)) continue;
                totalCount += this.filterItems[i].field_77994_a;
            }
        }
        return totalCount;
    }

    public TileEntityCrystalMarker() {
        this(0);
    }

    public TileEntityCrystalMarker(int markerType) {
        this.markerType = markerType;
        if (this.markerType == 7) {
            this.priority = 11;
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("facing", this.facing);
        nbttagcompound.func_74768_a("priority", this.priority);
        nbttagcompound.func_74768_a("markerType", this.markerType);
        if (this.elementalAttuner != null) {
            NBTTagCompound elementalAttunerLocation = new NBTTagCompound();
            elementalAttunerLocation.func_74776_a("x", this.elementalAttuner.x);
            elementalAttunerLocation.func_74776_a("y", this.elementalAttuner.y);
            elementalAttunerLocation.func_74776_a("z", this.elementalAttuner.z);
            nbttagcompound.func_74782_a("elementalAttuner", (NBTBase)elementalAttunerLocation);
        }
        if (this.hasFilterItems()) {
            NBTTagList filterItemsList = new NBTTagList();
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.filterItems[i] == null) continue;
                String tag = String.format("ArrayIndex", i);
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a(tag, (byte)i);
                this.filterItems[i].func_77955_b(nbttagcompound1);
                filterItemsList.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("filterItems", (NBTBase)filterItemsList);
        }
        if (this.connectedBoundingBox != null) {
            NBTTagCompound connectedBoundingBoxDimensions = new NBTTagCompound();
            connectedBoundingBoxDimensions.func_74780_a("minx", this.connectedBoundingBox.field_72340_a);
            connectedBoundingBoxDimensions.func_74780_a("miny", this.connectedBoundingBox.field_72338_b);
            connectedBoundingBoxDimensions.func_74780_a("minz", this.connectedBoundingBox.field_72339_c);
            connectedBoundingBoxDimensions.func_74780_a("maxx", this.connectedBoundingBox.field_72336_d);
            connectedBoundingBoxDimensions.func_74780_a("maxy", this.connectedBoundingBox.field_72337_e);
            connectedBoundingBoxDimensions.func_74780_a("maxz", this.connectedBoundingBox.field_72334_f);
            nbttagcompound.func_74782_a("connectedBoundingBox", (NBTBase)connectedBoundingBoxDimensions);
        }
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.filterItems = new ItemStack[9];
        if (par1.func_74764_b("facing")) {
            this.facing = par1.func_74762_e("facing");
        }
        if (par1.func_74764_b("priority")) {
            this.priority = par1.func_74762_e("priority");
        }
        if (par1.func_74764_b("markerType")) {
            this.markerType = par1.func_74762_e("markerType");
            if (this.markerType == 7) {
                this.priority = 11;
            }
        }
        if (par1.func_74764_b("elementalAttuner")) {
            float x = 0.0f;
            float y = 0.0f;
            float z = 0.0f;
            boolean success = true;
            NBTTagCompound elementalAttunerLocation = par1.func_74775_l("elementalAttuner");
            if (elementalAttunerLocation.func_74764_b("x")) {
                x = elementalAttunerLocation.func_74760_g("x");
            } else {
                success = false;
            }
            if (success && elementalAttunerLocation.func_74764_b("y")) {
                y = elementalAttunerLocation.func_74760_g("y");
            } else {
                success = false;
            }
            if (success && elementalAttunerLocation.func_74764_b("z")) {
                z = elementalAttunerLocation.func_74760_g("z");
            } else {
                success = false;
            }
            if (success) {
                this.elementalAttuner = new AMVector3(x, y, z);
            }
        }
        if (par1.func_74764_b("filterItems")) {
            NBTTagList filterItemsList = par1.func_150295_c("filterItems", 10);
            this.filterItems = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < filterItemsList.func_74745_c(); ++i) {
                String tag = String.format("ArrayIndex", i);
                NBTTagCompound nbttagcompound1 = filterItemsList.func_150305_b(i);
                byte byte0 = nbttagcompound1.func_74771_c(tag);
                if (byte0 < 0 || byte0 >= this.filterItems.length) continue;
                this.filterItems[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            }
        }
        if (par1.func_74764_b("connectedBoundingBox")) {
            NBTTagCompound connectedBoundingBoxDimensions = par1.func_74775_l("connectedBoundingBox");
            double minx = connectedBoundingBoxDimensions.func_74769_h("minx");
            double miny = connectedBoundingBoxDimensions.func_74769_h("miny");
            double minz = connectedBoundingBoxDimensions.func_74769_h("minz");
            double maxx = connectedBoundingBoxDimensions.func_74769_h("maxx");
            double maxy = connectedBoundingBoxDimensions.func_74769_h("maxy");
            double maxz = connectedBoundingBoxDimensions.func_74769_h("maxz");
            this.connectedBoundingBox = AxisAlignedBB.func_72330_a((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz);
        }
    }

    public int func_70302_i_() {
        if (this.markerType == 3 || this.markerType == 4 || this.markerType == 5 || this.markerType == 6) {
            return 9;
        }
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        if (i > 9) {
            return null;
        }
        return this.filterItems[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.filterItems[i] != null) {
            if (this.filterItems[i].field_77994_a <= j) {
                ItemStack itemstack = this.filterItems[i];
                this.filterItems[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.filterItems[i].func_77979_a(j);
            if (this.filterItems[i].field_77994_a == 0) {
                this.filterItems[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.filterItems[i] != null) {
            ItemStack itemstack = this.filterItems[i];
            this.filterItems[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.filterItems[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Crystal Marker";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        if (this.markerType == 4 || this.markerType == 5) {
            return 128;
        }
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public void linkToHabitat(AMVector3 habLocation, EntityPlayer player) {
        TileEntity te = this.field_145850_b.func_147438_o((int)habLocation.x, (int)habLocation.y, (int)habLocation.z);
        if (te instanceof TileEntityFlickerHabitat) {
            AMVector3 myLocation = new AMVector3(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            boolean setElementalAttuner = false;
            if (myLocation.distanceSqTo(habLocation) <= 400.0) {
                if (BlockCrystalMarker.isInputMarker(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))) {
                    ((TileEntityFlickerHabitat)te).AddMarkerLocationIn(myLocation);
                    setElementalAttuner = true;
                }
                if (BlockCrystalMarker.isOutputMarker(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e))) {
                    ((TileEntityFlickerHabitat)te).AddMarkerLocationOut(myLocation);
                    setElementalAttuner = true;
                }
                if (setElementalAttuner) {
                    this.setElementalAttuner(habLocation);
                }
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.habitatToFar")));
            }
        }
    }

    public int[] func_94128_d(int var1) {
        return new int[0];
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }
}

