/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.AMCore;
import am2.api.blocks.IKeystoneLockable;
import am2.api.power.PowerTypes;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.tileentities.TileEntityAMPower;
import am2.items.ISpellFocus;
import am2.items.ItemFilterFocus;
import am2.models.SpriteRenderInfo;
import am2.network.AMDataWriter;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleMoveOnHeading;
import am2.power.PowerNodeRegistry;
import am2.utility.KeystoneUtilities;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntitySeerStone
extends TileEntityAMPower
implements IInventory,
IKeystoneLockable {
    private boolean hasSight = false;
    private ArrayList<SpriteRenderInfo> animations;
    private ArrayList<Integer> animationWeighting;
    private SpriteRenderInfo currentAnimation;
    private int ticksToNextCheck;
    private int maxTicksToCheck = 20;
    private ItemStack[] inventory;
    int tickCounter = 0;
    public static int keystoneSlot = 1;
    private PowerTypes[] validTypes = new PowerTypes[]{PowerTypes.LIGHT};
    boolean swapDetectionMode = false;

    public TileEntitySeerStone() {
        super(100);
        this.animations = new ArrayList();
        this.animationWeighting = new ArrayList();
        this.animations.add(new SpriteRenderInfo(50, 59, 2));
        this.animationWeighting.add(0);
        this.animations.add(new SpriteRenderInfo(20, 29, 2));
        this.animationWeighting.add(60);
        this.animations.add(new SpriteRenderInfo(30, 39, 2));
        this.animationWeighting.add(11);
        this.animations.add(new SpriteRenderInfo(40, 49, 2));
        this.animationWeighting.add(11);
        this.animations.add(new SpriteRenderInfo(0, 14, 2));
        this.animationWeighting.add(6);
        this.animations.add(new SpriteRenderInfo(60, 74, 2));
        this.animationWeighting.add(6);
        this.animations.add(new SpriteRenderInfo(80, 94, 2));
        this.animationWeighting.add(6);
        this.currentAnimation = this.animations.get(0);
        this.currentAnimation.isDone = true;
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.ticksToNextCheck = this.maxTicksToCheck;
    }

    @Override
    public float particleOffset(int axis) {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (axis == 0) {
            switch (meta) {
                case 6: {
                    return 0.15f;
                }
                case 5: {
                    return 0.85f;
                }
            }
            return 0.5f;
        }
        if (axis == 1) {
            switch (meta) {
                case 1: {
                    return 0.85f;
                }
                case 2: {
                    return 0.2f;
                }
            }
            return 0.5f;
        }
        if (axis == 2) {
            switch (meta) {
                case 4: {
                    return 0.15f;
                }
                case 3: {
                    return 0.85f;
                }
            }
            return 0.5f;
        }
        return 0.5f;
    }

    public void invertDetection() {
        this.swapDetectionMode = !this.swapDetectionMode;
    }

    public boolean isInvertingDetection() {
        return this.swapDetectionMode;
    }

    private SpriteRenderInfo GetWeightedRandomAnimation() {
        this.currentAnimation.reset(false);
        int randomNumber = this.field_145850_b.field_73012_v.nextInt(100);
        int index = 0;
        SpriteRenderInfo current = this.animations.get(0);
        for (Integer i : this.animationWeighting) {
            if (randomNumber < i) {
                current = this.animations.get(index);
                break;
            }
            ++index;
            randomNumber -= i.intValue();
        }
        return current == this.animations.get(0) ? this.animations.get(1) : current;
    }

    public boolean isActive() {
        if (this.field_145850_b == null) {
            return false;
        }
        return PowerNodeRegistry.For(this.field_145850_b).checkPower(this, PowerTypes.LIGHT, this.hasSight ? 2.0f : 1.0f) && this.GetSearchRadius() > 0;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.isActive()) {
            if (this.hasSight) {
                PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.LIGHT, 0.25f);
            } else {
                PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerTypes.LIGHT, 0.125f);
            }
        }
        --this.ticksToNextCheck;
        if (this.ticksToNextCheck <= 0 && this.isActive()) {
            this.ticksToNextCheck = this.maxTicksToCheck;
            long key = KeystoneUtilities.instance.getKeyFromRunes(this.getRunesInKey());
            int radius = this.GetSearchRadius();
            Class searchClass = this.GetSearchClass();
            ArrayList nearbyMobs = new ArrayList();
            if (searchClass != null) {
                nearbyMobs = (ArrayList)this.field_145850_b.func_72872_a(searchClass, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - radius), (double)(this.field_145848_d - radius), (double)(this.field_145849_e - radius), (double)(this.field_145851_c + radius), (double)(this.field_145848_d + radius), (double)(this.field_145849_e + radius)));
                if (key > 0L) {
                    ArrayList<Entity> mobsToIgnore = new ArrayList<Entity>();
                    for (Entity e : nearbyMobs) {
                        if (this.swapDetectionMode) {
                            if (!(e instanceof EntityPlayer)) {
                                mobsToIgnore.add(e);
                                continue;
                            }
                            if (KeystoneUtilities.instance.GetKeysInInvenory((EntityLivingBase)e).contains(key)) continue;
                            mobsToIgnore.add(e);
                            continue;
                        }
                        if (!(e instanceof EntityPlayer) || !KeystoneUtilities.instance.GetKeysInInvenory((EntityLivingBase)e).contains(key)) continue;
                        mobsToIgnore.add(e);
                    }
                    for (Entity e : mobsToIgnore) {
                        nearbyMobs.remove(e);
                    }
                }
            }
            if (nearbyMobs.size() > 0) {
                if (!this.hasSight) {
                    this.hasSight = true;
                    this.notifyNeighborsOfPowerChange();
                    if (this.field_145850_b.field_72995_K) {
                        this.currentAnimation.reset(false);
                        this.currentAnimation = this.animations.get(0);
                        this.currentAnimation.reset(true);
                    }
                }
            } else if (this.hasSight) {
                this.hasSight = false;
                this.notifyNeighborsOfPowerChange();
                if (this.field_145850_b.field_72995_K) {
                    this.currentAnimation.reset(false);
                    this.currentAnimation = this.animations.get(0);
                    this.currentAnimation.reset(false);
                }
            }
        } else if (this.hasSight && !this.isActive()) {
            this.hasSight = false;
            this.notifyNeighborsOfPowerChange();
            if (this.field_145850_b.field_72995_K) {
                this.currentAnimation.reset(false);
                this.currentAnimation = this.animations.get(0);
                this.currentAnimation.reset(false);
            }
        }
        if (this.field_145850_b.field_72995_K) {
            if (!this.currentAnimation.isDone) {
                ++this.tickCounter;
                if (this.tickCounter == this.currentAnimation.speed) {
                    this.tickCounter = 0;
                    this.currentAnimation.incrementIndex();
                }
            } else if (this.isActive() && this.hasSight) {
                this.currentAnimation = this.GetWeightedRandomAnimation();
            }
            if (this.isActive() && this.hasSight) {
                int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                double yaw = 0.0;
                double y = (double)this.field_145848_d + 0.5;
                double x = (double)this.field_145851_c + 0.5;
                double z = (double)this.field_145849_e + 0.5;
                switch (meta) {
                    case 1: {
                        y += 0.3;
                        break;
                    }
                    case 2: {
                        y -= 0.3;
                        break;
                    }
                    case 3: {
                        yaw = 270.0;
                        z += 0.3;
                        break;
                    }
                    case 4: {
                        yaw = 90.0;
                        z -= 0.3;
                        break;
                    }
                    case 5: {
                        yaw = 180.0;
                        x += 0.3;
                        break;
                    }
                    case 6: {
                        yaw = 0.0;
                        x -= 0.3;
                    }
                }
                AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "sparkle2", x, y, z));
                if (effect != null) {
                    effect.setIgnoreMaxAge(false);
                    effect.setMaxAge(35);
                    switch (meta) {
                        case 1: {
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.1f, -0.01f, 1, false));
                            break;
                        }
                        case 2: {
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.1f, 0.01f, 1, false));
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            effect.AddParticleController(new ParticleMoveOnHeading(effect, yaw, 0.0, 0.01f, 1, false));
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.1f, 0.0f, 1, false));
                        }
                    }
                }
            }
        }
    }

    private void notifyNeighborsOfPowerChange() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlocksCommonProxy.seerStone);
        switch (this.func_145832_p()) {
            case 0: {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, BlocksCommonProxy.seerStone);
                break;
            }
            case 1: {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, BlocksCommonProxy.seerStone);
                break;
            }
            case 2: {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, BlocksCommonProxy.seerStone);
                break;
            }
            case 3: {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, BlocksCommonProxy.seerStone);
                break;
            }
            case 4: {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, BlocksCommonProxy.seerStone);
                break;
            }
            case 5: {
                this.field_145850_b.func_147459_d(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, BlocksCommonProxy.seerStone);
                break;
            }
            case 6: {
                this.field_145850_b.func_147459_d(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, BlocksCommonProxy.seerStone);
            }
        }
    }

    public boolean ShouldAnimate() {
        return this.isActive() && this.hasSight || !this.currentAnimation.isDone;
    }

    public int getAnimationIndex() {
        return this.currentAnimation.curFrame;
    }

    private int GetSearchRadius() {
        int tempFocusLevel;
        int focusLevel = -1;
        int inventoryIndex = 0;
        if (this.inventory[inventoryIndex] != null && this.inventory[inventoryIndex].func_77973_b() instanceof ISpellFocus && (tempFocusLevel = ((ISpellFocus)this.inventory[inventoryIndex].func_77973_b()).getFocusLevel()) > focusLevel) {
            focusLevel = tempFocusLevel;
        }
        int radius = (focusLevel + 1) * 5;
        return radius;
    }

    private Class GetSearchClass() {
        if (this.inventory[1] != null && this.inventory[1].func_77973_b() instanceof ItemFilterFocus) {
            return ((ItemFilterFocus)this.inventory[1].func_77973_b()).getFilterClass();
        }
        return null;
    }

    public boolean HasSight() {
        return this.isActive() && this.hasSight;
    }

    public int func_70302_i_() {
        return 5;
    }

    @Override
    public ItemStack[] getRunesInKey() {
        ItemStack[] runes = new ItemStack[]{this.inventory[2], this.inventory[3], this.inventory[4]};
        return runes;
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Seer Stone";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.swapDetectionMode = nbttagcompound.func_74767_n("seerStoneIsInverting");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("SeerStoneInventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74757_a("seerStoneIsInverting", this.isInvertingDetection());
        nbttagcompound.func_74782_a("SeerStoneInventory", (NBTBase)nbttaglist);
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    private void writeInventory(AMDataWriter writer) {
        for (ItemStack stack : this.inventory) {
            if (stack == null) {
                writer.add(false);
                continue;
            }
            writer.add(true);
            writer.add(stack);
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public int getChargeRate() {
        return 20;
    }

    @Override
    public PowerTypes[] getValidPowerTypes() {
        return this.validTypes;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }
}

