/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.items.IBoundItem;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.ExtendedProperties;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.texture.ResourceManager;
import am2.utility.InventoryUtilities;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.world.World;

public class ItemBoundSword
extends ItemSword
implements IBoundItem {
    public ItemBoundSword(Item.ToolMaterial par2ToolMaterial) {
        super(par2ToolMaterial);
        this.func_77656_e(0);
    }

    public ItemBoundSword setUnlocalizedAndTextureName(String name) {
        this.func_77655_b(name);
        this.func_111206_d(name);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = ResourceManager.RegisterTexture("bound_sword", par1IconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        this.UnbindItem(item, player, player.field_71071_by.field_70461_c);
        return false;
    }

    @Override
    public float maintainCost() {
        if (Enum.valueOf(Item.ToolMaterial.class, this.func_150932_j()) == Item.ToolMaterial.STONE) {
            return 0.1f;
        }
        if (Enum.valueOf(Item.ToolMaterial.class, this.func_150932_j()) == Item.ToolMaterial.IRON) {
            return 0.4f;
        }
        if (Enum.valueOf(Item.ToolMaterial.class, this.func_150932_j()) == Item.ToolMaterial.EMERALD) {
            return 1.0f;
        }
        return 0.0f;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int slotIndex, boolean par5) {
        if (par3Entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par3Entity;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            ExtendedProperties props = ExtendedProperties.For((EntityLivingBase)player);
            if (props.getCurrentMana() + props.getBonusCurrentMana() < this.maintainCost()) {
                this.UnbindItem(par1ItemStack, (EntityPlayer)par3Entity, slotIndex);
                return;
            }
            props.deductMana(this.maintainCost());
            if (par1ItemStack.func_77960_j() > 0) {
                par1ItemStack.func_77972_a(-1, (EntityLivingBase)par3Entity);
            }
        }
    }

    @Override
    public void UnbindItem(ItemStack itemstack, EntityPlayer player, int inventorySlot) {
        itemstack = InventoryUtilities.replaceItem(itemstack, ItemsCommonProxy.spell);
        player.field_71071_by.func_70299_a(inventorySlot, itemstack);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.func_70093_af() && stack.func_77942_o() && entity instanceof EntityLivingBase) {
            ItemStack castStack = this.getApplicationStack(stack);
            SpellHelper.instance.applyStackStage(castStack, (EntityLivingBase)player, (EntityLivingBase)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0, player.field_70170_p, true, true, 0);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    private ItemStack getApplicationStack(ItemStack boundStack) {
        ItemStack castStack = SpellUtils.instance.constructSpellStack(boundStack.func_77946_l());
        castStack = SpellUtils.instance.popStackStage(castStack);
        castStack = InventoryUtilities.replaceItem(castStack, ItemsCommonProxy.spell);
        return castStack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (stack.func_77942_o()) {
            ItemStack castStack = this.getApplicationStack(stack);
            SpellHelper.instance.applyStackStageOnUsing(castStack, (EntityLivingBase)player, null, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70170_p, true, true, count);
        }
        super.onUsingTick(stack, player, count);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

