/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.AMCore;
import am2.api.spell.ItemSpellBase;
import am2.containers.InventorySpellBook;
import am2.enchantments.AMEnchantmentHelper;
import am2.enchantments.AMEnchantments;
import am2.items.ArsMagicaItem;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.SkillData;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import am2.texture.ResourceManager;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSpellBook
extends ArsMagicaItem {
    public static final byte ID_NEXT_SPELL = 0;
    public static final byte ID_PREV_SPELL = 1;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] npc_icons;
    private final String[] npc_textureFiles = new String[]{"affinity_tome_general", "affinity_tome_ice", "affinity_tome_life", "affinity_tome_fire", "affinity_tome_lightning", "affinity_tome_ender"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] player_icons;
    private final String[] player_textureFiles = new String[]{"spell_book_cover", "spell_book_decoration"};

    public ItemSpellBook() {
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        int i;
        this.npc_icons = new IIcon[this.npc_textureFiles.length];
        for (i = 0; i < this.npc_textureFiles.length; ++i) {
            this.npc_icons[i] = ResourceManager.RegisterTexture(this.npc_textureFiles[i], par1IconRegister);
        }
        this.player_icons = new IIcon[this.player_textureFiles.length];
        for (i = 0; i < this.player_textureFiles.length; ++i) {
            this.player_icons[i] = ResourceManager.RegisterTexture(this.player_textureFiles[i], par1IconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        switch (par1) {
            case 6: {
                return this.npc_icons[3];
            }
            case 11: {
                return this.npc_icons[4];
            }
            case 5: {
                return this.npc_icons[5];
            }
            case 1: {
                return this.npc_icons[0];
            }
            case 8: {
                return this.npc_icons[1];
            }
            case 4: {
                return this.npc_icons[2];
            }
        }
        return this.npc_icons[0];
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        ItemStack activeSpell = this.GetActiveItemStack(par1ItemStack);
        if (activeSpell != null) {
            return String.format("\u00a77%s (" + activeSpell.func_82833_r() + "\u00a77)", StatCollector.func_74838_a((String)"item.arsmagica2:spellBook.name"));
        }
        return StatCollector.func_74838_a((String)"item.arsmagica2:spellBook.name");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int damage, int renderPass) {
        if (renderPass == 0) {
            return this.player_icons[0];
        }
        return this.player_icons[1];
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int renderPass) {
        int meta = par1ItemStack.func_77960_j();
        if (renderPass == 0) {
            switch (meta) {
                case 0: {
                    return 7621652;
                }
                case 1: {
                    return 1497545;
                }
                case 2: {
                    return 0x9B9B9B;
                }
                case 3: {
                    return 5740747;
                }
                case 4: {
                    return 0xFFFFFF;
                }
                case 5: {
                    return 0;
                }
                case 6: {
                    return 14582551;
                }
                case 7: {
                    return 10950844;
                }
                case 8: {
                    return 725503;
                }
                case 9: {
                    return 0x1BBF1B;
                }
                case 10: {
                    return 15260969;
                }
                case 11: {
                    return 14554903;
                }
                case 12: {
                    return 65292;
                }
                case 13: {
                    return 16761035;
                }
                case 14: {
                    return 0xFF00FF;
                }
                case 15: {
                    return 0xD4D4D4;
                }
            }
            return 7621652;
        }
        return 0xFFFFFF;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        if (this.func_77626_a(itemstack) == 0) {
            return EnumAction.none;
        }
        return EnumAction.block;
    }

    public final int func_77626_a(ItemStack itemstack) {
        ItemSpellBase scroll = this.GetActiveScroll(itemstack);
        if (scroll != null) {
            return scroll.func_77626_a(itemstack);
        }
        return 0;
    }

    public ItemStack func_77659_a(ItemStack bookstack, World world, EntityPlayer entityplayer) {
        if (entityplayer.func_70093_af()) {
            FMLNetworkHandler.openGui((EntityPlayer)entityplayer, (Object)AMCore.instance, (int)4, (World)world, (int)((int)entityplayer.field_70165_t), (int)((int)entityplayer.field_70163_u), (int)((int)entityplayer.field_70161_v));
            return bookstack;
        }
        entityplayer.func_71008_a(bookstack, this.func_77626_a(bookstack));
        return bookstack;
    }

    private ItemStack[] getMyInventory(ItemStack itemStack) {
        return this.ReadFromStackTagCompound(itemStack);
    }

    public ItemStack[] getActiveScrollInventory(ItemStack bookStack) {
        ItemStack[] inventoryItems = this.getMyInventory(bookStack);
        ItemStack[] returnArray = new ItemStack[8];
        for (int i = 0; i < 8; ++i) {
            returnArray[i] = inventoryItems[i];
        }
        return returnArray;
    }

    public ItemSpellBase GetActiveScroll(ItemStack bookStack) {
        ItemStack[] inventoryItems = this.getMyInventory(bookStack);
        if (inventoryItems[this.GetActiveSlot(bookStack)] == null) {
            return null;
        }
        return (ItemSpellBase)inventoryItems[this.GetActiveSlot(bookStack)].func_77973_b();
    }

    public ItemStack GetActiveItemStack(ItemStack bookStack) {
        ItemStack[] inventoryItems = this.getMyInventory(bookStack);
        if (inventoryItems[this.GetActiveSlot(bookStack)] == null) {
            return null;
        }
        return inventoryItems[this.GetActiveSlot(bookStack)].func_77946_l();
    }

    public void replaceAciveItemStack(ItemStack bookStack, ItemStack newstack) {
        ItemStack[] inventoryItems = this.getMyInventory(bookStack);
        int index = this.GetActiveSlot(bookStack);
        inventoryItems[index] = newstack;
        this.UpdateStackTagCompound(bookStack, inventoryItems);
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
        if (entityplayer.func_70093_af()) {
            FMLNetworkHandler.openGui((EntityPlayer)entityplayer, (Object)AMCore.instance, (int)4, (World)world, (int)((int)entityplayer.field_70165_t), (int)((int)entityplayer.field_70163_u), (int)((int)entityplayer.field_70161_v));
        } else {
            ItemStack currentSpellStack = this.GetActiveItemStack(itemstack);
            if (currentSpellStack != null) {
                ItemsCommonProxy.spell.func_77615_a(currentSpellStack, world, entityplayer, i);
            }
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer entityplayer, World world, int X, int Y, int Z, int side, float par8, float par9, float par10) {
        return false;
    }

    public void UpdateStackTagCompound(ItemStack itemStack, ItemStack[] values) {
        boolean Soulbound;
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < values.length; ++i) {
            ItemStack stack = values[i];
            NBTTagCompound spell = new NBTTagCompound();
            if (stack == null) continue;
            spell.func_74768_a("meta", stack.func_77960_j());
            spell.func_74768_a("index", i);
            if (stack.field_77990_d != null) {
                spell.func_74782_a("data", (NBTBase)stack.field_77990_d);
            }
            list.func_74742_a((NBTBase)spell);
        }
        itemStack.field_77990_d.func_74782_a("spell_book_inventory", (NBTBase)list);
        ItemStack active = this.GetActiveItemStack(itemStack);
        boolean bl = Soulbound = EnchantmentHelper.func_77506_a((int)AMEnchantments.soulbound.field_77352_x, (ItemStack)itemStack) > 0;
        if (active != null) {
            AMEnchantmentHelper.copyEnchantments(active, itemStack);
        }
        if (Soulbound) {
            AMEnchantmentHelper.soulbindStack(itemStack);
        }
    }

    public void SetActiveSlot(ItemStack itemStack, int slot) {
        boolean Soulbound;
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (slot < 0) {
            slot = 0;
        }
        if (slot > 7) {
            slot = 7;
        }
        itemStack.field_77990_d.func_74768_a("spellbookactiveslot", slot);
        ItemStack active = this.GetActiveItemStack(itemStack);
        boolean bl = Soulbound = EnchantmentHelper.func_77506_a((int)AMEnchantments.soulbound.field_77352_x, (ItemStack)itemStack) > 0;
        if (active != null) {
            AMEnchantmentHelper.copyEnchantments(active, itemStack);
        }
        if (Soulbound) {
            AMEnchantmentHelper.soulbindStack(itemStack);
        }
    }

    public int SetNextSlot(ItemStack itemStack) {
        int slot;
        int newSlot = slot = this.GetActiveSlot(itemStack);
        do {
            if (++newSlot > 7) {
                newSlot = 0;
            }
            this.SetActiveSlot(itemStack, newSlot);
        } while (this.GetActiveScroll(itemStack) == null && newSlot != slot);
        return slot;
    }

    public int SetPrevSlot(ItemStack itemStack) {
        int slot;
        int newSlot = slot = this.GetActiveSlot(itemStack);
        do {
            if (--newSlot < 0) {
                newSlot = 7;
            }
            this.SetActiveSlot(itemStack, newSlot);
        } while (this.GetActiveScroll(itemStack) == null && newSlot != slot);
        return slot;
    }

    public int GetActiveSlot(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            this.SetActiveSlot(itemStack, 0);
            return 0;
        }
        return itemStack.field_77990_d.func_74762_e("spellbookactiveslot");
    }

    public ItemStack[] ReadFromStackTagCompound(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return new ItemStack[InventorySpellBook.inventorySize];
        }
        ItemStack[] items = new ItemStack[InventorySpellBook.inventorySize];
        NBTTagList list = itemStack.field_77990_d.func_150295_c("spell_book_inventory", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound spell = list.func_150305_b(i);
            int meta = spell.func_74762_e("meta");
            NBTTagCompound tag = spell.func_74775_l("data");
            int index = spell.func_74762_e("index");
            items[index] = new ItemStack((Item)ItemsCommonProxy.spell, 1, meta);
            items[index].func_77982_d(tag);
        }
        return items;
    }

    public InventorySpellBook ConvertToInventory(ItemStack bookStack) {
        InventorySpellBook isb = new InventorySpellBook();
        isb.SetInventoryContents(this.getMyInventory(bookStack));
        return isb;
    }

    public boolean func_77651_p() {
        return true;
    }

    public String GetActiveSpellName(ItemStack bookStack) {
        ItemStack stack = this.GetActiveItemStack(bookStack);
        if (stack == null) {
            return StatCollector.func_74838_a((String)"am2.tooltip.none");
        }
        return stack.func_82833_r();
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        ItemSpellBase activeScroll = this.GetActiveScroll(par1ItemStack);
        ItemStack stack = this.GetActiveItemStack(par1ItemStack);
        String s = StatCollector.func_74838_a((String)"am2.tooltip.open");
        par3List.add("\u00a77" + s);
        if (activeScroll != null) {
            activeScroll.func_77624_a(stack, par2EntityPlayer, par3List, par4);
        }
        par3List.add("\u00a7c" + StatCollector.func_74838_a((String)"am2.tooltip.spellbookWarning1") + "\u00a7f");
        par3List.add("\u00a7c" + StatCollector.func_74838_a((String)"am2.tooltip.spellbookWarning2") + "\u00a7f");
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        ItemStack scrollStack = this.GetActiveItemStack(stack);
        if (scrollStack != null) {
            ItemsCommonProxy.spell.onUsingTick(scrollStack, player, count);
        }
    }

    public boolean isBookEnchantable(ItemStack bookStack, ItemStack enchantBook) {
        Map enchantMap = EnchantmentHelper.func_82781_a((ItemStack)enchantBook);
        for (Object o : enchantMap.keySet()) {
            if (!(o instanceof Integer)) continue;
            AMEnchantments cfr_ignored_0 = AMCore.proxy.enchantments;
            if ((Integer)o != AMEnchantments.soulbound.field_77352_x) continue;
            return true;
        }
        return false;
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.func_77663_a(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).func_71011_bu()) != null && usingItem.func_77973_b() == this && SkillData.For((EntityPlayer)player).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("SpellMotion")))) {
            player.field_71158_b.field_78900_b *= 2.5f;
            player.field_71158_b.field_78902_a *= 2.5f;
        }
    }
}

