/*
 * Decompiled with CFR 0.152.
 */
package am2.lore;

import am2.guis.AMGuiIcons;
import am2.items.ItemsCommonProxy;
import am2.lore.CompendiumEntryBlock;
import am2.lore.CompendiumEntryBoss;
import am2.lore.CompendiumEntryGuide;
import am2.lore.CompendiumEntryItem;
import am2.lore.CompendiumEntryMechanic;
import am2.lore.CompendiumEntryMob;
import am2.lore.CompendiumEntryRitual;
import am2.lore.CompendiumEntrySpellComponent;
import am2.lore.CompendiumEntrySpellModifier;
import am2.lore.CompendiumEntrySpellShape;
import am2.lore.CompendiumEntryStructure;
import am2.lore.CompendiumEntryTalent;
import am2.lore.CompendiumEntryType;
import am2.texture.SpellIconManager;

public class CompendiumEntryTypes {
    public final CompendiumEntryType GUIDE = new CompendiumEntryType("guides", "guide", "Guides", 0, CompendiumEntryGuide.class);
    public final CompendiumEntryType MECHANIC = new CompendiumEntryType("mechanics", "mechanic", "Mechanics", 1, CompendiumEntryMechanic.class);
    public final CompendiumEntryType ITEM = new CompendiumEntryType("items", "item", "Items", 2, CompendiumEntryItem.class);
    public final CompendiumEntryType BLOCK = new CompendiumEntryType("blocks", "block", "Blocks", 3, CompendiumEntryBlock.class);
    public final CompendiumEntryType SPELL_SHAPE = new CompendiumEntryType("shapes", "shape", "Shapes", 4, CompendiumEntrySpellShape.class);
    public final CompendiumEntryType SPELL_COMPONENT = new CompendiumEntryType("components", "component", "Components", 5, CompendiumEntrySpellComponent.class);
    public final CompendiumEntryType SPELL_MODIFIER = new CompendiumEntryType("modifiers", "modifier", "Modifiers", 6, CompendiumEntrySpellModifier.class);
    public final CompendiumEntryType TALENT = new CompendiumEntryType("talents", "talent", "Talents", 7, CompendiumEntryTalent.class);
    public final CompendiumEntryType MOB = new CompendiumEntryType("mobs", "mob", "Mobs", 8, CompendiumEntryMob.class);
    public final CompendiumEntryType STRUCTURE = new CompendiumEntryType("structures", "structure", "Structures", 9, CompendiumEntryStructure.class);
    public final CompendiumEntryType RITUAL = new CompendiumEntryType("structures", "ritual", "Structures", 9, CompendiumEntryRitual.class);
    public final CompendiumEntryType BOSS = new CompendiumEntryType("bosses", "boss", "Bosses", 10, CompendiumEntryBoss.class);
    public static final CompendiumEntryTypes instance = new CompendiumEntryTypes();
    private boolean initialized = false;

    public boolean hasInitialized() {
        return this.initialized;
    }

    public static CompendiumEntryType[] categoryList() {
        return new CompendiumEntryType[]{CompendiumEntryTypes.instance.GUIDE, CompendiumEntryTypes.instance.MECHANIC, CompendiumEntryTypes.instance.ITEM, CompendiumEntryTypes.instance.BLOCK, CompendiumEntryTypes.instance.SPELL_SHAPE, CompendiumEntryTypes.instance.SPELL_COMPONENT, CompendiumEntryTypes.instance.SPELL_MODIFIER, CompendiumEntryTypes.instance.TALENT, CompendiumEntryTypes.instance.MOB, CompendiumEntryTypes.instance.STRUCTURE, CompendiumEntryTypes.instance.BOSS};
    }

    private static CompendiumEntryType[] allValues() {
        return new CompendiumEntryType[]{CompendiumEntryTypes.instance.GUIDE, CompendiumEntryTypes.instance.MECHANIC, CompendiumEntryTypes.instance.ITEM, CompendiumEntryTypes.instance.BLOCK, CompendiumEntryTypes.instance.SPELL_SHAPE, CompendiumEntryTypes.instance.SPELL_COMPONENT, CompendiumEntryTypes.instance.SPELL_MODIFIER, CompendiumEntryTypes.instance.TALENT, CompendiumEntryTypes.instance.MOB, CompendiumEntryTypes.instance.STRUCTURE, CompendiumEntryTypes.instance.RITUAL, CompendiumEntryTypes.instance.BOSS};
    }

    public void initTextures() {
        this.GUIDE.setRepresentIcon(ItemsCommonProxy.arcaneCompendium.func_77617_a(0));
        this.MECHANIC.setRepresentIcon(ItemsCommonProxy.magitechGoggles.func_77617_a(0));
        this.ITEM.setRepresentIcon(ItemsCommonProxy.essence.func_77617_a(6));
        this.BLOCK.setRepresentIcon(ItemsCommonProxy.crystalWrench.func_77617_a(0));
        this.SPELL_SHAPE.setRepresentIcon(SpellIconManager.instance.getIcon("Binding"));
        this.SPELL_COMPONENT.setRepresentIcon(SpellIconManager.instance.getIcon("LifeTap"));
        this.SPELL_MODIFIER.setRepresentIcon(SpellIconManager.instance.getIcon("VelocityAdded"));
        this.TALENT.setRepresentIcon(SpellIconManager.instance.getIcon("AugmentedCasting"));
        this.MOB.setRepresentIcon(AMGuiIcons.fatigueIcon);
        this.STRUCTURE.setRepresentIcon(AMGuiIcons.gatewayPortal);
        this.RITUAL.setRepresentIcon(AMGuiIcons.gatewayPortal);
        this.BOSS.setRepresentIcon(AMGuiIcons.evilBook);
        this.initialized = true;
    }

    public static CompendiumEntryType getForSection(String category, String node) {
        for (CompendiumEntryType type : instance.allValues()) {
            if (!type.getCategoryName().equals(category) || !type.getNodeName().equals(node)) continue;
            return type;
        }
        return null;
    }
}

