/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.particles.AMParticle;
import am2.particles.ParticleColorShift;
import am2.particles.ParticleController;
import am2.utility.MathUtilities;
import net.minecraft.entity.Entity;

public class ParticleArcToEntity
extends ParticleController {
    private AMVector3 start;
    private Entity target;
    private AMVector3 firstControl;
    private AMVector3 secondControl;
    private float percent;
    private float speed;
    private float offsetFactor;
    private float halfOffsetFactor;

    public ParticleArcToEntity(AMParticle particleEffect, int priority, double startX, double startY, double startZ, Entity target, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.start = new AMVector3(startX, startY, startZ);
        this.percent = 0.0f;
        this.speed = 0.03f;
        this.offsetFactor = 10.0f;
        this.halfOffsetFactor = this.offsetFactor / 2.0f;
        this.target = target;
        this.generateControlPoints();
    }

    public ParticleArcToEntity(AMParticle particleEffect, int priority, Entity target, boolean exclusive) {
        this(particleEffect, priority, particleEffect.field_70165_t, particleEffect.field_70163_u, particleEffect.field_70161_v, target, exclusive);
    }

    public ParticleArcToEntity generateControlPoints() {
        this.firstControl = new AMVector3((double)this.start.x + (this.target.field_70165_t - (double)this.start.x) / 3.0, (double)this.start.y + (this.target.field_70163_u - (double)this.start.y) / 3.0, (double)this.start.z + (this.target.field_70161_v - (double)this.start.z) / 3.0);
        this.secondControl = new AMVector3((double)this.start.x + (this.target.field_70165_t - (double)this.start.x) / 3.0 * 2.0, (double)this.start.y + (this.target.field_70163_u - (double)this.start.y) / 3.0 * 2.0, (double)this.start.z + (this.target.field_70161_v - (double)this.start.z) / 3.0 * 2.0);
        double offsetX = this.particle.field_70170_p.field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double offsetZ = this.particle.field_70170_p.field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        AMVector3 offset = new AMVector3(offsetX, 0.0, offsetZ);
        this.firstControl = this.firstControl.add(offset);
        this.secondControl = this.secondControl.add(offset);
        return this;
    }

    private void addParticleAtPoint(AMVector3 point) {
        AMParticle p = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.particle.field_70170_p, "hr_smoke", point.x, point.y, point.z));
        if (p != null) {
            p.setIgnoreMaxAge(false);
            p.setMaxAge(200);
            p.setParticleScale(1.5f);
            p.AddParticleController(new ParticleColorShift(p, 1, false));
        }
    }

    public ParticleArcToEntity specifyControlPoints(AMVector3 first, AMVector3 second) {
        this.firstControl = first;
        this.secondControl = second;
        return this;
    }

    public ParticleArcToEntity SetSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    @Override
    public void doUpdate() {
        this.percent += this.speed;
        if (this.percent >= 1.0f) {
            this.finish();
            return;
        }
        AMVector3 bez = MathUtilities.bezier(this.start, this.firstControl, this.secondControl, new AMVector3(this.target).add(new AMVector3(0.0, this.target.func_70047_e(), 0.0)), this.percent);
        this.particle.func_70107_b(bez.x, bez.y, bez.z);
    }

    @Override
    public ParticleController clone() {
        return new ParticleArcToEntity(this.particle, this.priority, this.target, this.exclusive).SetSpeed(this.speed).specifyControlPoints(this.firstControl, this.secondControl);
    }
}

