/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.api.math.AMVector3;
import am2.particles.AMParticle;
import am2.particles.ParticleController;
import am2.utility.MathUtilities;

public class ParticleArcToPoint
extends ParticleController {
    private final AMVector3 start;
    private final AMVector3 target;
    private AMVector3 firstControl;
    private AMVector3 secondControl;
    private float percent;
    private float speed;
    private final float offsetFactor;
    private final float halfOffsetFactor;

    public ParticleArcToPoint(AMParticle particleEffect, int priority, double startX, double startY, double startZ, double endX, double endY, double endZ, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.start = new AMVector3(startX, startY, startZ);
        this.target = new AMVector3(endX, endY, endZ);
        this.percent = 0.0f;
        this.speed = 0.03f;
        this.offsetFactor = 10.0f;
        this.halfOffsetFactor = this.offsetFactor / 2.0f;
        this.generateControlPoints();
    }

    public ParticleArcToPoint(AMParticle particleEffect, int priority, double endX, double endY, double endZ, boolean exclusive) {
        this(particleEffect, priority, particleEffect.field_70165_t, particleEffect.field_70163_u, particleEffect.field_70161_v, endX, endY, endZ, exclusive);
    }

    public ParticleArcToPoint generateControlPoints() {
        this.firstControl = new AMVector3(this.start.x + (this.target.x - this.start.x) / 3.0f, this.start.y + (this.target.y - this.start.y) / 3.0f, this.start.z + (this.target.z - this.start.z) / 3.0f);
        this.secondControl = new AMVector3(this.start.x + (this.target.x - this.start.x) / 3.0f * 2.0f, this.start.y + (this.target.y - this.start.y) / 3.0f * 2.0f, this.start.z + (this.target.z - this.start.z) / 3.0f * 2.0f);
        double offsetX = this.particle.field_70170_p.field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double offsetZ = this.particle.field_70170_p.field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double offsetY = this.particle.field_70170_p.field_73012_v.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        AMVector3 offset = new AMVector3(offsetX, offsetY, offsetZ);
        this.firstControl = this.firstControl.add(offset);
        this.secondControl = this.secondControl.add(offset);
        return this;
    }

    public ParticleArcToPoint specifyControlPoints(AMVector3 first, AMVector3 second) {
        this.firstControl = first;
        this.secondControl = second;
        return this;
    }

    public ParticleArcToPoint SetSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    @Override
    public void doUpdate() {
        this.percent += this.speed;
        if (this.percent >= 1.0f) {
            this.finish();
            return;
        }
        AMVector3 bez = MathUtilities.bezier(this.start, this.firstControl, this.secondControl, this.target, this.percent);
        this.particle.func_70107_b(bez.x, bez.y, bez.z);
    }

    @Override
    public ParticleController clone() {
        return new ParticleArcToPoint(this.particle, this.priority, this.target.x, this.target.y, this.target.z, this.exclusive).SetSpeed(this.speed).specifyControlPoints(this.firstControl, this.secondControl);
    }
}

