/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.AMCore;
import am2.particles.AMParticle;
import am2.particles.ParticleController;
import java.util.ArrayList;

public class ParticleLeaveParticleTrail
extends ParticleController {
    private int ticksBetweenSpawns = 2;
    private int updateTicks;
    private final String particleName;
    private final boolean ignoreMaxAge;
    private final int maxAge;
    private float r;
    private float g;
    private float b;
    private final ArrayList<ParticleController> controllers = new ArrayList();
    private float offsetX;
    private float offsetY;
    private float offsetZ;
    private boolean childAffectedByGravity = false;

    public ParticleLeaveParticleTrail(AMParticle particleEffect, String particleName, boolean ignoreMaxAge, int maxAge, int priority, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.particleName = particleName;
        this.ignoreMaxAge = ignoreMaxAge;
        this.maxAge = maxAge;
        this.updateTicks = 0;
        this.g = 1.0f;
        this.b = 1.0f;
        this.r = 1.0f;
    }

    public ParticleLeaveParticleTrail setChildAffectedByGravity() {
        this.childAffectedByGravity = true;
        return this;
    }

    public ParticleLeaveParticleTrail setTicksBetweenSpawns(int ticks) {
        this.ticksBetweenSpawns = ticks;
        return this;
    }

    public ParticleLeaveParticleTrail addControllerToParticleList(ParticleController controller) {
        this.controllers.add(controller);
        return this;
    }

    public ParticleLeaveParticleTrail setParticleRGB_F(float red, float green, float blue) {
        this.r = red;
        this.g = green;
        this.b = blue;
        return this;
    }

    public ParticleLeaveParticleTrail setParticleRGB_I(int color) {
        this.r = (float)(color >> 16 & 0xFF) / 255.0f;
        this.g = (float)(color >> 8 & 0xFF) / 255.0f;
        this.b = (float)(color & 0xFF) / 255.0f;
        return this;
    }

    public ParticleLeaveParticleTrail addRandomOffset(float x, float y, float z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    @Override
    public void doUpdate() {
        ++this.updateTicks;
        if (this.updateTicks == this.ticksBetweenSpawns) {
            this.updateTicks = 0;
            AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.particle.field_70170_p, this.particleName, this.particle.field_70165_t, this.particle.field_70163_u, this.particle.field_70161_v));
            if (effect != null) {
                effect.setMaxAge(this.maxAge);
                effect.setIgnoreMaxAge(this.ignoreMaxAge);
                effect.setRGBColorF(this.r, this.g, this.b);
                effect.addRandomOffset(this.offsetX, this.offsetY, this.offsetZ);
                if (this.childAffectedByGravity) {
                    effect.setAffectedByGravity();
                }
                for (ParticleController pmc : this.controllers) {
                    effect.AddParticleController(pmc.clone().setKillParticleOnFinish(pmc.getKillParticleOnFinish()).targetNewParticle(effect));
                }
            }
        }
    }

    @Override
    public ParticleController clone() {
        ParticleLeaveParticleTrail clone = new ParticleLeaveParticleTrail(this.particle, this.particleName, this.ignoreMaxAge, this.maxAge, this.priority, this.exclusive).setParticleRGB_F(this.r, this.g, this.b).setTicksBetweenSpawns(this.ticksBetweenSpawns).addRandomOffset(this.offsetX, this.offsetY, this.offsetZ);
        for (ParticleController pmc : this.controllers) {
            clone.addControllerToParticleList(pmc);
        }
        if (this.childAffectedByGravity) {
            clone.setChildAffectedByGravity();
        }
        return clone;
    }
}

