/*
 * Decompiled with CFR 0.152.
 */
package am2.proxy.tick;

import am2.AMCore;
import am2.EntityItemWatcher;
import am2.LogHelper;
import am2.MeteorSpawnHelper;
import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.api.power.PowerTypes;
import am2.api.spell.ItemSpellBase;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.armor.ArmorHelper;
import am2.bosses.BossSpawnHelper;
import am2.commands.ConfigureAMUICommand;
import am2.guis.AMGuiHelper;
import am2.guis.AMIngameGUI;
import am2.guis.GuiHudCustomization;
import am2.items.ItemSpellBook;
import am2.items.ItemsCommonProxy;
import am2.lore.ArcaneCompendium;
import am2.lore.CompendiumEntryTypes;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.particles.AMLineArc;
import am2.playerextensions.ExtendedProperties;
import am2.power.PowerNodeEntry;
import am2.spell.SpellUtils;
import am2.spell.components.Telekinesis;
import am2.utility.DimensionUtilities;
import am2.worldgen.RetroactiveWorldgenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class ClientTickHandler {
    private final AMIngameGUI inGameGui = new AMIngameGUI();
    public static HashMap<EntityLiving, EntityLivingBase> targetsToSet = new HashMap();
    private int mouseWheelValue = 0;
    private int currentSlot = -1;
    private boolean usingItem;
    public static String worldName;
    private boolean firstTick = true;
    private boolean compendiumLoad;
    private ArrayList<AMLineArc> arcs = new ArrayList();
    private int arcSpawnCounter = 0;
    private final int arcSpawnFrequency = 95;
    private int powerWatchSyncTick = 0;
    private AMVector3 powerWatch = AMVector3.zero();
    private boolean hasSynced = false;
    private PowerNodeEntry powerData = null;
    private String lastWorldName;

    private void gameTick_Start() {
        if (!CompendiumEntryTypes.instance.hasInitialized()) {
            CompendiumEntryTypes.instance.initTextures();
        }
        if (Minecraft.func_71410_x().func_71387_A()) {
            if (worldName == null || !worldName.equals(Minecraft.func_71410_x().func_71401_C().func_71221_J().replace(" ", "_"))) {
                worldName = Minecraft.func_71410_x().func_71401_C().func_71221_J().replace(" ", "_");
                this.firstTick = true;
            }
        } else if (worldName != null && (this.lastWorldName == null || this.lastWorldName != worldName.replace(" ", "_"))) {
            this.lastWorldName = worldName.replace(" ", "_");
            this.firstTick = true;
        }
        if (this.firstTick) {
            ItemsCommonProxy.crystalPhylactery.getSpawnableEntities((World)Minecraft.func_71410_x().field_71441_e);
            this.compendiumLoad = true;
            this.firstTick = false;
        }
        if (this.compendiumLoad) {
            ArcaneCompendium.instance.loadUnlockData();
            this.compendiumLoad = false;
        }
        AMCore.proxy.itemFrameWatcher.checkWatchedFrames();
    }

    private void applyDeferredPotionEffects() {
        for (EntityLivingBase ent : AMCore.proxy.getDeferredPotionEffects().keySet()) {
            ArrayList<PotionEffect> potions = AMCore.proxy.getDeferredPotionEffects().get(ent);
            for (PotionEffect effect : potions) {
                ent.func_70690_d(effect);
            }
        }
        AMCore.proxy.clearDeferredPotionEffects();
    }

    private void applyDeferredDimensionTransfers() {
        for (EntityLivingBase ent : AMCore.proxy.getDeferredDimensionTransfers().keySet()) {
            DimensionUtilities.doDimensionTransfer(ent, AMCore.proxy.getDeferredDimensionTransfers().get(ent));
        }
        AMCore.proxy.clearDeferredDimensionTransfers();
    }

    private void gameTick_End() {
        AMGuiHelper.instance.tick();
        EntityItemWatcher.instance.tick();
        this.checkMouseDWheel();
        if (Minecraft.func_71410_x().func_71387_A()) {
            MeteorSpawnHelper.instance.tick();
            this.applyDeferredPotionEffects();
        }
        if (!this.powerWatch.equals(AMVector3.zero())) {
            if (this.powerWatchSyncTick++ == 0) {
                AMNetHandler.INSTANCE.sendPowerRequestToServer(this.powerWatch);
            }
            this.powerWatchSyncTick %= 20;
        }
    }

    private void spawnPowerPathVisuals() {
        if (Minecraft.func_71410_x().field_71439_g.func_82169_q(3) != null && (Minecraft.func_71410_x().field_71439_g.func_82169_q(3).func_77973_b() == ItemsCommonProxy.magitechGoggles || ArmorHelper.isInfusionPreset(Minecraft.func_71410_x().field_71439_g.func_82169_q(3), "mg_gog"))) {
            if (this.arcSpawnCounter++ >= 95) {
                this.arcSpawnCounter = 0;
                AMVector3 playerPos = new AMVector3((Entity)Minecraft.func_71410_x().field_71439_g);
                HashMap<PowerTypes, ArrayList<LinkedList<AMVector3>>> paths = AMCore.proxy.getPowerPathVisuals();
                if (paths != null) {
                    for (PowerTypes type : paths.keySet()) {
                        String texture = type == PowerTypes.LIGHT ? "textures/blocks/oreblockbluetopaz.png" : (type == PowerTypes.NEUTRAL ? "textures/blocks/oreblockvinteum.png" : (type == PowerTypes.DARK ? "textures/blocks/oreblocksunstone.png" : "textures/blocks/oreblocksunstone.png"));
                        ArrayList<LinkedList<AMVector3>> pathList = paths.get(type);
                        block1: for (LinkedList<AMVector3> individualPath : pathList) {
                            for (int i = 0; i < individualPath.size() - 1; ++i) {
                                double endZ;
                                double endY;
                                double endX;
                                double startZ;
                                double startY;
                                AMVector3 start = individualPath.get(i + 1);
                                AMVector3 end = individualPath.get(i);
                                if (start.distanceSqTo(playerPos) > 2500.0 || end.distanceSqTo(playerPos) > 2500.0) continue;
                                TileEntity teStart = Minecraft.func_71410_x().field_71441_e.func_147438_o((int)start.x, (int)start.y, (int)start.z);
                                TileEntity teEnd = Minecraft.func_71410_x().field_71441_e.func_147438_o((int)end.x, (int)end.y, (int)end.z);
                                if (teEnd == null || !(teEnd instanceof IPowerNode)) continue block1;
                                double startX = start.x + (teStart != null && teStart instanceof IPowerNode ? ((IPowerNode)teStart).particleOffset(0) : 0.5f);
                                AMLineArc arc = (AMLineArc)((Object)AMCore.proxy.particleManager.spawn((World)Minecraft.func_71410_x().field_71441_e, texture, startX, startY = (double)(start.y + (teStart != null && teStart instanceof IPowerNode ? ((IPowerNode)teStart).particleOffset(1) : 0.5f)), startZ = (double)(start.z + (teStart != null && teStart instanceof IPowerNode ? ((IPowerNode)teStart).particleOffset(2) : 0.5f)), endX = (double)(end.x + ((IPowerNode)teEnd).particleOffset(0)), endY = (double)(end.y + ((IPowerNode)teEnd).particleOffset(1)), endZ = (double)(end.z + ((IPowerNode)teEnd).particleOffset(2))));
                                if (arc == null) continue;
                                this.arcs.add(arc);
                            }
                        }
                    }
                }
            }
        } else {
            Iterator<AMLineArc> it = this.arcs.iterator();
            while (it.hasNext()) {
                AMLineArc arc = it.next();
                if (arc == null || arc.field_70128_L) {
                    it.remove();
                    continue;
                }
                arc.func_70106_y();
            }
            this.arcSpawnCounter = 95;
        }
    }

    private void checkMouseDWheel() {
        if (this.mouseWheelValue != 0 && this.currentSlot > -1) {
            Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c = this.currentSlot;
            ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_71045_bC();
            if (this.checkForTKMove(stack)) {
                ExtendedProperties props = ExtendedProperties.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
                if (this.mouseWheelValue > 0 && props.TK_Distance < 10.0f) {
                    props.TK_Distance += 0.5f;
                } else if (this.mouseWheelValue < 0 && (double)props.TK_Distance > 0.3) {
                    props.TK_Distance -= 0.5f;
                }
                LogHelper.debug("TK Distance: %.2f", Float.valueOf(props.TK_Distance));
                props.syncTKDistance();
            } else if (stack.func_77973_b() instanceof ItemSpellBook && Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
                ItemSpellBook isb = (ItemSpellBook)stack.func_77973_b();
                if (this.mouseWheelValue != 0) {
                    byte subID = 0;
                    if (this.mouseWheelValue < 0) {
                        isb.SetNextSlot(Minecraft.func_71410_x().field_71439_g.func_71045_bC());
                        subID = 0;
                    } else {
                        isb.SetPrevSlot(Minecraft.func_71410_x().field_71439_g.func_71045_bC());
                        subID = 1;
                    }
                    AMNetHandler.INSTANCE.sendPacketToServer((byte)14, new AMDataWriter().add(subID).add(Minecraft.func_71410_x().field_71439_g.func_145782_y()).add(Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c).generate());
                }
            }
            this.currentSlot = -1;
            this.mouseWheelValue = 0;
        }
    }

    private boolean checkForTKMove(ItemStack stack) {
        ItemStack activeStack;
        if (stack.func_77973_b() instanceof ItemSpellBook && (activeStack = ((ItemSpellBook)stack.func_77973_b()).GetActiveItemStack(stack)) != null) {
            stack = activeStack;
        }
        if (stack.func_77973_b() instanceof ItemSpellBase && stack.func_77942_o() && this.usingItem) {
            for (ISpellComponent component : SpellUtils.instance.getComponentsForStage(stack, 0)) {
                if (!(component instanceof Telekinesis)) continue;
                return true;
            }
        }
        return false;
    }

    private void renderTick_Start() {
        if (!Minecraft.func_71410_x().field_71415_G) {
            AMGuiHelper.instance.guiTick();
        }
    }

    private void renderTick_End() {
    }

    public void renderOverlays() {
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71441_e != null && (Minecraft.func_71410_x().field_71415_G || guiScreen instanceof GuiHudCustomization)) {
            this.inGameGui.renderGameOverlay();
            ConfigureAMUICommand.showIfQueued();
        }
    }

    private void localServerTick_End() {
        BossSpawnHelper.instance.tick();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            GuiScreen guiscreen = Minecraft.func_71410_x().field_71462_r;
            if (guiscreen == null) {
                this.gameTick_Start();
            }
        } else if (event.phase == TickEvent.Phase.END) {
            GuiScreen guiscreen = Minecraft.func_71410_x().field_71462_r;
            if (guiscreen == null) {
                this.gameTick_End();
            }
            if (Minecraft.func_71410_x().field_71441_e != null) {
                this.spawnPowerPathVisuals();
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.renderTick_Start();
        } else if (event.phase == TickEvent.Phase.END) {
            this.renderTick_End();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (Minecraft.func_71410_x().func_71387_A() && AMCore.config.retroactiveWorldgen()) {
            RetroactiveWorldgenerator.instance.continueRetrogen(event.world);
        }
        if (event.phase == TickEvent.Phase.END) {
            this.applyDeferredDimensionTransfers();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.localServerTick_End();
        }
    }

    public void setDWheel(int dWheel, int slot, boolean usingItem) {
        this.mouseWheelValue = dWheel;
        this.currentSlot = slot;
        this.usingItem = usingItem;
    }

    public AMVector3 getTrackLocation() {
        return this.powerWatch;
    }

    public PowerNodeEntry getTrackData() {
        return this.powerData;
    }

    public void setTrackLocation(AMVector3 location) {
        if (location.equals(AMVector3.zero())) {
            this.hasSynced = false;
            this.powerWatch = location;
            return;
        }
        if (!this.powerWatch.equals(location)) {
            this.powerWatch = location;
            this.powerWatchSyncTick = 0;
            this.hasSynced = false;
        }
    }

    public void setTrackData(NBTTagCompound compound) {
        this.powerData = new PowerNodeEntry();
        this.powerData.readFromNBT(compound);
        this.hasSynced = true;
    }

    public boolean getHasSynced() {
        return this.hasSynced;
    }

    public void addDeferredTarget(EntityLiving ent, EntityLivingBase target) {
        targetsToSet.put(ent, target);
    }
}

