/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.math.AMVector3;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleApproachPoint;
import am2.playerextensions.ExtendedProperties;
import am2.utility.MathUtilities;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class Attract
implements ISpellComponent {
    private final HashMap arcs = new HashMap();

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        this.doTK_Extrapolated(stack, world, impactX, impactY, impactZ, caster);
        return true;
    }

    private boolean doTK_Extrapolated(ItemStack stack, World world, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        EntityLivingBase target;
        double range;
        MovingObjectPosition mop;
        if (caster instanceof EntityPlayer && (mop = ItemsCommonProxy.spell.getMovingObjectPosition(caster, world, range = (double)ExtendedProperties.For((EntityLivingBase)caster).TK_Distance, false, false)) == null) {
            impactX = caster.field_70165_t + Math.cos(Math.toRadians(caster.field_70177_z + 90.0f)) * range;
            impactZ = caster.field_70161_v + Math.sin(Math.toRadians(caster.field_70177_z + 90.0f)) * range;
            impactY = caster.field_70163_u + (double)caster.func_70047_e() + -Math.sin(Math.toRadians(caster.field_70125_A)) * range;
        }
        if ((target = this.getClosestEntityToPointWithin(caster, world, new AMVector3(impactX, impactY, impactZ), 16.0)) == null) {
            return false;
        }
        int hDist = 3;
        AMVector3 movement = MathUtilities.GetMovementVectorBetweenPoints(new AMVector3((Entity)target), new AMVector3(impactX, impactY, impactZ));
        if (!world.field_72995_K) {
            float factor = 0.75f;
            double x = -(movement.x * factor);
            double y = -(movement.y * factor);
            double z = -(movement.z * factor);
            target.func_70024_g(x, y, z);
            if (Math.abs(target.field_70159_w) > Math.abs(x * 2.0)) {
                target.field_70159_w = x * (target.field_70159_w / target.field_70159_w);
            }
            if (Math.abs(target.field_70181_x) > Math.abs(y * 2.0)) {
                target.field_70181_x = y * (target.field_70181_x / target.field_70181_x);
            }
            if (Math.abs(target.field_70179_y) > Math.abs(z * 2.0)) {
                target.field_70179_y = z * (target.field_70179_y / target.field_70179_y);
            }
        }
        return true;
    }

    private EntityLivingBase getClosestEntityToPointWithin(EntityLivingBase caster, World world, AMVector3 point, double radius) {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)((double)point.x - radius), (double)((double)point.y - radius), (double)((double)point.z - radius), (double)((double)point.x + radius), (double)((double)point.y + radius), (double)((double)point.z + radius));
        List entities = world.func_72872_a(EntityLivingBase.class, bb);
        EntityLivingBase closest = null;
        for (EntityLivingBase e : entities) {
            if (e == caster) continue;
            if (closest != null) {
                AMVector3 aMVector3 = new AMVector3((Entity)e);
                AMVector3 aMVector32 = new AMVector3((Entity)closest);
                if (!(point.distanceSqTo(aMVector3) < point.distanceSqTo(aMVector32))) continue;
            }
            closest = e;
        }
        return closest;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        this.doTK_Extrapolated(stack, world, target.field_70165_t, target.field_70163_u, target.field_70161_v, caster);
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 2.6f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "arcane", x, y, z));
        if (effect != null) {
            effect.addRandomOffset(1.0, 1.0, 1.0);
            effect.AddParticleController(new ParticleApproachPoint(effect, x, y, z, 0.025f, 0.025f, 1, false));
            effect.setRGBColorF(0.8f, 0.3f, 0.7f);
            if (colorModifier > -1) {
                effect.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.NONE);
    }

    @Override
    public int getID() {
        return 2;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 0);
        objectArray[1] = Items.field_151042_j;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }
}

