/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.buffs.BuffList;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleOrbitEntity;
import am2.particles.ParticleOrbitPoint;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class DivineIntervention
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (world.field_72995_K || !(target instanceof EntityLivingBase)) {
            return true;
        }
        if (((EntityLivingBase)target).func_82165_m(BuffList.astralDistortion.field_76415_H)) {
            if (target instanceof EntityPlayer) {
                ((EntityPlayer)target).func_145747_a((IChatComponent)new ChatComponentText("The distortion around you prevents you from teleporting"));
            }
            return true;
        }
        if (target.field_71093_bK == 1) {
            if (target instanceof EntityPlayer) {
                ((EntityPlayer)target).func_145747_a((IChatComponent)new ChatComponentText("Nothing happens..."));
            }
            return true;
        }
        if (target.field_71093_bK == 0) {
            ChunkCoordinates coords;
            ChunkCoordinates chunkCoordinates = coords = target instanceof EntityPlayer ? ((EntityPlayer)target).getBedLocation(target.field_71093_bK) : null;
            if (coords == null || coords.field_71574_a == 0 && coords.field_71572_b == 0 && coords.field_71573_c == 0) {
                coords = world.func_72861_E();
            }
            int yPos = coords.field_71572_b;
            while (world.func_147439_a(coords.field_71574_a, yPos, coords.field_71573_c) != Blocks.field_150350_a && world.func_147439_a(coords.field_71574_a, yPos + 1, coords.field_71573_c) != Blocks.field_150350_a) {
                ++yPos;
            }
            ((EntityLivingBase)target).func_70634_a((double)coords.field_71574_a + 0.5, (double)yPos, (double)coords.field_71573_c + 0.5);
        } else {
            AMCore.proxy.addDeferredDimensionTransfer((EntityLivingBase)target, 0);
        }
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 400.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return new ItemStack[]{new ItemStack((Item)ItemsCommonProxy.essence, 1, 9)};
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 100; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "arcane", x, y - 1.0, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            if (rand.nextBoolean()) {
                particle.AddParticleController(new ParticleOrbitEntity(particle, target, 0.1f, 1, false).SetTargetDistance(rand.nextDouble() + 0.5));
            } else {
                particle.AddParticleController(new ParticleOrbitPoint(particle, x, y, z, 1, false).SetOrbitSpeed(0.1f).SetTargetDistance(rand.nextDouble() + 0.5));
            }
            particle.setMaxAge(25 + rand.nextInt(10));
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.ENDER);
    }

    @Override
    public int getID() {
        return 11;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 13);
        objectArray[1] = Items.field_151104_aV;
        objectArray[2] = Items.field_151079_bi;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.4f;
    }
}

