/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.api.power.PowerTypes;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.entities.EntityBattleChicken;
import am2.entities.EntityHellCow;
import am2.items.ItemCrystalPhylactery;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.ExtendedProperties;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.spell.components.AstralDistortion;
import am2.spell.components.Haste;
import am2.utility.EntityUtilities;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class Summon
implements ISpellComponent {
    @Override
    public int getID() {
        return 61;
    }

    public EntityLiving summonCreature(ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z) {
        Class clazz = this.getSummonType(stack);
        EntityLiving entity = null;
        try {
            entity = (EntityLiving)clazz.getConstructor(World.class).newInstance(world);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntitySkeleton) {
            ((EntitySkeleton)entity).func_82201_a(0);
            ((EntitySkeleton)entity).func_70062_b(0, new ItemStack((Item)Items.field_151031_f));
        } else if (entity instanceof EntityHorse && caster instanceof EntityPlayer) {
            ((EntityHorse)entity).func_110263_g((EntityPlayer)caster);
        }
        entity.func_70107_b(x, y, z);
        world.func_72838_d((Entity)entity);
        if (caster instanceof EntityPlayer) {
            EntityUtilities.makeSummon_PlayerFaction((EntityCreature)entity, (EntityPlayer)caster, false);
        } else {
            EntityUtilities.makeSummon_MonsterFaction((EntityCreature)entity, false);
        }
        EntityUtilities.setOwner((EntityLivingBase)entity, caster);
        int duration = SpellUtils.instance.getModifiedInt_Mul(4800, stack, caster, (Entity)target, world, 0, SpellModifiers.DURATION);
        EntityUtilities.setSummonDuration((EntityLivingBase)entity, duration);
        SpellHelper.instance.applyStageToEntity(stack, caster, world, (Entity)entity, 0, false);
        return entity;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[7];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 4);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 3);
        objectArray[2] = BlocksCommonProxy.cerublossom;
        objectArray[3] = ItemsCommonProxy.mobFocus;
        objectArray[4] = new ItemStack((Item)ItemsCommonProxy.crystalPhylactery, 1, 3);
        objectArray[5] = String.format("E:%d", PowerTypes.DARK.ID());
        objectArray[6] = 1500;
        return objectArray;
    }

    public void setSummonType(ItemStack stack, ItemStack phylacteryStack) {
        if (phylacteryStack.func_77960_j() == 3 && phylacteryStack.func_77973_b() instanceof ItemCrystalPhylactery) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            this.setSummonType(stack, ItemsCommonProxy.crystalPhylactery.getSpawnClass(phylacteryStack));
        }
    }

    public Class getSummonType(ItemStack stack) {
        String s = SpellUtils.instance.getSpellMetadata(stack, "SummonType");
        if (s == null || s == "") {
            s = "Skeleton";
        }
        Class clazz = (Class)EntityList.field_75625_b.get(s);
        return clazz;
    }

    public void setSummonType(ItemStack stack, String s) {
        Class clazz = (Class)EntityList.field_75625_b.get(s);
        this.setSummonType(stack, clazz);
    }

    public void setSummonType(ItemStack stack, Class clazz) {
        String s;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((s = (String)EntityList.field_75626_c.get(clazz = this.checkForSpecialSpawns(stack, clazz))) == null) {
            s = "";
        }
        SpellUtils.instance.setSpellMetadata(stack, "SpawnClassName", s);
        SpellUtils.instance.setSpellMetadata(stack, "SummonType", s);
    }

    private Class checkForSpecialSpawns(ItemStack stack, Class clazz) {
        if (clazz == EntityChicken.class) {
            if (SpellUtils.instance.modifierIsPresent(SpellModifiers.DAMAGE, stack, 0) && SpellUtils.instance.componentIsPresent(stack, Haste.class, 0)) {
                return EntityBattleChicken.class;
            }
        } else if (clazz == EntityCow.class && SpellUtils.instance.modifierIsPresent(SpellModifiers.DAMAGE, stack, 0) && SpellUtils.instance.componentIsPresent(stack, AstralDistortion.class, 0)) {
            return EntityHellCow.class;
        }
        return clazz;
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        if (!world.field_72995_K) {
            if (ExtendedProperties.For(caster).getCanHaveMoreSummons()) {
                if (this.summonCreature(stack, caster, caster, world, impactX, impactY, impactZ) == null) {
                    return false;
                }
            } else if (caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.noMoreSummons")));
            }
        }
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLivingBase && EntityUtilities.isSummon((EntityLivingBase)target)) {
            return false;
        }
        if (!world.field_72995_K) {
            if (ExtendedProperties.For(caster).getCanHaveMoreSummons()) {
                if (this.summonCreature(stack, caster, caster, world, target.field_70165_t, target.field_70163_u, target.field_70161_v) == null) {
                    return false;
                }
            } else if (caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.noMoreSummons")));
            }
        }
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 400.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 120.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.ENDER, Affinity.LIFE);
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }
}

