/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.log;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.ForgeVersion;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.FileHandler;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.properties.PropertiesBase;
import net.techbrew.journeymap.thread.JMThreadFactory;

public class JMLogger {
    public static final String DEPRECATED_LOG_FILE = "journeyMap.log";
    public static final String LOG_FILE = "journeymap.log";
    private static java.util.logging.FileHandler fileHandler;

    public static Logger init() {
        Logger logger = Logger.getLogger("journeymap");
        if (logger.getLevel() == null || logger.getLevel().intValue() > Level.INFO.intValue()) {
            logger.setLevel(Level.INFO);
        }
        try {
            File deprecatedLog = new File(FileHandler.getJourneyMapDir(), DEPRECATED_LOG_FILE);
            if (deprecatedLog.exists()) {
                deprecatedLog.delete();
            }
        }
        catch (Exception e) {
            logger.severe("Error removing deprecated logfile: " + e.getMessage());
        }
        try {
            File logFile = JMLogger.getLogFile();
            if (logFile.exists()) {
                logFile.delete();
            } else {
                logFile.getParentFile().mkdirs();
            }
            fileHandler = new java.util.logging.FileHandler(logFile.getAbsolutePath());
            fileHandler.setFormatter(new LogFormatter());
            logger.addHandler(fileHandler);
            Runtime.getRuntime().addShutdownHook(new JMThreadFactory("log").newThread(new Runnable(){

                @Override
                public void run() {
                    fileHandler.flush();
                    fileHandler.close();
                }
            }));
        }
        catch (SecurityException e) {
            logger.severe("Error adding file handler: " + LogFormatter.toString(e));
        }
        catch (IOException e) {
            logger.severe("Error adding file handler: " + LogFormatter.toString(e));
        }
        return logger;
    }

    public static void logProperties() {
        LogRecord record = new LogRecord(Level.INFO, JMLogger.getPropertiesSummary());
        record.setSourceClassName("JMLogger");
        record.setSourceMethodName("logProperties");
        if (fileHandler != null) {
            fileHandler.publish(record);
        }
    }

    public static String getPropertiesSummary() {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("Version", JourneyMap.MOD_NAME + ", built with Forge " + "1.7.10");
        props.put("Forge", ForgeVersion.getVersion());
        long totalMB = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
        long freeMB = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
        props.put("Memory", String.format("%sMB total, %sMB free", totalMB, freeMB));
        List<String> envProps = Arrays.asList("os.name", "os.arch", "java.version", "user.country", "user.language");
        StringBuilder sb = new StringBuilder();
        for (String string : envProps) {
            sb.append(string).append("=").append(System.getProperty(string)).append(", ");
        }
        sb.append("game language=").append(Minecraft.func_71410_x().field_71474_y.field_74363_ab).append(", ");
        sb.append("locale=").append(Constants.getLocale());
        props.put("Environment", sb.toString());
        sb = new StringBuilder();
        for (Map.Entry entry : props.entrySet()) {
            if (sb.length() > 0) {
                sb.append(LogFormatter.LINEBREAK);
            }
            sb.append((String)entry.getKey()).append(": ").append((String)entry.getValue());
        }
        JourneyMap jm = JourneyMap.getInstance();
        List<PropertiesBase> list = Arrays.asList(jm.coreProperties, jm.fullMapProperties, jm.miniMapProperties, jm.waypointProperties, jm.webMapProperties);
        for (PropertiesBase config : list) {
            sb.append(LogFormatter.LINEBREAK).append(config);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLevelFromProps() {
        Logger logger = Logger.getLogger("journeymap");
        String propLevel = "";
        Level level = Level.INFO;
        try {
            propLevel = JourneyMap.getInstance().coreProperties.logLevel.get();
            level = Level.parse(propLevel);
            if (level != logger.getLevel()) {
                logger.setLevel(level);
                if (level.intValue() < Level.INFO.intValue()) {
                    ChatLog.announceI18N("JourneyMap.log_warning", level.getName());
                }
            }
        }
        catch (IllegalArgumentException e) {
            logger.warning("Illegal value for logLevel in " + JourneyMap.getInstance().coreProperties.getFile().getName() + ": " + propLevel);
        }
        catch (Throwable t) {
            logger.severe(LogFormatter.toString(t));
        }
        finally {
            logger.setLevel(level);
        }
    }

    public static File getLogFile() {
        return new File(FileHandler.getJourneyMapDir(), LOG_FILE);
    }
}

