/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.model;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.io.RegionImageHandler;
import net.techbrew.journeymap.model.ChunkCoord;
import net.techbrew.journeymap.model.ChunkImageSet;
import net.techbrew.journeymap.model.ImageSet;
import net.techbrew.journeymap.model.RegionCoord;
import net.techbrew.journeymap.model.RegionImageSet;
import net.techbrew.journeymap.thread.JMThreadFactory;

public class RegionImageCache {
    private static final int SIZE = 25;
    private static final long flushInterval = TimeUnit.SECONDS.toMillis(30L);
    private volatile Map<RegionCoord, RegionImageSet> imageSets;
    private volatile long lastFlush;
    private volatile Object lock = new Object();

    public static RegionImageCache getInstance() {
        return Holder.INSTANCE;
    }

    private RegionImageCache() {
        this.imageSets = Collections.synchronizedMap(new CacheMap(25));
        this.lastFlush = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(5L);
        JMThreadFactory tf = new JMThreadFactory("rcache");
        Runtime.getRuntime().addShutdownHook(tf.newThread(new Runnable(){

            @Override
            public void run() {
                RegionImageCache.this.flushToDisk();
                if (JourneyMap.getLogger().isLoggable(Level.FINE)) {
                    JourneyMap.getLogger().fine("RegionImageCache flushing to disk on shutdown");
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionImageSet getRegionImageSet(RegionCoord rCoord) {
        Object object = this.lock;
        synchronized (object) {
            RegionImageSet ris = this.imageSets.get(rCoord);
            if (ris == null) {
                ris = new RegionImageSet(rCoord);
                this.imageSets.put(rCoord, ris);
            }
            return ris;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RegionCoord rCoord) {
        Object object = this.lock;
        synchronized (object) {
            return this.imageSets.containsKey(rCoord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegionCoord> getRegions() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<RegionCoord>(this.imageSets.keySet());
        }
    }

    public BufferedImage getGuaranteedImage(RegionCoord rCoord, Constants.MapType mapType) {
        RegionImageSet ris = this.getRegionImageSet(rCoord);
        return ris.getImage(mapType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Collection<ChunkImageSet> chunkImageSets, boolean forceFlush) {
        RegionImageHandler rfh = RegionImageHandler.getInstance();
        Object object = this.lock;
        synchronized (object) {
            for (ChunkImageSet cis : chunkImageSets) {
                ChunkCoord cCoord = cis.getCCoord();
                RegionCoord rCoord = cis.getCCoord().getRegionCoord();
                RegionImageSet ris = this.getRegionImageSet(rCoord);
                if (ris.hasLegacy()) {
                    ris.writeToDisk(true);
                }
                ris.insertChunk(cis, forceFlush);
            }
            if (forceFlush) {
                this.flushToDisk();
            }
        }
        if (!forceFlush) {
            this.autoFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoFlush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastFlush + flushInterval < System.currentTimeMillis()) {
                if (JourneyMap.getLogger().isLoggable(Level.FINE)) {
                    JourneyMap.getLogger().fine("RegionImageCache auto-flushing");
                }
                this.flushToDisk();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushToDisk() {
        RegionImageHandler rfh = RegionImageHandler.getInstance();
        Object object = this.lock;
        synchronized (object) {
            for (RegionImageSet ris : this.imageSets.values()) {
                ris.writeToDisk(false);
            }
            this.lastFlush = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegionCoord> getDirtySince(Constants.MapType mapType, long time) {
        if (time <= this.lastFlush) {
            if (JourneyMap.getLogger().isLoggable(Level.FINE)) {
                JourneyMap.getLogger().fine("Nothing dirty, last flush was " + (time - this.lastFlush) + "ms before " + time);
            }
            return Collections.EMPTY_LIST;
        }
        ArrayList<RegionCoord> list = new ArrayList<RegionCoord>(this.imageSets.size());
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<RegionCoord, RegionImageSet> entry : this.imageSets.entrySet()) {
                if (!entry.getValue().updatedSince(mapType, time)) continue;
                list.add(entry.getKey());
            }
            if (JourneyMap.getLogger().isLoggable(Level.FINE)) {
                JourneyMap.getLogger().fine("Dirty regions: " + list.size() + " of " + this.imageSets.size());
            }
        }
        return list;
    }

    public boolean isDirtySince(RegionCoord rc, Constants.MapType mapType, long time) {
        RegionImageSet ris = this.getRegionImageSet(rc);
        if (ris == null) {
            return false;
        }
        return ris.updatedSince(mapType, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            for (ImageSet imageSet : this.imageSets.values()) {
                imageSet.clear();
            }
            this.imageSets.clear();
        }
    }

    class CacheMap
    extends LinkedHashMap<RegionCoord, RegionImageSet> {
        private final int capacity;

        CacheMap(int capacity) {
            super(capacity + 1, 1.1f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<RegionCoord, RegionImageSet> entry) {
            Boolean remove = this.size() > this.capacity;
            if (remove.booleanValue()) {
                if (JourneyMap.getLogger().isLoggable(Level.FINE)) {
                    JourneyMap.getLogger().fine("RegionImageCache purging " + entry.getKey());
                }
                entry.getValue().writeToDisk(false);
            }
            if (JourneyMap.getLogger().isLoggable(Level.FINE)) {
                JourneyMap.getLogger().fine("RegionImageCache size: " + (this.size() - 1));
            }
            return remove;
        }
    }

    private static class Holder {
        private static final RegionImageCache INSTANCE = new RegionImageCache();

        private Holder() {
        }
    }
}

