/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.render.overlay;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.Vec3;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.Waypoint;
import net.techbrew.journeymap.render.draw.DrawWayPointStep;
import net.techbrew.journeymap.render.overlay.GridRenderer;

public class OverlayWaypointRenderer {
    public List<DrawWayPointStep> prepareSteps(List<Waypoint> waypoints, GridRenderer grid, boolean checkDistance) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityClientPlayerMP player = mc.field_71439_g;
        int dimension = player.field_71093_bK;
        int maxDistance = JourneyMap.getInstance().waypointProperties.maxDistance.get();
        checkDistance = checkDistance && maxDistance > 0;
        Vec3 playerVec = checkDistance ? player.func_70666_h(1.0f) : null;
        ArrayList<DrawWayPointStep> drawStepList = new ArrayList<DrawWayPointStep>();
        try {
            for (Waypoint waypoint : waypoints) {
                double actualDistance;
                if (!waypoint.isEnable() || checkDistance && (actualDistance = playerVec.func_72438_d(waypoint.getPosition())) > (double)maxDistance) continue;
                drawStepList.add(new DrawWayPointStep(waypoint));
            }
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe("Error during prepareSteps: " + LogFormatter.toString(t));
        }
        return drawStepList;
    }
}

