/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.server;

import com.google.common.io.CharStreams;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.cartography.ColorCache;
import net.techbrew.journeymap.data.DataCache;
import net.techbrew.journeymap.log.JMLogger;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.log.StatTimer;
import net.techbrew.journeymap.server.BaseService;
import net.techbrew.journeymap.server.FileService;
import se.rupy.http.Event;

public class DebugService
extends FileService {
    private static final long serialVersionUID = 1L;

    @Override
    public String path() {
        return "/debug";
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        BaseService.ResponseHeader.on(event).contentType(BaseService.ContentType.html).noCache();
        StringBuilder sb = new StringBuilder();
        sb.append(LogFormatter.LINEBREAK).append("<div id='accordion'>");
        sb.append(LogFormatter.LINEBREAK).append("<h1>Properties</h1><div>");
        sb.append(LogFormatter.LINEBREAK).append(JMLogger.getPropertiesSummary().replaceAll(LogFormatter.LINEBREAK, "<p>")).append("</div>");
        sb.append(LogFormatter.LINEBREAK).append("<h1>Performance Metrics</h1>");
        sb.append(LogFormatter.LINEBREAK).append("<div><pre>").append(StatTimer.getReport()).append("</pre></div>");
        sb.append(LogFormatter.LINEBREAK).append("<h1>Data Cache Metrics</h1>");
        sb.append(LogFormatter.LINEBREAK).append("<div>").append(DataCache.instance().getDebugHtml()).append("</div>");
        if (JourneyMap.getInstance().isMapping().booleanValue()) {
            sb.append(LogFormatter.LINEBREAK).append("<h1>Block Data</h1><div>");
            sb.append(LogFormatter.LINEBREAK).append(ColorCache.getInstance().getCacheDebugHtml());
            sb.append(LogFormatter.LINEBREAK).append("</div><!-- / Block Data -->");
        }
        sb.append(LogFormatter.LINEBREAK).append("</div> <!-- /accordion -->");
        String debug = null;
        InputStream debugHtmlStream = this.getStream("/debug.html", null);
        if (debugHtmlStream != null) {
            String debugHtml = CharStreams.toString((Readable)new InputStreamReader(debugHtmlStream, "UTF-8"));
            debug = debugHtml.replace("<output/>", sb.toString());
        } else {
            debug = sb.toString();
        }
        this.gzipResponse(event, debug);
    }
}

