/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.ui;

import java.awt.Color;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.render.draw.DrawUtil;
import net.techbrew.journeymap.render.texture.TextureCache;
import net.techbrew.journeymap.render.texture.TextureImpl;
import net.techbrew.journeymap.ui.Button;
import net.techbrew.journeymap.ui.UIManager;
import org.lwjgl.opengl.GL11;

public abstract class JmUI
extends GuiScreen {
    TextureImpl logo = TextureCache.instance().getLogo();
    protected final String title;
    protected final int headerHeight = 25;
    protected int scaleFactor = 1;
    protected final Logger logger = JourneyMap.getLogger();
    protected final Class<? extends JmUI> returnClass;

    public JmUI(String title) {
        this(title, null);
    }

    public JmUI(String title, Class<? extends JmUI> returnClass) {
        this.title = title;
        this.returnClass = returnClass;
    }

    public Minecraft getMinecraft() {
        return this.field_146297_k;
    }

    public void func_146280_a(Minecraft minecraft, int width, int height) {
        super.func_146280_a(minecraft, width, height);
        ScaledResolution resolution = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        this.scaleFactor = resolution.func_78325_e();
    }

    public boolean func_73868_f() {
        return true;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void sizeDisplay(boolean scaled) {
        int glwidth = scaled ? this.field_146294_l : this.field_146297_k.field_71443_c;
        int glheight = scaled ? this.field_146295_m : this.field_146297_k.field_71440_d;
        JmUI.sizeDisplay(glwidth, glheight);
    }

    protected boolean mouseOverButtons(int x, int y) {
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(k);
            if (!(guibutton instanceof Button) || !((Button)guibutton).mouseOver(x, y)) continue;
            return true;
        }
        return false;
    }

    protected void drawLogo() {
        JmUI.sizeDisplay(this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        boolean smallScale = this.scaleFactor == 1;
        DrawUtil.drawImage(this.logo, smallScale ? 8.0 : 16.0, 4.0, false, smallScale ? 0.5f : 1.0f);
        JmUI.sizeDisplay(this.field_146294_l, this.field_146295_m);
    }

    protected void drawTitle() {
        DrawUtil.drawRectangle(0.0, 0.0, this.field_146294_l, 25.0, Color.black, 100);
        DrawUtil.drawCenteredLabel(this.title, this.field_146294_l / 2, 12.0, Color.black, 0, Color.CYAN, 255, 1.0);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
    }

    public void func_146278_c(int layer) {
        this.func_146276_q_();
    }

    protected abstract void layoutButtons();

    public void func_73863_a(int x, int y, float par3) {
        try {
            GuiButton guibutton;
            int k;
            this.func_146278_c(0);
            this.layoutButtons();
            for (k = 0; k < this.field_146292_n.size(); ++k) {
                guibutton = (GuiButton)this.field_146292_n.get(k);
                guibutton.func_146112_a(this.field_146297_k, x, y);
            }
            for (k = 0; k < this.field_146292_n.size(); ++k) {
                guibutton = (GuiButton)this.field_146292_n.get(k);
                if (!(guibutton instanceof Button) || ((Button)guibutton).isEnabled() || ((Button)guibutton).isNoDisableText()) continue;
                ((Button)guibutton).func_146112_a(this.field_146297_k, x, y);
            }
            this.drawTitle();
            this.drawLogo();
        }
        catch (Throwable t) {
            JourneyMap.getLogger().severe("Error in UI: " + LogFormatter.toString(t));
            this.closeAndReturn();
        }
    }

    public static void sizeDisplay(double width, double height) {
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void close() {
    }

    protected void closeAndReturn() {
        if (this.returnClass == null) {
            UIManager.getInstance().openMasterOptions();
        } else {
            UIManager.getInstance().open(this.returnClass);
        }
    }

    protected void func_73869_a(char c, int i) {
        switch (i) {
            case 1: {
                this.closeAndReturn();
            }
        }
    }
}

