/*
 * Decompiled with CFR 0.152.
 */
package net.techbrew.journeymap.waypoint;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ChunkCoordinates;
import net.techbrew.journeymap.Constants;
import net.techbrew.journeymap.JourneyMap;
import net.techbrew.journeymap.log.ChatLog;
import net.techbrew.journeymap.log.LogFormatter;
import net.techbrew.journeymap.model.Waypoint;
import reifnsk.minimap.ReiMinimap;

public class ReiReader {
    public static final String[] classNames = new String[]{"reifnsk.minimap.ReiMinimap", "reifnsk.minimap.Waypoint"};
    public static Boolean modLoaded;
    int pointErrors = 0;
    int fileErrors = 0;

    public static List<Waypoint> loadWaypoints() {
        try {
            Class.forName("reifnsk.minimap.ReiMinimap").getDeclaredField("instance");
            ReiMinimap reiMinimap = ReiMinimap.instance;
            List reiWaypoints = reiMinimap.getWaypoints();
            if (reiWaypoints == null || reiWaypoints.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            int dimension = player != null ? player.field_71093_bK : 0;
            ArrayList<Waypoint> converted = new ArrayList<Waypoint>(reiWaypoints.size());
            for (reifnsk.minimap.Waypoint reiWp : reiWaypoints) {
                Waypoint jmWp = new Waypoint(reiWp.name, reiWp.x, reiWp.y, reiWp.z, reiWp.enable, (int)(reiWp.red * 255.0f) & 0xFF, (int)(reiWp.green * 255.0f) & 0xFF, (int)(reiWp.blue * 255.0f) & 0xFF, reiWp.type == 1 ? Waypoint.Type.Death : Waypoint.Type.Normal, Waypoint.Origin.ReiMinimap, dimension, Arrays.asList(dimension));
                jmWp.setReadOnly(true);
                converted.add(jmWp);
            }
            return converted;
        }
        catch (Throwable e) {
            JourneyMap.getLogger().warning("Incompatible version of ReiMinimap. Tried reifnsk.minimap.ReiMinimap.instance.getWaypoints(): " + e);
            ChatLog.announceI18N("Waypoint.import_rei_version", new Object[0]);
            modLoaded = false;
            return Collections.EMPTY_LIST;
        }
    }

    public static String getPointsFilename() {
        String worldName = null;
        try {
            NetHandlerPlayClient sendQueue = Minecraft.func_71410_x().func_147114_u();
            SocketAddress addr = sendQueue.func_147298_b().func_74430_c();
            String addrStr = addr.toString().replaceAll("[\r\n]", "");
            Matcher matcher = Pattern.compile("(.*)/(.*):([0-9]+)").matcher(addrStr);
            if (matcher.matches()) {
                worldName = matcher.group(1);
                if (worldName.isEmpty()) {
                    worldName = matcher.group(2);
                }
                if (!matcher.group(3).equals("25565")) {
                    worldName = worldName + "[" + matcher.group(3) + "]";
                }
                for (char c : ChatAllowedCharacters.field_71567_b) {
                    worldName = worldName.replace(c, '_');
                }
            }
        }
        catch (Exception e) {
            JourneyMap.getLogger().warning("Could not derive Rei filename: " + e.getMessage());
        }
        if (worldName == null) {
            worldName = "WorldName";
        }
        return String.format("mods\\rei_minimap\\%s.DIM*.points", worldName);
    }

    public Collection<Waypoint> loadWaypoints(File waypointDir, boolean deleteOnSuccess) {
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        File[] files = waypointDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(".DIM") && name.endsWith(".points");
            }
        });
        if (files.length == 0) {
            return waypoints;
        }
        for (File pointsFile : files) {
            try {
                int pointErrorCount = this.pointErrors;
                String name = pointsFile.getName();
                int start = name.lastIndexOf("DIM") + 3;
                int end = name.lastIndexOf(".points");
                String dimName = name.substring(start, end);
                int dimension = Integer.parseInt(dimName);
                this.loadWaypoints(dimension, pointsFile, waypoints);
                if (!deleteOnSuccess || pointErrorCount != this.pointErrors) continue;
                pointsFile.deleteOnExit();
                pointsFile.delete();
            }
            catch (Exception e) {
                ChatLog.announceError(Constants.getString("Waypoint.import_rei_file_error", pointsFile.getName()));
                JourneyMap.getLogger().severe(LogFormatter.toString(e));
                ++this.fileErrors;
            }
        }
        if (waypoints.isEmpty()) {
            ChatLog.announceI18N("Waypoint.import_rei_failure", new Object[0]);
        } else if (this.fileErrors == 0 && this.pointErrors == 0) {
            ChatLog.announceI18N("Waypoint.import_rei_success", waypoints.size());
        } else {
            ChatLog.announceI18N("Waypoint.import_rei_errors", waypoints.size(), this.pointErrors);
        }
        return waypoints;
    }

    private void loadWaypoints(int dimension, File pointsFile, ArrayList<Waypoint> waypoints) throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(pointsFile));
        while ((line = br.readLine()) != null) {
            Waypoint waypoint = this.loadWaypoint(dimension, line);
            if (waypoint == null) continue;
            waypoints.add(waypoint);
        }
        br.close();
    }

    private Waypoint loadWaypoint(int dimension, String line) {
        String[] parts = new String[]{"name", "x", "y", "z", "enable", "color"};
        String[] v = line.split(":");
        int i = 0;
        try {
            String name = v[i];
            int x = Integer.parseInt(v[++i]);
            int y = Integer.parseInt(v[++i]);
            int z = Integer.parseInt(v[++i]);
            boolean enable = Boolean.parseBoolean(v[++i]);
            Color color = new Color(Integer.parseInt(v[++i], 16));
            Waypoint waypoint = new Waypoint(name, new ChunkCoordinates(x, y, z), color, Waypoint.Type.Normal, dimension);
            waypoint.setEnable(enable);
            waypoint.setOrigin(Waypoint.Origin.ReiMinimap);
            waypoint.setDirty(true);
            return waypoint;
        }
        catch (Exception e) {
            JourneyMap.getLogger().warning("Couldn't parse " + v[i] + " as " + parts[i] + " in \"" + line + "\" because: " + e.getMessage());
            ++this.pointErrors;
            return null;
        }
    }
}

