/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.gui.global.auras;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import kamkeel.npcdbc.client.ClientEventHandler;
import kamkeel.npcdbc.client.gui.global.auras.SubGuiAuraDisplay;
import kamkeel.npcdbc.client.sound.AuraSound;
import kamkeel.npcdbc.client.sound.SoundHandler;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.data.SoundSource;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.data.aura.AuraDisplay;
import kamkeel.npcdbc.data.npc.DBCDisplay;
import kamkeel.npcdbc.entity.EntityAura;
import kamkeel.npcdbc.mixins.late.INPCDisplay;
import kamkeel.npcdbc.network.PacketHandler;
import kamkeel.npcdbc.network.packets.aura.DBCGetAura;
import kamkeel.npcdbc.network.packets.aura.DBCRemoveAura;
import kamkeel.npcdbc.network.packets.aura.DBCRequestAura;
import kamkeel.npcdbc.network.packets.aura.DBCSaveAura;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.select.GuiSoundSelection;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiNPCManageAuras
extends GuiNPCInterface2
implements ICustomScrollListener,
IScrollData,
IGuiData,
ISubGuiListener,
GuiYesNoCallback,
ITextfieldListener {
    public GuiCustomScroll scrollAuras;
    public HashMap<String, Integer> data = new HashMap();
    public AuraSound auraSound;
    public AuraSound secondarySound;
    public AuraSound kaiokenSound;
    public AuraSound kettleSound;
    public AuraSound secondaryKettleSound;
    boolean setNormalSound = true;
    public Aura aura = new Aura();
    private String search = "";
    private String originalName = "";
    public String selected = null;
    public AuraDisplay display;
    public DBCDisplay visualDisplay;
    private boolean renderAura;
    private int revampedAura;
    public static int auraTicks = 1;
    private float zoomed = 50.0f;
    private float rotation;

    public GuiNPCManageAuras(EntityNPCInterface npc) {
        super(npc);
        this.npc = DBCDisplay.setupGUINPC((EntityCustomNpc)npc);
        this.npc.display.name = "aura man";
        this.npc.field_70131_O = 1.62f;
        this.npc.field_70130_N = 0.43f;
        this.visualDisplay = ((INPCDisplay)this.npc.display).getDBCDisplay();
        this.visualDisplay.auraID = -1;
        this.visualDisplay.formID = -1;
        this.visualDisplay.outlineID = -1;
        this.display = this.aura.display;
        PacketHandler.Instance.sendToServer(new DBCRequestAura(-1, false).generatePacket());
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addButton(new GuiNpcButton(0, this.guiLeft + 368, this.guiTop + 8, 45, 20, "gui.add"));
        this.addButton(new GuiNpcButton(1, this.guiLeft + 368, this.guiTop + 32, 45, 20, "gui.remove"));
        this.getButton((int)1).field_146124_l = this.aura != null && this.aura.id != -1;
        this.addButton(new GuiNpcButton(2, this.guiLeft + 368, this.guiTop + 56, 45, 20, "gui.clone"));
        this.getButton((int)2).field_146124_l = this.aura != null && this.aura.id != -1;
        this.addButton(new GuiNpcButton(3, this.guiLeft + 368, this.guiTop + 80, 45, 20, "gui.edit"));
        boolean bl = this.getButton((int)3).field_146124_l = this.aura != null && this.aura.id != -1;
        if (this.scrollAuras == null) {
            this.scrollAuras = new GuiCustomScroll((GuiScreen)this, 0, 0);
            this.scrollAuras.setSize(143, 185);
        }
        this.scrollAuras.guiLeft = this.guiLeft + 220;
        this.scrollAuras.guiTop = this.guiTop + 4;
        this.addScroll(this.scrollAuras);
        this.scrollAuras.setList(this.getSearchList());
        this.addTextField(new GuiNpcTextField(55, (GuiScreen)this, this.field_146289_q, this.guiLeft + 220, this.guiTop + 4 + 3 + 185, 143, 20, this.search));
        if (this.aura != null && this.aura.id != -1) {
            this.addLabel(new GuiNpcLabel(10, (Object)"ID", this.guiLeft + 368, this.guiTop + 4 + 3 + 185));
            this.addLabel(new GuiNpcLabel(11, (Object)(this.aura.id + ""), this.guiLeft + 368, this.guiTop + 4 + 3 + 195));
        }
    }

    public void playSound(boolean allowRepeats) {
        String secondaryKettleLoc;
        String soundLoc = this.display.getFinalSound(this.display.type);
        String kaiokenLoc = this.visualDisplay.isKaioken ? this.display.getKaiokenSound() : null;
        String kettleLoc = this.display.kettleModeEnabled ? "jinryuudragonbc:DBC5.majin_cattle" : null;
        Aura secondary = this.aura.getSecondaryAur();
        String secondLoc = secondary != null ? secondary.display.getFinalSound(secondary.display.type) : null;
        String string = secondaryKettleLoc = secondary != null && secondary.display.kettleModeEnabled ? "jinryuudragonbc:DBC5.majin_cattle" : null;
        if (soundLoc != null && (allowRepeats || !SoundHandler.isPlayingSound((Entity)this.npc, soundLoc))) {
            this.auraSound = new AuraSound(this.aura, new SoundSource(soundLoc, (Entity)this.npc));
            this.auraSound.isGUIAura = true;
            this.auraSound.setRepeat(true).play(false);
        }
        if (kaiokenLoc != null && (allowRepeats || !SoundHandler.isPlayingSound((Entity)this.npc, kaiokenLoc))) {
            this.kaiokenSound = new AuraSound(this.aura, new SoundSource(kaiokenLoc, (Entity)this.npc));
            this.kaiokenSound.isGUIAura = true;
            this.kaiokenSound.setRepeat(true).play(false);
        }
        if (kettleLoc != null && (allowRepeats || !SoundHandler.isPlayingSound((Entity)this.npc, kettleLoc))) {
            this.kettleSound = new AuraSound(this.aura, new SoundSource(kettleLoc, (Entity)this.npc));
            this.kettleSound.isGUIAura = true;
            this.kettleSound.soundSource.fadeFactor *= 10.0f;
            this.kettleSound.setRepeat(true).play(false);
        }
        if (secondLoc != null && (allowRepeats || !SoundHandler.isPlayingSound((Entity)this.npc, secondLoc))) {
            this.secondarySound = new AuraSound(this.aura, new SoundSource(secondLoc, (Entity)this.npc));
            this.secondarySound.isGUIAura = true;
            this.secondarySound.setRepeat(true).play(false);
        }
        if (secondaryKettleLoc != null && (allowRepeats || !SoundHandler.isPlayingSound((Entity)this.npc, secondaryKettleLoc))) {
            this.secondaryKettleSound = new AuraSound(this.aura, new SoundSource(secondaryKettleLoc, (Entity)this.npc));
            this.secondaryKettleSound.isGUIAura = true;
            this.secondaryKettleSound.soundSource.fadeFactor *= 10.0f;
            this.secondaryKettleSound.setRepeat(true).play(false);
        }
    }

    public void stopSound(AuraSound sound, boolean immediate) {
        if (sound != null) {
            if (immediate) {
                sound.stop(false);
            } else {
                sound.soundSource.fadeOut = true;
                sound.soundSource.fadeFactor = 0.075f;
            }
            sound = null;
        }
    }

    protected void func_146284_a(GuiButton guibutton) {
        GuiNpcButton button = (GuiNpcButton)guibutton;
        if (button.field_146127_k == 0) {
            this.save();
            String name = "New";
            while (this.data.containsKey(name)) {
                name = name + "_";
            }
            Aura aura = new Aura(-1, name);
            PacketHandler.Instance.sendToServer(new DBCSaveAura(aura.writeToNBT(), "").generatePacket());
        } else if (button.field_146127_k == 1) {
            if (this.data.containsKey(this.scrollAuras.getSelected())) {
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, this.scrollAuras.getSelected(), StatCollector.func_74838_a((String)"gui.delete"), 1);
                this.displayGuiScreen((GuiScreen)guiyesno);
            }
        } else if (button.field_146127_k == 2) {
            Aura aura = (Aura)this.aura.clone();
            while (this.data.containsKey(aura.name)) {
                aura.name = aura.name + "_";
            }
            PacketHandler.Instance.sendToServer(new DBCSaveAura(aura.writeToNBT(), "").generatePacket());
        }
        if (this.aura == null) {
            return;
        }
        if (button.field_146127_k == 30) {
            this.setNormalSound = true;
            this.setSubGui((SubGuiInterface)new GuiSoundSelection(this.getTextField(30).func_146179_b()));
        } else if (button.field_146127_k == 301) {
            this.aura.display.auraSound = "jinryuudragonbc:DBC.aura";
            this.func_73866_w_();
        } else if (button.field_146127_k == 31) {
            this.setNormalSound = false;
            this.setSubGui((SubGuiInterface)new GuiSoundSelection(this.getTextField(31).func_146179_b()));
        } else if (button.field_146127_k == 311) {
            this.aura.display.kaiokenSound = "";
            this.func_73866_w_();
        } else if (button.field_146127_k == 3) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new SubGuiAuraDisplay(this));
        }
    }

    public void setGuiData(NBTTagCompound compound) {
        int oldID = this.aura != null ? this.aura.id : -1;
        this.aura = new Aura();
        this.aura.readFromNBT(compound);
        this.setSelected(this.aura.name);
        if (this.aura.id != -1) {
            boolean sameID;
            AuraController.getInstance().customAuras.replace(this.aura.id, this.aura);
            this.display = this.aura.display;
            this.visualDisplay.auraID = this.aura.id;
            this.visualDisplay.outlineID = this.display.outlineID;
            this.visualDisplay.auraOn = true;
            boolean bl = sameID = this.aura.id == oldID;
            if (!sameID) {
                this.stopSound(this.auraSound, false);
                this.stopSound(this.kaiokenSound, false);
                this.stopSound(this.secondarySound, false);
                this.stopSound(this.kettleSound, false);
                this.stopSound(this.secondaryKettleSound, false);
                this.playSound(true);
            }
        }
        this.func_73866_w_();
    }

    public boolean isMouseOverRenderer(int x, int y) {
        return x >= this.guiLeft + 10 && x <= this.guiLeft + 10 + 200 && y >= this.guiTop + 6 && y <= this.guiTop + 6 + 204;
    }

    public void func_73863_a(int i, int j, float f) {
        if (this.isMouseOverRenderer(i, j)) {
            this.zoomed += (float)Mouse.getDWheel() * 0.035f;
            if (this.zoomed > 100.0f) {
                this.zoomed = 100.0f;
            }
            if (this.zoomed < 10.0f) {
                this.zoomed = 10.0f;
            }
        }
        if (Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)1)) {
            this.rotation -= (float)Mouse.getDX() * 0.75f;
        }
        super.func_73863_a(i, j, f);
        if (this.hasSubGui()) {
            return;
        }
        int ticks = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
        if (auraTicks != ticks) {
            this.renderAura = true;
        }
        SubGuiAuraDisplay.useGUIAura = true;
        if (ticks % 5 == 0 && this.renderAura && this.visualDisplay.auraID != -1) {
            EntityAura enhancedAura = this.visualDisplay.auraEntity;
            boolean kaioken = this.visualDisplay.isKaioken;
            if (this.revampedAura == 1) {
                if (enhancedAura == null) {
                    enhancedAura = new EntityAura((Entity)this.npc, this.aura).load(true).spawn();
                    enhancedAura.isInKaioken = kaioken;
                    enhancedAura.isGUIAura = true;
                } else if (ticks % 10 == 0) {
                    EntityAura kaiokenAura;
                    enhancedAura.load(true);
                    if (kaioken && (kaiokenAura = enhancedAura.children.get("Kaioken")) != null) {
                        kaiokenAura.loadKaioken();
                    }
                }
            } else {
                if (enhancedAura != null) {
                    enhancedAura.despawn();
                }
                if (kaioken && this.display.kaiokenOverrides) {
                    ClientEventHandler.spawnKaiokenAura(this.aura, this.visualDisplay);
                } else {
                    ClientEventHandler.spawnAura((Entity)this.npc, this.aura);
                    if (this.aura.hasSecondaryAura()) {
                        ClientEventHandler.spawnAura((Entity)this.npc, this.aura.getSecondaryAur());
                    }
                    if (kaioken) {
                        ClientEventHandler.spawnKaiokenAura(this.aura, this.visualDisplay);
                    }
                }
            }
            auraTicks = ticks;
            this.renderAura = false;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EntityNPCInterface entity = this.npc;
        int l = this.guiLeft + 110;
        int i1 = this.guiTop + 187;
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)l, (float)i1, (float)60.0f);
        GL11.glScalef((float)(-this.zoomed), (float)this.zoomed, (float)this.zoomed);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f7 = entity.field_70759_as;
        float f5 = (float)l - (float)i;
        float f6 = (float)(i1 - 50) - (float)j;
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(f6 / 800.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        entity.field_70760_ar = entity.field_70761_aq = this.rotation;
        entity.field_70126_B = entity.field_70177_z = (float)Math.atan(f5 / 80.0f) * 40.0f + this.rotation;
        entity.field_70125_A = entity.field_70127_C = -((float)Math.atan(f6 / 80.0f)) * 10.0f;
        entity.field_70758_at = entity.field_70759_as = entity.field_70177_z;
        GL11.glTranslatef((float)0.0f, (float)(0.1f + entity.field_70129_M), (float)1.0f);
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        try {
            RenderManager.field_78727_a.func_147940_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SubGuiAuraDisplay.useGUIAura = false;
        entity.field_70760_ar = entity.field_70761_aq = f2;
        entity.field_70126_B = entity.field_70177_z = f3;
        entity.field_70125_A = entity.field_70127_C = f4;
        entity.field_70758_at = entity.field_70759_as = f7;
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glClear((int)256);
        GL11.glPopMatrix();
    }

    public void drawBackground() {
        super.drawBackground();
        int xPosGradient = this.guiLeft + 10;
        int yPosGradient = this.guiTop + 6;
        this.func_73733_a(xPosGradient, yPosGradient, 200 + xPosGradient, 204 + yPosGradient, -1072689136, -804253680);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderScreen();
    }

    private void renderScreen() {
    }

    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (this.getTextField(55) != null && this.getTextField(55).func_146206_l()) {
            if (this.search.equals(this.getTextField(55).func_146179_b())) {
                return;
            }
            this.search = this.getTextField(55).func_146179_b().toLowerCase();
            this.scrollAuras.resetScroll();
            this.scrollAuras.setList(this.getSearchList());
        }
    }

    private List<String> getSearchList() {
        if (this.search.isEmpty()) {
            return new ArrayList<String>(this.data.keySet());
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.data.keySet()) {
            if (!name.toLowerCase().contains(this.search)) continue;
            list.add(name);
        }
        return list;
    }

    public void setData(Vector<String> list, HashMap<String, Integer> data) {
        String name = this.scrollAuras.getSelected();
        this.data = data;
        this.scrollAuras.setList(this.getSearchList());
        if (name != null) {
            this.scrollAuras.setSelected(name);
        }
    }

    public void setSelected(String selected) {
        this.selected = selected;
        this.scrollAuras.setSelected(selected);
        this.originalName = this.scrollAuras.getSelected();
    }

    public void customScrollClicked(int i, int j, int k, GuiCustomScroll guiCustomScroll) {
        if (guiCustomScroll.id == 0) {
            this.save();
            this.selected = this.scrollAuras.getSelected();
            this.originalName = this.scrollAuras.getSelected();
            if (this.selected != null && !this.selected.isEmpty()) {
                PacketHandler.Instance.sendToServer(new DBCGetAura(this.data.get(this.selected)).generatePacket());
            }
        }
    }

    public void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        if (k == 0) {
            for (GuiMenuTopButton button : this.getMenu().topButtons) {
                if (!button.func_146116_c(this.field_146297_k, i, j)) continue;
                this.stopSound(this.auraSound, false);
                this.stopSound(this.kaiokenSound, false);
                this.stopSound(this.secondarySound, false);
                this.stopSound(this.kettleSound, false);
                this.stopSound(this.secondaryKettleSound, false);
            }
        }
    }

    public void customScrollDoubleClicked(String selection, GuiCustomScroll scroll) {
        super.customScrollDoubleClicked(selection, scroll);
    }

    public void save() {
        if (this.selected != null && this.data.containsKey(this.selected) && this.aura != null) {
            PacketHandler.Instance.sendToServer(new DBCSaveAura(this.aura.writeToNBT(), this.originalName).generatePacket());
        }
    }

    public void close() {
        this.stopSound(this.auraSound, false);
        this.stopSound(this.kaiokenSound, false);
        this.stopSound(this.secondarySound, false);
        this.stopSound(this.kettleSound, false);
        this.stopSound(this.secondaryKettleSound, false);
        super.close();
    }

    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui instanceof GuiSoundSelection) {
            GuiSoundSelection gss = (GuiSoundSelection)subgui;
            if (gss.selectedResource != null) {
                if (this.setNormalSound) {
                    this.getTextField(30).func_146180_a(gss.selectedResource.toString());
                    this.unFocused(this.getTextField(30));
                } else {
                    this.getTextField(31).func_146180_a(gss.selectedResource.toString());
                    this.unFocused(this.getTextField(31));
                }
                this.func_73866_w_();
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        NoppesUtil.openGUI((EntityPlayer)this.player, (Object)((Object)this));
        if (!result) {
            return;
        }
        if (id == 1 && this.data.containsKey(this.scrollAuras.getSelected())) {
            PacketHandler.Instance.sendToServer(new DBCRemoveAura(this.data.get(this.scrollAuras.getSelected())).generatePacket());
            this.scrollAuras.clear();
            this.aura = new Aura();
            this.visualDisplay.auraOn = false;
            this.visualDisplay.auraID = -1;
            this.visualDisplay.outlineID = -1;
            this.stopSound(this.auraSound, false);
            this.stopSound(this.kaiokenSound, false);
            this.stopSound(this.secondarySound, false);
            this.stopSound(this.kettleSound, false);
            this.stopSound(this.secondaryKettleSound, false);
            this.func_73866_w_();
        }
    }

    public void unFocused(GuiNpcTextField guiNpcTextField) {
        String menuName;
        if (this.aura == null || this.aura.id == -1) {
            return;
        }
        if (guiNpcTextField.id == 13) {
            String name = guiNpcTextField.func_146179_b();
            if (!name.isEmpty() && !this.data.containsKey(name)) {
                String old = this.aura.name;
                this.data.remove(this.aura.name);
                this.aura.name = name;
                this.data.put(this.aura.name, this.aura.id);
                this.selected = name;
                this.scrollAuras.replace(old, this.aura.name);
            } else {
                guiNpcTextField.func_146180_a(this.aura.name);
            }
        }
        if (guiNpcTextField.id == 14 && !(menuName = guiNpcTextField.func_146179_b()).isEmpty()) {
            this.aura.menuName = menuName.replaceAll("&", "\u00a7");
        }
        if (guiNpcTextField.id == 30) {
            this.aura.display.auraSound = guiNpcTextField.func_146179_b();
            boolean bl = this.getButton((int)301).field_146124_l = !this.aura.display.auraSound.equals("jinryuudragonbc:DBC.aura");
        }
        if (guiNpcTextField.id == 31) {
            this.aura.display.kaiokenSound = guiNpcTextField.func_146179_b();
            this.getButton((int)311).field_146124_l = !this.aura.display.kaiokenSound.isEmpty();
        }
    }
}

