/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.gui.hud.formWheel;

import kamkeel.npcdbc.client.gui.hud.WheelSegment;
import kamkeel.npcdbc.client.gui.hud.formWheel.HUDFormWheel;
import kamkeel.npcdbc.client.gui.hud.formWheel.icon.FormIcon;
import kamkeel.npcdbc.config.ConfigDBCClient;
import kamkeel.npcdbc.constants.DBCForm;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.data.FormWheelData;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.form.FormStackable;
import kamkeel.npcdbc.network.PacketHandler;
import kamkeel.npcdbc.network.packets.form.DBCSaveFormWheel;
import kamkeel.npcdbc.network.packets.form.DBCSelectForm;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;

class FormWheelSegment
extends WheelSegment {
    public HUDFormWheel parent;
    public Form form;
    public FormWheelData data = new FormWheelData();
    private FormIcon icon = null;

    FormWheelSegment(HUDFormWheel parent, int index) {
        this(parent, 0, 0, index);
    }

    FormWheelSegment(HUDFormWheel parent, int posX, int posY, int index) {
        super(index);
        this.parent = parent;
        this.posX = posX;
        this.posY = posY;
        this.index = this.data.slot = index;
    }

    public void selectForm() {
        PacketHandler.Instance.sendToServer(new DBCSelectForm(this.data.formID, this.data.isDBC).generatePacket());
    }

    public void setForm(int formID, boolean isDBC, boolean updateServer) {
        this.data.formID = formID;
        this.data.isDBC = isDBC;
        Form form = this.form = !this.data.isDBC ? (Form)FormController.getInstance().get(this.data.formID) : null;
        if (updateServer) {
            PacketHandler.Instance.sendToServer(new DBCSaveFormWheel(this.index, this.data).generatePacket());
        }
        this.icon = this.form != null ? new FormIcon(this.parent, this.form) : new FormIcon(this.parent, this.data.formID);
    }

    public void setForm(FormWheelData data, boolean updateServer) {
        this.data = data;
        Form form = this.form = !data.isDBC ? (Form)FormController.getInstance().get(data.formID) : null;
        if (updateServer) {
            PacketHandler.Instance.sendToServer(new DBCSaveFormWheel(this.index, data).generatePacket());
        }
        this.icon = this.form != null ? new FormIcon(this.parent, this.form) : new FormIcon(this.parent, data.formID);
    }

    public void removeForm() {
        this.data.reset();
        this.form = null;
        PacketHandler.Instance.sendToServer(new DBCSaveFormWheel(this.index, this.data).generatePacket());
        if (this.parent.hoveredSlot == this.index) {
            this.parent.selectSlot(-1);
        }
        this.parent.timeClosedSubGui = Minecraft.func_71386_F();
        this.icon = null;
    }

    @Override
    protected void drawWheelItem(FontRenderer fontRenderer) {
        if (this.data.formID != -1) {
            if (this.index == 1 || this.index == 5) {
                GL11.glTranslatef((float)0.0f, (float)10.0f, (float)0.0f);
            } else if (this.index == 2 || this.index == 4) {
                GL11.glTranslatef((float)0.0f, (float)-10.0f, (float)0.0f);
            }
            if (ConfigDBCClient.AlteranteSelectionWheelTexture) {
                GL11.glScaled((double)0.7, (double)0.7, (double)1.0);
                switch (this.index) {
                    case 0: {
                        GL11.glTranslatef((float)0.0f, (float)-15.0f, (float)0.0f);
                        break;
                    }
                    case 1: {
                        GL11.glTranslatef((float)-12.0f, (float)-5.0f, (float)0.0f);
                        break;
                    }
                    case 2: {
                        GL11.glTranslatef((float)-11.0f, (float)3.0f, (float)0.0f);
                        break;
                    }
                    case 3: {
                        GL11.glTranslatef((float)0.0f, (float)12.0f, (float)0.0f);
                        break;
                    }
                    case 4: {
                        GL11.glTranslatef((float)10.0f, (float)3.0f, (float)0.0f);
                        break;
                    }
                    default: {
                        GL11.glTranslatef((float)13.0f, (float)-5.0f, (float)0.0f);
                    }
                }
            }
            if (this.data.isDBC) {
                if (!this.parent.dbcForms.containsKey(this.data.formID)) {
                    this.removeForm();
                }
            } else if (!this.parent.dbcInfo.hasFormUnlocked(this.data.formID)) {
                this.removeForm();
            }
            if (this.icon != null) {
                GL11.glTranslatef((float)0.0f, (float)(-this.icon.height / 2.0f), (float)0.0f);
                this.icon.draw();
                GL11.glTranslatef((float)0.0f, (float)this.icon.height, (float)0.0f);
            }
            this.func_73732_a(fontRenderer, this.getFormName(), 0, 0, -1);
        }
    }

    public String getFormName() {
        DBCData dbcData = DBCData.get(this.parent.dbcInfo.parent.player);
        if (!this.data.isDBC) {
            return this.form != null ? this.getFormVariant((Form)this.form, (DBCData)dbcData).menuName : "";
        }
        return DBCForm.getMenuName(dbcData.Race, this.data.formID, dbcData.isForm(26));
    }

    private Form getFormVariant(Form form, DBCData dbcData) {
        boolean isLegendary = dbcData.isForm(25);
        boolean isDivine = dbcData.isForm(26);
        boolean isMajin = dbcData.isForm(27);
        boolean isFused = dbcData.stats.isFused();
        FormStackable stackable = form.stackable;
        FormController formController = FormController.Instance;
        if (formController.has(stackable.fusionID) && isFused) {
            form = (Form)formController.get(stackable.fusionID);
            stackable = form.stackable;
        }
        if (formController.has(stackable.divineID) && isDivine) {
            form = (Form)formController.get(stackable.divineID);
        } else if (formController.has(stackable.legendaryID) && isLegendary) {
            form = (Form)formController.get(stackable.legendaryID);
        } else if (formController.has(stackable.majinID) && isMajin) {
            form = (Form)formController.get(stackable.majinID);
        }
        return form;
    }
}

