/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.shader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import kamkeel.npcdbc.CommonProxy;
import kamkeel.npcdbc.client.ClientProxy;
import kamkeel.npcdbc.client.shader.IShaderUniform;
import kamkeel.npcdbc.config.ConfigDBCClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Matrix4f;

public final class ShaderHelper {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    private static List<Integer> programs = new ArrayList<Integer>();
    public static Class Shaders;
    public static boolean optifineShadersLoaded;
    public static int currentProgram;
    public static int currentOptifineProgram;
    private static int lastUsedProgram;
    public static boolean usingDBCShader;
    public static int defaultTexture;
    public static int pylonGlow;
    public static int enchanterRune;
    public static int manaPool;
    public static int doppleganger;
    public static int halo;
    public static int dopplegangerBar;
    public static int terraPlateRune;
    public static int filmGrain;
    public static int gold;
    public static int categoryButton;
    public static int aura;
    public static int outline;
    public static int perlinNoise;
    public static int blur;
    public static int additiveCombine;
    public static int downsample13;
    public static int upsampleTent;
    public static int modern;

    public static void loadShaders(boolean reload) {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        if (reload) {
            ShaderHelper.deleteShaders();
        }
        defaultTexture = ShaderHelper.createProgram("/assets/npcdbc/shader/default.vert", "/assets/npcdbc/shader/defaultTexture.frag");
        pylonGlow = ShaderHelper.createProgram(null, "/assets/npcdbc/shader/pylon_glow.frag");
        enchanterRune = ShaderHelper.createProgram(null, "/assets/npcdbc/shader/enchanter_rune.frag");
        manaPool = ShaderHelper.createProgram(null, "/assets/npcdbc/shader/mana_pool.frag");
        doppleganger = ShaderHelper.createProgram("/assets/npcdbc/shader/doppleganger.vert", "/assets/npcdbc/shader/doppleganger.frag");
        halo = ShaderHelper.createProgram(null, "/assets/npcdbc/shader/halo.frag");
        dopplegangerBar = ShaderHelper.createProgram(null, "/assets/npcdbc/shader/doppleganger_bar.frag");
        terraPlateRune = ShaderHelper.createProgram(null, "/assets/npcdbc/shader/terra_plate_rune.frag");
        filmGrain = ShaderHelper.createProgram(null, "/assets/npcdbc/shader/film_grain.frag");
        gold = ShaderHelper.createProgram(null, "/assets/npcdbc/shader/gold.frag");
        categoryButton = ShaderHelper.createProgram(null, "/assets/npcdbc/shader/category_button.frag");
        aura = ShaderHelper.createProgram("/assets/npcdbc/shader/aura.vert", "/assets/npcdbc/shader/aura.frag");
        outline = ShaderHelper.createProgram("/assets/npcdbc/shader/outline.vert", "/assets/npcdbc/shader/outline.frag");
        perlinNoise = ShaderHelper.createProgram("/assets/npcdbc/shader/perlin.vert", "/assets/npcdbc/shader/perlin.frag");
        blur = ShaderHelper.createProgram("/assets/npcdbc/shader/default.vert", "/assets/npcdbc/shader/blur.frag");
        additiveCombine = ShaderHelper.createProgram("/assets/npcdbc/shader/default.vert", "/assets/npcdbc/shader/AdditiveCombine.frag");
        downsample13 = ShaderHelper.createProgram("/assets/npcdbc/shader/default.vert", "/assets/npcdbc/shader/downsample_13tap.frag");
        upsampleTent = ShaderHelper.createProgram("/assets/npcdbc/shader/default.vert", "/assets/npcdbc/shader/upsample_filter.frag");
        modern = ShaderHelper.createProgram("/assets/npcdbc/shader/modern/default.vert", "/assets/npcdbc/shader/modern/defaultTexture.frag");
    }

    public static void useShader(int shader, IShaderUniform uniforms) {
        if (!ShaderHelper.useShaders()) {
            return;
        }
        if (!usingDBCShader) {
            lastUsedProgram = GL11.glGetInteger((int)35725);
            usingDBCShader = true;
        }
        currentProgram = shader;
        ARBShaderObjects.glUseProgramObjectARB((int)currentProgram);
        if (shader != 0) {
            ShaderHelper.uniform1f("time", ClientProxy.getTimeSinceStart());
            ShaderHelper.uniformVec2("u_resolution", Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            if (uniforms != null) {
                ShaderHelper.loadUniforms(uniforms);
            }
        }
    }

    public static void loadUniforms(IShaderUniform uniforms) {
        uniforms.load();
    }

    public static void useShader(int shader) {
        ShaderHelper.useShader(shader, null);
    }

    public static void releaseShader() {
        ShaderHelper.useShader(lastUsedProgram);
        usingDBCShader = false;
    }

    public static boolean useShaders() {
        return ConfigDBCClient.EnableShaders && OpenGlHelper.field_148824_g;
    }

    private static int createProgram(String vert, String frag) {
        int vertexShader = 0;
        int fragmentShader = 0;
        int program = 0;
        if (vert != null) {
            vertexShader = ShaderHelper.createShader(vert, 35633);
        }
        if (frag != null) {
            fragmentShader = ShaderHelper.createShader(frag, 35632);
        }
        if ((program = (currentProgram = ARBShaderObjects.glCreateProgramObjectARB())) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertexShader);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragmentShader);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            CommonProxy.LOGGER.error(ShaderHelper.getLogInfo(program));
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            CommonProxy.LOGGER.error(ShaderHelper.getLogInfo(program));
            return 0;
        }
        ARBShaderObjects.glDeleteObjectARB((int)vertexShader);
        ARBShaderObjects.glDeleteObjectARB((int)fragmentShader);
        ShaderHelper.bindAttribute(0, "vertexPosition");
        ShaderHelper.bindAttribute(1, "colors");
        ShaderHelper.bindAttribute(2, "texCoords");
        programs.add(program);
        return program;
    }

    public static void bindAttribute(int attribute, String variableName) {
        GL20.glBindAttribLocation((int)currentProgram, (int)attribute, (CharSequence)variableName);
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderHelper.readFile(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                CommonProxy.LOGGER.error("Error creating shader " + filename + ": " + ShaderHelper.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    public static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String filename) throws Exception {
        StringBuilder source;
        block28: {
            source = new StringBuilder();
            InputStream in = ShaderHelper.class.getResourceAsStream(filename);
            Exception exception = null;
            if (in == null) {
                CommonProxy.LOGGER.error("Resource not found: " + filename);
                return "";
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                Exception innerExc = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        source.append(line).append('\n');
                    }
                }
                catch (Exception exc) {
                    exception = exc;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception exc) {
                        if (innerExc == null) {
                            innerExc = exc;
                        }
                        exc.printStackTrace();
                    }
                }
                if (innerExc != null) {
                    throw innerExc;
                }
            }
            catch (Exception exc) {
                exception = exc;
                return exception;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exc) {
                    if (exception == null) {
                        exception = exc;
                    }
                    exc.printStackTrace();
                }
                if (exception == null) break block28;
                throw exception;
            }
        }
        return source.toString();
    }

    public static void deleteShaders() {
        for (Integer p : programs) {
            ARBShaderObjects.glDeleteObjectARB((int)p);
        }
    }

    public static void bindOptifineShader() {
        try {
            Shaders.getMethod("useProgram", new Class[0]).invoke(null, currentOptifineProgram);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean areOptifineShadersLoaded() {
        try {
            Shaders = Class.forName("shadersmod.client.Shaders");
            String shaderPack = (String)Shaders.getMethod("getShaderPackName", new Class[0]).invoke(null, new Object[0]);
            if (shaderPack != null) {
                optifineShadersLoaded = true;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        optifineShadersLoaded = false;
        return false;
    }

    public static void uniform1f(String name, float x) {
        int uniformLocation = ARBShaderObjects.glGetUniformLocationARB((int)currentProgram, (CharSequence)name);
        ARBShaderObjects.glUniform1fARB((int)uniformLocation, (float)x);
    }

    public static void uniform1i(String name, int x) {
        int uniformLocation = ARBShaderObjects.glGetUniformLocationARB((int)currentProgram, (CharSequence)name);
        ARBShaderObjects.glUniform1iARB((int)uniformLocation, (int)x);
    }

    public static void uniformArray(String name, float[] array) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)array.length);
        buffer.put(array);
        buffer.flip();
        ShaderHelper.uniformBuffer(name, buffer);
    }

    public static void uniformArray(String name, int[] array) {
        IntBuffer buffer = BufferUtils.createIntBuffer((int)array.length);
        buffer.put(array);
        buffer.flip();
        ShaderHelper.uniformBuffer(name, buffer);
    }

    public static void uniformVec2(String name, float x, float y) {
        int uniformLocation = ARBShaderObjects.glGetUniformLocationARB((int)currentProgram, (CharSequence)name);
        ARBShaderObjects.glUniform2fARB((int)uniformLocation, (float)x, (float)y);
    }

    public static void uniformVec3(String name, float x, float y, float z) {
        int uniformLocation = ARBShaderObjects.glGetUniformLocationARB((int)currentProgram, (CharSequence)name);
        ARBShaderObjects.glUniform3fARB((int)uniformLocation, (float)x, (float)y, (float)z);
    }

    public static void uniformVec4(String name, float x, float y, float z, float w) {
        int uniformLocation = ARBShaderObjects.glGetUniformLocationARB((int)currentProgram, (CharSequence)name);
        ARBShaderObjects.glUniform4fARB((int)uniformLocation, (float)x, (float)y, (float)z, (float)w);
    }

    public static void loadTextureUnit(int textureUnit, String textureLoc) {
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)(33984 + textureUnit));
        noppes.npcs.client.ClientProxy.bindTexture((ResourceLocation)new ResourceLocation(textureLoc));
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static void uniformTexture(String name, int textureUnit, String textureLoc) {
        ShaderHelper.loadTextureUnit(textureUnit, textureLoc);
        int uniformLocation = ARBShaderObjects.glGetUniformLocationARB((int)currentProgram, (CharSequence)name);
        ARBShaderObjects.glUniform1iARB((int)uniformLocation, (int)textureUnit);
    }

    public static void uniformTexture(String name, int textureUnit, int textureID) {
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)(33984 + textureUnit));
        GL11.glBindTexture((int)3553, (int)textureID);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        int uniformLocation = ARBShaderObjects.glGetUniformLocationARB((int)currentProgram, (CharSequence)name);
        ARBShaderObjects.glUniform1iARB((int)uniformLocation, (int)textureUnit);
    }

    public static void uniformTextureResolution(String name, String textureLoc) {
        int previousTexture = GL11.glGetInteger((int)32873);
        noppes.npcs.client.ClientProxy.bindTexture((ResourceLocation)new ResourceLocation(textureLoc));
        float width = GL11.glGetTexLevelParameterf((int)3553, (int)0, (int)4096);
        float height = GL11.glGetTexLevelParameterf((int)3553, (int)0, (int)4097);
        ShaderHelper.uniformVec2(name, width, height);
        GL11.glBindTexture((int)3553, (int)previousTexture);
    }

    public static void uniformColor(String name, int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        ShaderHelper.uniformVec4(name, r, g, b, alpha);
    }

    public static void uniformBuffer(String name, FloatBuffer buffer) {
        int uniformLocation = ARBShaderObjects.glGetUniformLocationARB((int)currentProgram, (CharSequence)name);
        ARBShaderObjects.glUniform1ARB((int)uniformLocation, (FloatBuffer)buffer);
    }

    public static void uniformBuffer(String name, IntBuffer buffer) {
        int uniformLocation = ARBShaderObjects.glGetUniformLocationARB((int)currentProgram, (CharSequence)name);
        ARBShaderObjects.glUniform1ARB((int)uniformLocation, (IntBuffer)buffer);
    }

    public static void uniformMatrix4x4(String name, FloatBuffer buffer) {
        int uniformLocation = ARBShaderObjects.glGetUniformLocationARB((int)currentProgram, (CharSequence)name);
        GL20.glUniformMatrix4((int)uniformLocation, (boolean)false, (FloatBuffer)buffer);
    }

    public static FloatBuffer matrixToBuffer(Matrix4f mat) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
        mat.store(buffer);
        return (FloatBuffer)buffer.flip();
    }

    public static Matrix4f bufferToMatrix(FloatBuffer buffer) {
        Matrix4f mat = new Matrix4f();
        mat.load(buffer);
        return mat;
    }

    public static FloatBuffer getModelView() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)buffer);
        return buffer;
    }

    public static FloatBuffer getProjection() {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2983, (FloatBuffer)buffer);
        return buffer;
    }

    static {
        lastUsedProgram = 0;
        usingDBCShader = false;
        defaultTexture = 0;
        pylonGlow = 0;
        enchanterRune = 0;
        manaPool = 0;
        doppleganger = 0;
        halo = 0;
        dopplegangerBar = 0;
        terraPlateRune = 0;
        filmGrain = 0;
        gold = 0;
        categoryButton = 0;
        aura = 0;
        outline = 0;
        perlinNoise = 0;
        blur = 0;
        additiveCombine = 0;
        downsample13 = 0;
        upsampleTent = 0;
    }
}

