/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.client.sound;

import cpw.mods.fml.common.eventhandler.Event;
import kamkeel.npcdbc.client.sound.SoundHandler;
import kamkeel.npcdbc.data.SoundSource;
import kamkeel.npcdbc.network.PacketHandler;
import kamkeel.npcdbc.network.packets.PlaySound;
import kamkeel.npcdbc.network.packets.StopSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;

public class ClientSound
extends MovingSound {
    public final SoundSource soundSource;
    public final Entity entity;
    public final String key;

    public ClientSound(SoundSource soundSource) {
        super(new ResourceLocation(soundSource.soundDir));
        this.soundSource = soundSource;
        this.entity = soundSource.entity;
        this.field_147662_b = 0.5f;
        this.key = soundSource.key;
    }

    public void func_73660_a() {
        if (this.entity == null || this.entity.field_70128_L || Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.MASTER) == 0.0f) {
            this.stop(false);
            return;
        }
        this.field_147660_d = (float)this.entity.field_70165_t;
        this.field_147661_e = (float)this.entity.field_70163_u;
        this.field_147658_f = (float)this.entity.field_70161_v;
        if (this.soundSource.fadeIn && !this.soundSource.fadeOut && this.field_147662_b < this.soundSource.maxVolume) {
            this.field_147662_b = Math.min(this.field_147662_b + this.soundSource.fadeFactor, this.soundSource.maxVolume);
        }
        if (this.soundSource.fadeOut) {
            this.field_147662_b -= this.soundSource.fadeFactor;
            if (this.field_147662_b <= 0.0f) {
                this.stop(false);
            }
        }
    }

    public ClientSound setVolume(float volume) {
        this.field_147662_b = volume;
        return this;
    }

    public ClientSound setPitch(float pitch) {
        this.field_147663_c = pitch;
        return this;
    }

    public ClientSound setRepeat(boolean repeat) {
        this.field_147659_g = repeat;
        return this;
    }

    public ClientSound setRange(float range) {
        this.soundSource.range = range;
        return this;
    }

    public void play(boolean forOthers) {
        if (forOthers) {
            PacketHandler.Instance.sendToServer(new PlaySound(this.soundSource).generatePacket());
        } else {
            PlaySoundAtEntityEvent event = new PlaySoundAtEntityEvent(this.entity, this.soundSource.soundDir, this.field_147662_b, this.func_147655_f());
            if (MinecraftForge.EVENT_BUS.post((Event)event) || this.soundSource.onlyOneCanExist && SoundHandler.playingSounds.containsKey(this.soundSource.key) && !SoundHandler.playingSounds.get((Object)this.soundSource.key).soundSource.fadeOut) {
                return;
            }
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this);
            SoundHandler.playingSounds.put(this.soundSource.key, this);
        }
    }

    public void stop(boolean forOthers) {
        this.field_147668_j = true;
        if (forOthers) {
            PacketHandler.Instance.sendToServer(new StopSound(this.soundSource).generatePacket());
        }
    }

    public boolean isPlaying() {
        return Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this);
    }
}

