/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.command;

import java.util.Iterator;
import java.util.List;
import kamkeel.command.CommandKamkeelBase;
import kamkeel.npcdbc.api.aura.IAura;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.scripted.DBCAPI;
import kamkeel.npcdbc.util.PlayerDataUtil;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerData;

public class AuraCommand
extends CommandKamkeelBase {
    public String func_71517_b() {
        return "aura";
    }

    public String getDescription() {
        return "Custom Aura operations";
    }

    @CommandKamkeelBase.SubCommand(desc="give an aura to a player by name", usage="<player> <aura_name>")
    public void give(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        String name = "";
        for (int i = 1; i < args.length; ++i) {
            name = name + args[i] + (i != args.length - 1 ? " " : "");
        }
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            AuraCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Aura aura = (Aura)DBCAPI.Instance().getAura(name);
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(playerdata);
            if (!info.hasAuraUnlocked(aura.id)) {
                info.addAura(aura);
                info.updateClient();
                AuraCommand.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7agiven to \u00a77'\u00a7b%s\u00a77'", aura.getName(), playerdata.playername), (Object[])new Object[0]);
                if (sender != playerdata.player) {
                    AuraCommand.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7Aura \u00a77%s \u00a7aadded.", aura.getName()), (Object[])new Object[0]);
                }
            } else {
                AuraCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a77'\u00a7b%s\u00a77' \u00a7ealready has \u00a77%s \u00a7eunlocked!", playerdata.playername, aura.getName()), (Object[])new Object[0]);
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="give an aura to a player by numerical ID", usage="<player> <aura_ID>")
    public void giveid(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        int id = Integer.parseInt(args[1]);
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            AuraCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Aura aura = (Aura)DBCAPI.Instance().getAuraHandler().get(id);
        if (aura == null) {
            AuraCommand.sendError((ICommandSender)sender, (String)("Unknown aura: " + id), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(playerdata);
            if (!info.hasAuraUnlocked(aura.id)) {
                info.addAura(aura);
                info.updateClient();
                AuraCommand.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7agiven to \u00a77'\u00a7b%s\u00a77'", aura.getName(), playerdata.playername), (Object[])new Object[0]);
                if (sender != playerdata.player) {
                    AuraCommand.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7Aura \u00a77%s \u00a7aadded.", aura.getName()), (Object[])new Object[0]);
                }
            } else {
                AuraCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a77'\u00a7b%s\u00a77' \u00a7ealready has \u00a77%s \u00a7eunlocked!", playerdata.playername, aura.getName()), (Object[])new Object[0]);
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="remove an aura from a player by name", usage="<player> <aura_name>")
    public void remove(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        String name = "";
        for (int i = 1; i < args.length; ++i) {
            name = name + args[i] + (i != args.length - 1 ? " " : "");
        }
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            AuraCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Aura aura = (Aura)DBCAPI.Instance().getAura(name);
        if (aura == null) {
            AuraCommand.sendError((ICommandSender)sender, (String)("Unknown aura: " + name), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo playerDBCInfo = PlayerDataUtil.getDBCInfo(playerdata);
            if (playerDBCInfo.hasAura(aura)) {
                playerDBCInfo.removeAura(aura);
                if (playerDBCInfo.selectedAura == aura.id) {
                    playerDBCInfo.selectedAura = -1;
                }
                if (playerDBCInfo.currentAura == aura.id) {
                    playerDBCInfo.currentAura = -1;
                }
                playerDBCInfo.updateClient();
                AuraCommand.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7cremoved from \u00a77'\u00a7b%s\u00a77'", aura.getName(), playerdata.playername), (Object[])new Object[0]);
                if (sender != playerdata.player) {
                    AuraCommand.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7cForm \u00a77%s \u00a7cremoved.", aura.getName()), (Object[])new Object[0]);
                }
            } else {
                AuraCommand.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7enot found on \u00a77'\u00a7b%s\u00a77'", aura.getName(), playerdata.playername), (Object[])new Object[0]);
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="remove an aura from a player by numerical ID", usage="<player> <aura_ID>")
    public void removeid(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        int id = Integer.parseInt(args[1]);
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            AuraCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Aura aura = (Aura)DBCAPI.Instance().getAuraHandler().get(id);
        if (aura == null) {
            AuraCommand.sendError((ICommandSender)sender, (String)("Unknown aura: " + id), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo playerDBCInfo = PlayerDataUtil.getDBCInfo(playerdata);
            if (playerDBCInfo.hasAura(aura)) {
                playerDBCInfo.removeAura(aura);
                if (playerDBCInfo.selectedAura == aura.id) {
                    playerDBCInfo.selectedAura = -1;
                }
                if (playerDBCInfo.currentAura == aura.id) {
                    playerDBCInfo.currentAura = -1;
                }
                playerDBCInfo.updateClient();
                AuraCommand.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7cremoved from \u00a77'\u00a7b%s\u00a77'", aura.getName(), playerdata.playername), (Object[])new Object[0]);
                if (sender != playerdata.player) {
                    AuraCommand.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7cForm \u00a77%s \u00a7cremoved.", aura.getName()), (Object[])new Object[0]);
                }
            } else {
                AuraCommand.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7enot found on \u00a77'\u00a7b%s\u00a77'", aura.getName(), playerdata.playername), (Object[])new Object[0]);
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="clears all auras from a player", usage="<player>")
    public void clear(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            AuraCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo playerDBCInfo = PlayerDataUtil.getDBCInfo(playerdata);
            playerDBCInfo.unlockedAuras.clear();
            playerDBCInfo.currentAura = -1;
            playerDBCInfo.selectedAura = -1;
            playerDBCInfo.updateClient();
            AuraCommand.sendResult((ICommandSender)sender, (String)String.format("Removed all auras from \u00a77'\u00a7b%s\u00a77'", playerdata.playername), (Object[])new Object[0]);
            if (sender != playerdata.player) {
                AuraCommand.sendResult((ICommandSender)playerdata.player, (String)String.format("All custom auras removed.", new Object[0]), (Object[])new Object[0]);
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="List all auras on a player", usage="<player>")
    public void info(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            AuraCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            AuraCommand.sendResult((ICommandSender)sender, (String)"--------------------", (Object[])new Object[0]);
            PlayerDBCInfo playerDBCInfo = PlayerDataUtil.getDBCInfo(playerdata);
            if (playerDBCInfo.unlockedAuras.isEmpty()) {
                AuraCommand.sendResult((ICommandSender)sender, (String)String.format("No Auras found for \u00a77'\u00a7b%s\u00a77'", playerdata.playername), (Object[])new Object[0]);
            } else {
                for (int formID : playerDBCInfo.unlockedAuras) {
                    IAura aura = AuraController.getInstance().get(formID);
                    if (aura == null) continue;
                    AuraCommand.sendResult((ICommandSender)sender, (String)String.format("%s", aura.getName()), (Object[])new Object[0]);
                }
            }
            AuraCommand.sendResult((ICommandSender)sender, (String)"--------------------", (Object[])new Object[0]);
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Lists all existing auras")
    public void infoall(ICommandSender sender, String[] args) throws CommandException {
        AuraCommand.sendResult((ICommandSender)sender, (String)"--------------------", (Object[])new Object[0]);
        for (Aura aura : AuraController.getInstance().customAuras.values()) {
            AuraCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a7b%s \u00a77(ID: %d)", aura.getName(), aura.id), (Object[])new Object[0]);
        }
        AuraCommand.sendResult((ICommandSender)sender, (String)"--------------------", (Object[])new Object[0]);
    }

    @CommandKamkeelBase.SubCommand(desc="Reloads all auras")
    public void reload(ICommandSender sender, String[] args) {
        AuraController.Instance.load();
        AuraCommand.sendResult((ICommandSender)sender, (String)"Auras reloaded!", (Object[])new Object[0]);
    }
}

