/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.command;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kamkeel.command.CommandKamkeelBase;
import kamkeel.npcdbc.controllers.StatusEffectController;
import kamkeel.npcdbc.data.statuseffect.StatusEffect;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerData;

public class EffectCommand
extends CommandKamkeelBase {
    public String getDescription() {
        return "Custom Effect operations";
    }

    public String func_71517_b() {
        return "effect";
    }

    @CommandKamkeelBase.SubCommand(desc="Lists all effects")
    public void infoAll(ICommandSender sender, String[] args) throws CommandException {
        Set<Map.Entry<Integer, StatusEffect>> effects = StatusEffectController.getInstance().standardEffects.entrySet();
        if (effects.isEmpty()) {
            EffectCommand.sendError((ICommandSender)sender, (String)"No effects found.", (Object[])new Object[0]);
            return;
        }
        EffectCommand.sendResult((ICommandSender)sender, (String)"--------------------", (Object[])new Object[0]);
        for (Map.Entry<Integer, StatusEffect> entry : effects) {
            EffectCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a7b%2$s \u00a77(ID: %1$s)", entry.getKey(), entry.getValue().getName()), (Object[])new Object[0]);
        }
        EffectCommand.sendResult((ICommandSender)sender, (String)"--------------------", (Object[])new Object[0]);
    }

    @CommandKamkeelBase.SubCommand(desc="Gives a effect to a player", usage="<player> <time> <effectName>")
    public void give(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        int time = Integer.parseInt(args[1]);
        String name = "";
        for (int i = 2; i < args.length; ++i) {
            name = name + args[i] + (i != args.length - 1 ? " " : "");
        }
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            EffectCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        StatusEffect statusEffect = StatusEffectController.getInstance().getFromName(name);
        if (statusEffect == null) {
            EffectCommand.sendError((ICommandSender)sender, (String)("Unknown effect: " + name), (Object[])new Object[0]);
            return;
        }
        for (PlayerData playerdata : data) {
            StatusEffectController.getInstance().applyEffect(playerdata.player, statusEffect.getId(), time);
            EffectCommand.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7agiven to \u00a77'\u00a7b%s\u00a77'", statusEffect.getName(), playerdata.playername), (Object[])new Object[0]);
            if (sender == playerdata.player) continue;
            EffectCommand.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7Effect \u00a77%s \u00a7aadded.", statusEffect.getName()), (Object[])new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Removes a effect from a player", usage="<player> <effectName>")
    public void remove(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        String name = "";
        for (int i = 1; i < args.length; ++i) {
            name = name + args[i] + (i != args.length - 1 ? " " : "");
        }
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            EffectCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        StatusEffect statusEffect = StatusEffectController.getInstance().getFromName(name);
        if (statusEffect == null) {
            EffectCommand.sendError((ICommandSender)sender, (String)("Unknown effect: " + name), (Object[])new Object[0]);
            return;
        }
        for (PlayerData playerData : data) {
            StatusEffectController.getInstance().removeEffect(playerData.player, statusEffect.getId());
            EffectCommand.sendResult((ICommandSender)sender, (String)String.format("Effect %s removed from %s", statusEffect.getName(), playerData.playername), (Object[])new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Gives a effect to a player", usage="<player> <time> <effectId>")
    public void giveId(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        int time = Integer.parseInt(args[1]);
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            EffectCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        for (PlayerData playerdata : data) {
            int statusEffectId = Integer.parseInt(args[2]);
            StatusEffectController.getInstance().applyEffect(playerdata.player, statusEffectId, time);
            EffectCommand.sendResult((ICommandSender)sender, (String)String.format("Effect %d given to %s", statusEffectId, playerdata.playername), (Object[])new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Removes a effect from a player", usage="<player> <effectId>")
    public void removeId(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            EffectCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        for (PlayerData playerData : data) {
            int statusEffectId = Integer.parseInt(args[1]);
            StatusEffectController.getInstance().removeEffect(playerData.player, statusEffectId);
            EffectCommand.sendResult((ICommandSender)sender, (String)String.format("Effect %d removed from %s", statusEffectId, playerData.playername), (Object[])new Object[0]);
        }
    }
}

