/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.command;

import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import kamkeel.command.CommandKamkeelBase;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.scripted.DBCAPI;
import kamkeel.npcdbc.util.PlayerDataUtil;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerData;

public class FormMasteryCommand
extends CommandKamkeelBase {
    public String getDescription() {
        return "Allows changing a player's form mastery for custom forms";
    }

    public String func_71517_b() {
        return "formmastery";
    }

    @CommandKamkeelBase.SubCommand(desc="Give a player form mastery by name", usage="<player> <amount> <form_name>")
    public void give(ICommandSender sender, String[] args) throws CommandException {
        float amount;
        String playername = args[0];
        String name = "";
        for (int i = 2; i < args.length; ++i) {
            name = name + args[i] + (i != args.length - 1 ? " " : "");
        }
        try {
            amount = Float.parseFloat(args[1]);
        }
        catch (NumberFormatException ex) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Mastery amount must be a float: " + args[1]), (Object[])new Object[0]);
            return;
        }
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Form form = (Form)DBCAPI.Instance().getForm(name);
        if (form == null) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Unknown form: " + name), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(playerdata);
            if (!info.hasForm(form)) {
                FormMasteryCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a7ePlayer '\u00a7b%s\u00a7e' doesn't have '\u00a7b%s\u00a77' unlocked.", playerdata.playername, form.getName()), (Object[])new Object[0]);
                return;
            }
            info.addFormLevel(form.id, amount);
            info.updateClient();
            FormMasteryCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a7b%s's\u00a7e mastery of \u00a77'%s'\u00a7e was adjusted by \u00a77%s \u00a7d(%s)", playerdata.playername, form.getName(), Float.valueOf(amount), Float.valueOf(info.getFormLevel(form.id))), (Object[])new Object[0]);
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Set a player form mastery by name", usage="<player> <amount> <form_name>")
    public void set(ICommandSender sender, String[] args) throws CommandException {
        float amount;
        String playername = args[0];
        String name = "";
        for (int i = 2; i < args.length; ++i) {
            name = name + args[i] + (i != args.length - 1 ? " " : "");
        }
        try {
            amount = Float.parseFloat(args[1]);
        }
        catch (NumberFormatException ex) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Mastery amount must be a float: " + args[1]), (Object[])new Object[0]);
            return;
        }
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Form form = (Form)DBCAPI.Instance().getForm(name);
        if (form == null) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Unknown form: " + name), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(playerdata);
            if (!info.hasForm(form)) {
                FormMasteryCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a7ePlayer '\u00a7b%s\u00a7e' doesn't have '\u00a7b%s\u00a77' unlocked.", playerdata.playername, form.getName()), (Object[])new Object[0]);
                return;
            }
            info.setFormLevel(form.id, amount);
            info.updateClient();
            FormMasteryCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a7b%s's\u00a7e mastery of \u00a77'%s'\u00a7e was set to \u00a7d%s", playerdata.playername, form.getName(), Float.valueOf(info.getFormLevel(form.id))), (Object[])new Object[0]);
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Give a player form mastery by numerical id", usage="<player> <amount> <form_ID>")
    public void giveid(ICommandSender sender, String[] args) throws CommandException {
        float amount;
        String playername = args[0];
        int id = Integer.parseInt(args[2]);
        try {
            amount = Float.parseFloat(args[1]);
        }
        catch (NumberFormatException ex) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Mastery amount must be a float: " + args[1]), (Object[])new Object[0]);
            return;
        }
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Form form = (Form)DBCAPI.Instance().getFormHandler().get(id);
        if (form == null) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Unknown form: " + id), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(playerdata);
            if (!info.hasForm(form)) {
                FormMasteryCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a7ePlayer '\u00a7b%s\u00a7e' doesn't have '\u00a7b%s\u00a77' unlocked.", playerdata.playername, form.getName()), (Object[])new Object[0]);
                return;
            }
            info.addFormLevel(form.id, amount);
            info.updateClient();
            FormMasteryCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a7b%s's\u00a7e mastery of \u00a77'%s'\u00a7e was adjusted by \u00a77%s \u00a7d(%s)", playerdata.playername, form.getName(), Float.valueOf(amount), Float.valueOf(info.getFormLevel(form.id))), (Object[])new Object[0]);
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Set a player form mastery by numerical id", usage="<player> <amount> <form_ID>")
    public void setid(ICommandSender sender, String[] args) throws CommandException {
        float amount;
        String playername = args[0];
        int id = Integer.parseInt(args[2]);
        try {
            amount = Float.parseFloat(args[1]);
        }
        catch (NumberFormatException ex) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Mastery amount must be a float: " + args[1]), (Object[])new Object[0]);
            return;
        }
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Form form = (Form)DBCAPI.Instance().getFormHandler().get(id);
        if (form == null) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Unknown form: " + id), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(playerdata);
            if (!info.hasForm(form)) {
                FormMasteryCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a7ePlayer '\u00a7b%s\u00a7e' doesn't have '\u00a7b%s\u00a77' unlocked.", playerdata.playername, form.getName()), (Object[])new Object[0]);
                return;
            }
            info.setFormLevel(form.id, amount);
            info.updateClient();
            FormMasteryCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a7b%s's\u00a7e mastery of \u00a77'%s'\u00a7e was set to \u00a7d%s", playerdata.playername, form.getName(), Float.valueOf(info.getFormLevel(form.id))), (Object[])new Object[0]);
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Get info about a players form mastery", usage="<player>")
    public void info(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            FormMasteryCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            PlayerDBCInfo info = PlayerDataUtil.getDBCInfo(playerdata);
            FormMasteryCommand.sendResult((ICommandSender)sender, (String)"--------------------", (Object[])new Object[0]);
            FormMasteryCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a7b%s's \u00a7emastery:", playerdata.playername), (Object[])new Object[0]);
            for (int id : info.unlockedForms) {
                Form form = info.getForm(id);
                if (form == null) continue;
                float formLevel = info.getFormLevel(form.id);
                float formMaxLevel = form.getMastery().getMaxLevel();
                String formatted = new DecimalFormat("#.##").format(formLevel / formMaxLevel * 100.0f);
                FormMasteryCommand.sendResult((ICommandSender)sender, (String)(String.format("\u00a77%s (ID: %d) \u00a7b%s/%s", form.getName(), form.id, Float.valueOf(formLevel), Float.valueOf(formMaxLevel)) + "%s"), (Object[])new Object[]{" \u00a7d(" + formatted + "%)"});
            }
            FormMasteryCommand.sendResult((ICommandSender)sender, (String)"--------------------", (Object[])new Object[0]);
            return;
        }
    }
}

