/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.command;

import java.util.Iterator;
import java.util.List;
import kamkeel.command.CommandKamkeelBase;
import kamkeel.npcdbc.controllers.OutlineController;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.outline.Outline;
import kamkeel.npcdbc.scripted.DBCAPI;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerData;

public class OutlineCommand
extends CommandKamkeelBase {
    public String func_71517_b() {
        return "outline";
    }

    public String getDescription() {
        return "Outline operations";
    }

    @CommandKamkeelBase.SubCommand(desc="Sets a player's active outline by name", usage="<player> <outline_name>")
    public void set(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        String name = "";
        for (int i = 1; i < args.length; ++i) {
            name = name + args[i] + (i != args.length - 1 ? " " : "");
        }
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            OutlineCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Outline outline = (Outline)DBCAPI.Instance().getOutline(name);
        if (outline == null) {
            OutlineCommand.sendError((ICommandSender)sender, (String)("Unknown outline: " + name), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            EntityPlayer player = playerdata.player;
            DBCData dbc = DBCData.get(player);
            if (dbc.outlineID != outline.id) {
                dbc.setOutline(outline);
                OutlineCommand.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7ais now active to \u00a77'\u00a7b%s\u00a77'", outline.getName(), playerdata.playername), (Object[])new Object[0]);
                if (sender != playerdata.player) {
                    OutlineCommand.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7Outline \u00a77%s \u00a7ais now active.", outline.getName()), (Object[])new Object[0]);
                }
            } else {
                OutlineCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a77'\u00a7b%s\u00a77' \u00a7ealready has \u00a77%s \u00a7eactive!", playerdata.playername, outline.getName()), (Object[])new Object[0]);
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Sets a player's active outline by numerical id", usage="<player> <outline_ID>")
    public void setid(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        int id = Integer.parseInt(args[1]);
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            OutlineCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Outline outline = (Outline)OutlineController.getInstance().get(id);
        if (outline == null) {
            OutlineCommand.sendError((ICommandSender)sender, (String)("Unknown outline ID: " + id), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            EntityPlayer player = playerdata.player;
            DBCData dbc = DBCData.get(player);
            if (dbc.outlineID != outline.id) {
                dbc.setOutline(outline);
                OutlineCommand.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7ais now active to \u00a77'\u00a7b%s\u00a77'", outline.getName(), playerdata.playername), (Object[])new Object[0]);
                if (sender != playerdata.player) {
                    OutlineCommand.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7Outline \u00a77%s \u00a7ais now active.", outline.getName()), (Object[])new Object[0]);
                }
            } else {
                OutlineCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a77'\u00a7b%s\u00a77' \u00a7ealready has \u00a77%s \u00a7eactive!", playerdata.playername, outline.getName()), (Object[])new Object[0]);
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Removes a player's active outline", usage="<player>")
    public void remove(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            OutlineCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        Iterator iterator = data.iterator();
        if (iterator.hasNext()) {
            PlayerData playerdata = (PlayerData)iterator.next();
            EntityPlayer player = playerdata.player;
            DBCData dbc = DBCData.get(player);
            if (dbc.outlineID != -1) {
                Outline outline = dbc.getOutline();
                dbc.setOutline(null);
                OutlineCommand.sendResult((ICommandSender)sender, (String)String.format("%s \u00a7cremoved from \u00a77'\u00a7b%s\u00a77'", outline.getName(), playerdata.playername), (Object[])new Object[0]);
                if (sender != playerdata.player) {
                    OutlineCommand.sendResult((ICommandSender)playerdata.player, (String)String.format("\u00a7cOutline \u00a77%s \u00a7cremoved.", outline.getName()), (Object[])new Object[0]);
                }
            } else {
                OutlineCommand.sendResult((ICommandSender)sender, (String)String.format("\u00a7eNo outline active for \u00a77'\u00a7b%s\u00a77'", playerdata.playername), (Object[])new Object[0]);
            }
            return;
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Lists player's active outline", usage="<player>")
    public void info(ICommandSender sender, String[] args) throws CommandException {
        String playername = args[0];
        List data = PlayerDataController.Instance.getPlayersData(sender, playername);
        if (data.isEmpty()) {
            OutlineCommand.sendError((ICommandSender)sender, (String)("Unknown player: " + playername), (Object[])new Object[0]);
            return;
        }
        for (PlayerData playerdata : data) {
            EntityPlayer player = playerdata.player;
            DBCData dbc = DBCData.get(player);
            if (dbc.outlineID == -1) {
                OutlineCommand.sendResult((ICommandSender)sender, (String)String.format("No Outline active for \u00a77'\u00a7b%s\u00a77'", playerdata.playername), (Object[])new Object[0]);
                continue;
            }
            Outline outline = (Outline)OutlineController.Instance.get(dbc.outlineID);
            OutlineCommand.sendResult((ICommandSender)sender, (String)"--------------------", (Object[])new Object[0]);
            OutlineCommand.sendResult((ICommandSender)sender, (String)String.format("%s", outline.getName()), (Object[])new Object[0]);
            OutlineCommand.sendResult((ICommandSender)sender, (String)"--------------------", (Object[])new Object[0]);
        }
    }

    @CommandKamkeelBase.SubCommand(desc="Lists all existing outlines")
    public void infoall(ICommandSender sender, String[] args) throws CommandException {
        OutlineCommand.sendResult((ICommandSender)sender, (String)"--------------------", (Object[])new Object[0]);
        for (Outline outline : OutlineController.getInstance().customOutlines.values()) {
            OutlineCommand.sendResult((ICommandSender)sender, (String)String.format("%s", outline.getName()), (Object[])new Object[0]);
        }
        OutlineCommand.sendResult((ICommandSender)sender, (String)"--------------------", (Object[])new Object[0]);
    }

    @CommandKamkeelBase.SubCommand(desc="Reloads all outlines")
    public void reload(ICommandSender sender, String[] args) {
        OutlineController.Instance.load();
        OutlineCommand.sendResult((ICommandSender)sender, (String)"Outlines reloaded!", (Object[])new Object[0]);
    }
}

