/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.config;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import noppes.npcs.util.ValueUtil;
import org.apache.logging.log4j.Level;

public class ConfigDBCGameplay {
    public static Configuration config;
    public static final String StatusEffects = "Status_Effects";
    public static double CheckEffectsTick;
    public static final String Forms = "Forms";
    public static boolean InstantTransform;
    public static final String ChargingDex = "Charging_Dex";
    public static boolean EnableChargingDex;
    public static int MartialArtistCharge;
    public static int SpiritualistCharge;
    public static int WarriorCharge;
    public static final String NamekianRegeneration = "Namek_Regen";
    public static boolean EnableNamekianRegen;
    public static int NamekianRegenMin;
    public static int NamekianRegenMax;
    public static final String PotaraFusion = "Potara_Fusion";
    public static boolean UniqueEarrings;
    public static boolean WearableEarrings;
    public static int PotaraOneTime;
    public static int PotaraTwoTime;
    public static int PotaraThreeTime;
    public static final String Zenkai = "Zenkai";
    public static boolean SaiyanZenkai;
    public static boolean HalfSaiyanZenkai;
    public static final String KiCharge = "Ki_Charge";
    public static boolean RevampKiCharging;
    public static boolean KiPotentialUnlock;
    public static int KiChargeRate;

    public static void init(File configFile) {
        config = new Configuration(configFile);
        try {
            config.load();
            CheckEffectsTick = config.get(StatusEffects, "Run Effects Every X Tick", 10, "This will check effects every X ticks. All registered effects must be multiple of 10. [10, 20, 30...] Max: 100").getInt(10);
            CheckEffectsTick = CheckEffectsTick % 10.0 == 0.0 ? CheckEffectsTick : (CheckEffectsTick / 10.0 + 1.0) * 10.0;
            CheckEffectsTick = ValueUtil.clamp((double)CheckEffectsTick, (double)10.0, (double)100.0);
            EnableChargingDex = config.get(ChargingDex, "0. Enable Charging Dex", true, "Charging Dex -> Percent of Total Defense Activated while Charging Ki Attacks. \nActive Defense [Blocking], Passive [Not Blocking](Takes Percent of Active in JRMCore Configs.) \nCharging Defense [Charging Ki Attack](Percent of Active)[0 - 100]").getBoolean(true);
            MartialArtistCharge = config.get(ChargingDex, "1. Martial Artist Percent", 60).getInt(60);
            SpiritualistCharge = config.get(ChargingDex, "2. Spiritualist Percent", 60).getInt(60);
            WarriorCharge = config.get(ChargingDex, "3. Warrior Percent", 60).getInt(60);
            MartialArtistCharge = ValueUtil.clamp((int)MartialArtistCharge, (int)0, (int)100);
            SpiritualistCharge = ValueUtil.clamp((int)SpiritualistCharge, (int)0, (int)100);
            WarriorCharge = ValueUtil.clamp((int)WarriorCharge, (int)0, (int)100);
            EnableNamekianRegen = config.get(NamekianRegeneration, "Enable Namekian Regeneration", true, "Namekian Regeneration will automatically apply the Namek Regen Effect (dbc/effects.cfg), \nwhen the Player falls below MIN Health and will stop continue to MAX Health.").getBoolean(true);
            NamekianRegenMin = config.get(NamekianRegeneration, "Min Namekian Regen", 20).getInt(20);
            NamekianRegenMax = config.get(NamekianRegeneration, "Max Namekian Regen", 50).getInt(50);
            SaiyanZenkai = config.get(Zenkai, "Enable Saiyan Zenkai", true, "Enables Zenkai for Saiyans after Revive").getBoolean(true);
            HalfSaiyanZenkai = config.get(Zenkai, "Enable Half Saiyan Zenkai", true, "Enables Zenkai for Half Saiyans after Revive").getBoolean(true);
            InstantTransform = config.get(Forms, "Instant Transform Bypass Parent", false, "Allows Instant Transform to Bypass the Parent Only Check\n[If the player has Instant Transform Unlocked in Mastery, they can go to the form directly]").getBoolean(false);
            config.setCategoryComment(PotaraFusion, "Potara Fusion comes with a Bonus Multi applied by the Potara Status Effect. This can be modified within the DBC Addon Effect Config");
            config.setCategoryPropertyOrder(PotaraFusion, new ArrayList<String>(Arrays.asList("Unique Earrings", "Wearable Earrings", "Tier 1 Time", "Tier 2 Time", "Tier 3 Time")));
            UniqueEarrings = config.get(PotaraFusion, "Unique Earrings", true, "Enabling Unique Earrings will cause all SPLIT Potaras to be hashed to a\n unique pair. Only the unique pairs can be used in a fusion.").getBoolean(true);
            WearableEarrings = config.get(PotaraFusion, "Wearable Earrings", true, "Enabling Wearable Earrings will check a radius around the worn player.\n Disabling this will require players to right-click each-other with valid earrings to fuse.").getBoolean(true);
            PotaraOneTime = config.get(PotaraFusion, "Tier 1 Time", 10, "The amount of time the Tier One Potara Earrings Fusion lasts. [In Minutes]").getInt(10);
            PotaraTwoTime = config.get(PotaraFusion, "Tier 2 Time", 15, "The amount of time the Tier Two Potara Earrings Fusion lasts. [In Minutes]").getInt(15);
            PotaraThreeTime = config.get(PotaraFusion, "Tier 3 Time", 25, "The amount of time the Tier Three Potara Earrings Fusion lasts. [In Minutes]").getInt(25);
            PotaraOneTime = Math.max(1, PotaraOneTime);
            PotaraTwoTime = Math.max(1, PotaraTwoTime);
            PotaraThreeTime = Math.max(1, PotaraThreeTime);
            config.setCategoryComment(KiCharge, "Ki Charge Revamp allows many modifications to the normal vanilla DBC Ki Charge to be configured.\nIf the Revamp Ki Charge is disabled then the Status Effect Overpower will not function.\nThis functionality does not control Energy Attack Charging speeds. Ki Revamp will also allow\nHumans and Namekians to power down with the FN Key, as opposed to vanilla DBC.");
            RevampKiCharging = config.get(KiCharge, "0. Enable Ki Revamp", true, "Enabling this feature will allow huge modifications to Ki Charging as featured below.").getBoolean(true);
            KiPotentialUnlock = config.get(KiCharge, "Ki Charge Speed with Potential Unlock Level", true, "Enabling this feature will make Ki Charging faster for players with a higher Release Level.\nEach level: [1: 15ticks, 2: 14, 3: 13.... 10: 5 Ticks").getBoolean(true);
            KiChargeRate = config.get(KiCharge, "Ki Charge Rate", 1, "Tweaking this number will allow for more precise ki charging. Default for DBC is 5.").getInt(1);
            KiChargeRate = ValueUtil.clamp((int)KiChargeRate, (int)1, (int)50);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"DBC Addon has had a problem loading its gameplay configuration", (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    static {
        CheckEffectsTick = 10.0;
        InstantTransform = true;
        EnableChargingDex = true;
        MartialArtistCharge = 60;
        SpiritualistCharge = 60;
        WarriorCharge = 60;
        EnableNamekianRegen = true;
        NamekianRegenMin = 20;
        NamekianRegenMax = 50;
        UniqueEarrings = true;
        WearableEarrings = true;
        PotaraOneTime = 10;
        PotaraTwoTime = 15;
        PotaraThreeTime = 25;
        SaiyanZenkai = true;
        HalfSaiyanZenkai = true;
        RevampKiCharging = true;
        KiPotentialUnlock = true;
        KiChargeRate = 1;
    }
}

