/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.controllers;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import kamkeel.npcdbc.api.form.IForm;
import kamkeel.npcdbc.api.form.IFormHandler;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.network.PacketHandler;
import kamkeel.npcdbc.network.packets.DBCInfoSync;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.util.NBTJsonUtil;

public class FormController
implements IFormHandler {
    public static FormController Instance = new FormController();
    public HashMap<Integer, Form> customFormsSync = new HashMap();
    public HashMap<Integer, Form> customForms;
    private HashMap<Integer, String> bootOrder;
    private int lastUsedID = 0;

    public FormController() {
        Instance = this;
        this.customForms = new HashMap();
        this.bootOrder = new HashMap();
    }

    public void load() {
        this.customForms = new HashMap();
        this.bootOrder = new HashMap();
        LogWriter.info((Object)"Loading custom forms...");
        this.readCustomFormMap();
        this.loadForms();
        LogWriter.info((Object)"Done loading custom forms.");
    }

    public IForm createForm(String name) {
        if (this.hasName(name)) {
            return this.get(name);
        }
        Form form = new Form();
        form.name = name;
        if (form.id == -1) {
            form.id = this.getUnusedId();
        }
        int setID = form.id;
        while (!(!this.bootOrder.containsKey(setID) && !this.customForms.containsKey(setID) || this.bootOrder.containsKey(setID) && this.bootOrder.get(setID).equals(form.name))) {
            ++setID;
        }
        this.customForms.put(form.id, form);
        form.save();
        return form;
    }

    private void loadForms() {
        this.customForms.clear();
        File dir = this.getDir();
        if (!dir.exists()) {
            dir.mkdir();
        } else {
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                try {
                    Form form = new Form();
                    form.readFromNBT(NBTJsonUtil.LoadFile((File)file));
                    form.name = file.getName().substring(0, file.getName().length() - 5);
                    if (form.id == -1) {
                        form.id = this.getUnusedId();
                    }
                    int originalID = form.id;
                    int setID = form.id;
                    while (!(!this.bootOrder.containsKey(setID) && !this.customForms.containsKey(setID) || this.bootOrder.containsKey(setID) && this.bootOrder.get(setID).equals(form.name))) {
                        ++setID;
                    }
                    form.id = setID;
                    if (originalID != setID) {
                        LogWriter.info((Object)("Found Custom Form ID Mismatch: " + form.name + ", New ID: " + setID));
                        form.save();
                    }
                    this.customForms.put(form.id, form);
                }
                catch (Exception e) {
                    LogWriter.error((Object)("Error loading: " + file.getAbsolutePath()), (Exception)e);
                }
            }
        }
        this.verifyLinkedForms();
        this.saveFormLoadMap();
    }

    private void verifyLinkedForms() {
        for (Form form : this.customForms.values()) {
            if (!this.has(form.childID)) {
                form.childID = -1;
            }
            if (this.has(form.parentID)) continue;
            form.parentID = -1;
        }
    }

    private File getDir() {
        return new File(CustomNpcs.getWorldSaveDirectory(), "customforms");
    }

    public int getUnusedId() {
        for (int catid : this.customForms.keySet()) {
            if (catid <= this.lastUsedID) continue;
            this.lastUsedID = catid;
        }
        ++this.lastUsedID;
        return this.lastUsedID;
    }

    @Override
    public IForm saveForm(IForm customForm) {
        if (customForm.getID() < 0) {
            customForm.setID(this.getUnusedId());
            while (this.hasName(customForm.getName())) {
                customForm.setName(customForm.getName() + "_");
            }
        } else {
            Form existing = this.customForms.get(customForm.getID());
            if (existing != null && !existing.name.equals(customForm.getName())) {
                while (this.hasName(customForm.getName())) {
                    customForm.setName(customForm.getName() + "_");
                }
            }
        }
        this.customForms.remove(customForm.getID());
        this.customForms.put(customForm.getID(), (Form)customForm);
        this.saveFormLoadMap();
        File dir = this.getDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, customForm.getName() + ".json_new");
        File file2 = new File(dir, customForm.getName() + ".json");
        try {
            NBTTagCompound nbtTagCompound = ((Form)customForm).writeToNBT();
            NBTJsonUtil.SaveFile((File)file, (NBTTagCompound)nbtTagCompound);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            PacketHandler.Instance.sendToAll(new DBCInfoSync(1, EnumPacketClient.SYNC_UPDATE, nbtTagCompound, -1).generatePacket());
        }
        catch (Exception e) {
            LogWriter.except((Exception)e);
        }
        return this.customForms.get(customForm.getID());
    }

    public boolean hasName(String newName) {
        if (newName.trim().isEmpty()) {
            return true;
        }
        for (Form form : this.customForms.values()) {
            if (!form.name.equals(newName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void delete(String name) {
        Form foundForm;
        Form delete = this.getFormFromName(name);
        if (delete != null && (foundForm = this.customForms.remove(delete.getID())) != null && foundForm.name != null) {
            File dir = this.getDir();
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json") || !file.getName().equals(foundForm.name + ".json")) continue;
                file.delete();
                PacketHandler.Instance.sendToAll(new DBCInfoSync(1, EnumPacketClient.SYNC_REMOVE, new NBTTagCompound(), foundForm.getID()).generatePacket());
                break;
            }
            this.saveFormLoadMap();
        }
    }

    @Override
    public void delete(int id) {
        if (!this.customForms.containsKey(id)) {
            return;
        }
        Form foundForm = this.customForms.remove(id);
        if (foundForm != null && foundForm.name != null) {
            File dir = this.getDir();
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json") || !file.getName().equals(foundForm.name + ".json")) continue;
                file.delete();
                PacketHandler.Instance.sendToAll(new DBCInfoSync(1, EnumPacketClient.SYNC_REMOVE, new NBTTagCompound(), foundForm.getID()).generatePacket());
                break;
            }
            this.saveFormLoadMap();
        }
    }

    @Override
    public boolean has(String name) {
        return this.getFormFromName(name) != null;
    }

    public boolean has(int id) {
        return this.get(id) != null;
    }

    @Override
    public IForm get(String name) {
        return this.getFormFromName(name);
    }

    @Override
    public IForm get(int id) {
        if (id == -1) {
            return null;
        }
        return this.customForms.get(id);
    }

    @Override
    public IForm[] getForms() {
        ArrayList<Form> customForms = new ArrayList<Form>(this.customForms.values());
        return customForms.toArray(new IForm[0]);
    }

    public Form getFormFromName(String formName) {
        for (Map.Entry<Integer, Form> entryForm : FormController.getInstance().customForms.entrySet()) {
            if (!entryForm.getValue().name.equalsIgnoreCase(formName)) continue;
            return entryForm.getValue();
        }
        return null;
    }

    public String[] getNames() {
        String[] names = new String[this.customForms.size()];
        int i = 0;
        for (Form customForm : this.customForms.values()) {
            names[i] = customForm.name.toLowerCase();
            ++i;
        }
        return names;
    }

    public File getMapDir() {
        File dir = CustomNpcs.getWorldSaveDirectory();
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    public void readCustomFormMap() {
        this.bootOrder.clear();
        try {
            File file = new File(this.getMapDir(), "customforms.dat");
            if (file.exists()) {
                this.loadCustomFormMap(file);
            }
        }
        catch (Exception e) {
            try {
                File file = new File(this.getMapDir(), "customforms.dat_old");
                if (file.exists()) {
                    this.loadCustomFormMap(file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public NBTTagCompound writeMapNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList formList = new NBTTagList();
        for (Integer key : this.customForms.keySet()) {
            Form customForm = this.customForms.get(key);
            if (customForm.getName().isEmpty()) continue;
            NBTTagCompound formCompound = new NBTTagCompound();
            formCompound.func_74778_a("Name", customForm.getName());
            formCompound.func_74768_a("ID", key.intValue());
            formList.func_74742_a((NBTBase)formCompound);
        }
        nbt.func_74782_a("CustomForms", (NBTBase)formList);
        nbt.func_74768_a("lastID", this.lastUsedID);
        return nbt;
    }

    public void readMapNBT(NBTTagCompound compound) {
        this.lastUsedID = compound.func_74762_e("lastID");
        NBTTagList list = compound.func_150295_c("CustomForms", 10);
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = list.func_150305_b(i);
                String formName = nbttagcompound.func_74779_i("Name");
                Integer key = nbttagcompound.func_74762_e("ID");
                this.bootOrder.put(key, formName);
            }
        }
    }

    private void loadCustomFormMap(File file) throws IOException {
        DataInputStream var1 = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        this.readCustomFormMap(var1);
        var1.close();
    }

    public void readCustomFormMap(DataInputStream stream) throws IOException {
        NBTTagCompound nbtCompound = CompressedStreamTools.func_74794_a((DataInputStream)stream);
        this.readMapNBT(nbtCompound);
    }

    public void saveFormLoadMap() {
        try {
            File saveDir = this.getMapDir();
            File file = new File(saveDir, "customforms.dat_new");
            File file1 = new File(saveDir, "customforms.dat_old");
            File file2 = new File(saveDir, "customforms.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeMapNBT(), (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.except((Exception)e);
        }
    }

    public static FormController getInstance() {
        return Instance;
    }
}

