/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.controllers;

import JinRyuu.JRMCore.JRMCoreH;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kamkeel.npcdbc.constants.enums.EnumPotaraTypes;
import kamkeel.npcdbc.controllers.StatusEffectController;
import kamkeel.npcdbc.data.FuseRequest;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.items.ItemPotara;
import kamkeel.npcdbc.network.NetworkUtility;
import kamkeel.npcdbc.util.Utility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class FusionHandler {
    public static HashMap<UUID, FuseRequest> fuseRequest = new HashMap();

    public static boolean requestFusion(EntityPlayer sender, EntityPlayer target, boolean rightSide, String hash, int tier) {
        boolean senderFusion = JRMCoreH.PlyrSettingsB((EntityPlayer)sender, (int)4);
        boolean targetFusion = JRMCoreH.PlyrSettingsB((EntityPlayer)target, (int)4);
        if (!senderFusion) {
            NetworkUtility.sendServerMessage(sender, "\u00a7c", sender.func_70005_c_(), " ", "npcdbc.fusionSkillFusion");
            return false;
        }
        if (!targetFusion) {
            NetworkUtility.sendServerMessage(sender, "\u00a7c", target.func_70005_c_(), " ", "npcdbc.fusionSkillFusion");
            return false;
        }
        if (FusionHandler.hasNoFuse(sender)) {
            NetworkUtility.sendServerMessage(sender, "\u00a7c", sender.func_70005_c_(), " ", "npcdbc.noFuse");
            return false;
        }
        if (FusionHandler.hasNoFuse(target)) {
            NetworkUtility.sendServerMessage(sender, "\u00a7c", target.func_70005_c_(), " ", "npcdbc.noFuse");
            return false;
        }
        UUID uuidSender = Utility.getUUID((Entity)sender);
        UUID uuidTarget = Utility.getUUID((Entity)target);
        FuseRequest senderRequest = new FuseRequest(sender.func_70005_c_(), target.func_70005_c_(), rightSide, hash, tier);
        FuseRequest targetRequest = null;
        if (fuseRequest.containsKey(uuidTarget) && senderRequest.checkRequest(targetRequest = fuseRequest.get(uuidTarget))) {
            String targetHash;
            if (sender.func_70694_bm() == null || !(sender.func_70694_bm().func_77973_b() instanceof ItemPotara)) {
                NetworkUtility.sendServerMessage(sender, "\u00a7c", "npcdbc.holdPotara");
                return false;
            }
            if (target.func_70694_bm() == null || !(target.func_70694_bm().func_77973_b() instanceof ItemPotara)) {
                NetworkUtility.sendServerMessage(sender, "\u00a7c", "npcdbc.holdPotara");
                return false;
            }
            ItemStack sendPotara = sender.func_70694_bm();
            ItemStack targetPotara = target.func_70694_bm();
            if (sendPotara.func_77960_j() != targetPotara.func_77960_j()) {
                NetworkUtility.sendServerMessage(sender, "\u00a7c", "npcdbc.potaraTier");
                return false;
            }
            NBTTagCompound sendNBT = sendPotara.func_77978_p();
            NBTTagCompound targetNBT = targetPotara.func_77978_p();
            if (sendNBT == null || targetNBT == null) {
                NetworkUtility.sendServerMessage(sender, "\u00a7c", "npcdbc.potaraSpit");
                return false;
            }
            if (!sendNBT.func_74764_b("Side") || !targetNBT.func_74764_b("Side")) {
                NetworkUtility.sendServerMessage(sender, "\u00a7c", "npcdbc.potaraSpit");
                return false;
            }
            if (sendNBT.func_74779_i("Side").equals(targetNBT.func_74779_i("Side"))) {
                NetworkUtility.sendServerMessage(sender, "\u00a7c", "npcdbc.potaraSides");
                return false;
            }
            String sendHash = sendNBT.func_74764_b("Hash") ? sendNBT.func_74779_i("Hash") : "";
            String string = targetHash = sendNBT.func_74764_b("Hash") ? sendNBT.func_74779_i("Hash") : "";
            if (!sendHash.equals(targetHash)) {
                NetworkUtility.sendServerMessage(sender, "\u00a7c", "npcdbc.potaraHash");
                return false;
            }
            fuseRequest.remove(uuidSender);
            fuseRequest.remove(uuidTarget);
            sendPotara.func_77979_a(1);
            targetPotara.func_77979_a(1);
            if (sendPotara.field_77994_a <= 0) {
                sender.func_71028_bD();
            }
            if (targetPotara.field_77994_a <= 0) {
                target.func_71028_bD();
            }
            NetworkUtility.sendServerMessage(sender, "\u00a7a", "npcdbc.potaraFusion", " \u00a7e", target.func_70005_c_());
            NetworkUtility.sendServerMessage(target, "\u00a7a", "npcdbc.potaraFusion", " \u00a7e", sender.func_70005_c_());
            EnumPotaraTypes potaraType = EnumPotaraTypes.getPotaraFromMeta(tier);
            StatusEffectController.getInstance().applyEffect(sender, 12, potaraType.getLength() * 60, (byte)potaraType.getMeta());
            StatusEffectController.getInstance().applyEffect(target, 12, potaraType.getLength() * 60, (byte)potaraType.getMeta());
            DBCData.fusePlayers(target, sender, (float)potaraType.getLength());
            return true;
        }
        FuseRequest existing = null;
        if (fuseRequest.containsKey(uuidSender)) {
            existing = fuseRequest.get(uuidSender);
        }
        if (existing == null || senderRequest.newRequest(existing)) {
            NetworkUtility.sendServerMessage(target, "\u00a7e", "npcdbc.potaraRequest", " \u00a7a", sender.func_70005_c_());
            fuseRequest.put(uuidSender, senderRequest);
        }
        return false;
    }

    public static void checkNearbyPlayers(EntityPlayer player) {
        ItemStack potara = player.func_82169_q(3);
        if (potara == null) {
            return;
        }
        if (!(potara.func_77973_b() instanceof ItemPotara)) {
            return;
        }
        if (!ItemPotara.isSplit(potara)) {
            return;
        }
        if (!JRMCoreH.PlyrSettingsB((EntityPlayer)player, (int)4)) {
            return;
        }
        if (FusionHandler.hasNoFuse(player)) {
            JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)4);
            NetworkUtility.sendServerMessage(player, "\u00a7c", player.func_70005_c_(), " ", "npcdbc.noFuse");
            NetworkUtility.sendServerMessage(player, "\u00a7e", "npcdbc.disableFuse");
            return;
        }
        int tier = potara.func_77960_j();
        String hash = ItemPotara.getHash(potara);
        boolean isRight = ItemPotara.isRightSide(potara);
        double range = 8.0;
        List nearbyPlayers = player.field_70170_p.func_72872_a(EntityPlayer.class, player.field_70121_D.func_72314_b(range, range, range));
        for (EntityPlayer nearbyPlayer : nearbyPlayers) {
            if (nearbyPlayer == player || !FusionHandler.doesPlayerHaveEarring(nearbyPlayer, tier, !isRight, hash)) continue;
            if (nearbyPlayer.func_70093_af()) {
                NetworkUtility.sendServerMessage(nearbyPlayer, "\u00a7a", "npcdbc.potaraFusion", " \u00a7e", player.func_70005_c_());
                NetworkUtility.sendServerMessage(player, "\u00a7a", "npcdbc.potaraFusion", " \u00a7e", nearbyPlayer.func_70005_c_());
                EnumPotaraTypes potaraType = EnumPotaraTypes.getPotaraFromMeta(tier);
                StatusEffectController.getInstance().applyEffect(player, 12, potaraType.getLength() * 60, (byte)potaraType.getMeta());
                StatusEffectController.getInstance().applyEffect(nearbyPlayer, 12, potaraType.getLength() * 60, (byte)potaraType.getMeta());
                FusionHandler.destroyPlayerEarring(nearbyPlayer);
                FusionHandler.destroyPlayerEarring(player);
                DBCData.fusePlayers(player, nearbyPlayer, (float)potaraType.getLength());
            } else {
                NetworkUtility.sendServerMessage(player, "\u00a7a", "npcdbc.fusionFound");
            }
            return;
        }
    }

    private static boolean hasNoFuse(EntityPlayer player) {
        DBCData data = DBCData.get(player);
        String fusionString = data.getRawCompound().func_74779_i("jrmcFuzion");
        if (fusionString == null) {
            return false;
        }
        if ((fusionString = fusionString.replace(" ", "")).isEmpty() || fusionString.contains(",")) {
            return false;
        }
        try {
            return Integer.parseInt(fusionString) > 0;
        }
        catch (Exception ignored) {
            return true;
        }
    }

    private static boolean doesPlayerHaveEarring(EntityPlayer player, int tier, boolean isRight, String hashToCheck) {
        ItemStack potara = player.func_82169_q(3);
        if (potara == null) {
            return false;
        }
        if (!(potara.func_77973_b() instanceof ItemPotara)) {
            return false;
        }
        if (!ItemPotara.isSplit(potara)) {
            return false;
        }
        if (!JRMCoreH.PlyrSettingsB((EntityPlayer)player, (int)4)) {
            return false;
        }
        int wornTier = potara.func_77960_j();
        String wornHash = ItemPotara.getHash(potara);
        boolean wearingRight = ItemPotara.isRightSide(potara);
        return tier == wornTier && wornHash.equals(hashToCheck) && wearingRight == isRight;
    }

    private static void destroyPlayerEarring(EntityPlayer player) {
        ItemStack potara = player.func_82169_q(3);
        if (potara == null) {
            return;
        }
        if (!(potara.func_77973_b() instanceof ItemPotara)) {
            return;
        }
        player.field_71071_by.field_70460_b[3] = null;
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            playerMP.field_71069_bz.func_75142_b();
        }
    }
}

