/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.controllers;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import kamkeel.npcdbc.api.outline.IOutline;
import kamkeel.npcdbc.api.outline.IOutlineHandler;
import kamkeel.npcdbc.data.outline.Outline;
import kamkeel.npcdbc.network.PacketHandler;
import kamkeel.npcdbc.network.packets.DBCInfoSync;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.util.NBTJsonUtil;

public class OutlineController
implements IOutlineHandler {
    public static OutlineController Instance = new OutlineController();
    public HashMap<Integer, Outline> customOutlinesSync = new HashMap();
    public HashMap<Integer, Outline> customOutlines;
    private HashMap<Integer, String> bootOrder;
    private int lastUsedID = 0;

    public OutlineController() {
        Instance = this;
        this.customOutlines = new HashMap();
        this.bootOrder = new HashMap();
    }

    public void load() {
        this.customOutlines = new HashMap();
        this.bootOrder = new HashMap();
        LogWriter.info((Object)"Loading custom outlines...");
        this.readCustomOutlineMap();
        this.loadOutlines();
        LogWriter.info((Object)"Done loading custom outlines.");
    }

    @Override
    public IOutline createOutline(String name) {
        if (this.hasName(name)) {
            return this.get(name);
        }
        Outline outline = new Outline();
        outline.name = name;
        if (outline.id == -1) {
            outline.id = this.getUnusedId();
        }
        int setID = outline.id;
        while (!(!this.bootOrder.containsKey(setID) && !this.customOutlines.containsKey(setID) || this.bootOrder.containsKey(setID) && this.bootOrder.get(setID).equals(outline.name))) {
            ++setID;
        }
        this.customOutlines.put(outline.id, outline);
        outline.save();
        return outline;
    }

    @Override
    public IOutline saveOutline(IOutline customOutline) {
        if (customOutline.getID() < 0) {
            customOutline.setID(this.getUnusedId());
            while (this.hasName(customOutline.getName())) {
                customOutline.setName(customOutline.getName() + "_");
            }
        } else {
            Outline existing = this.customOutlines.get(customOutline.getID());
            if (existing != null && !existing.name.equals(customOutline.getName())) {
                while (this.hasName(customOutline.getName())) {
                    customOutline.setName(customOutline.getName() + "_");
                }
            }
        }
        this.customOutlines.remove(customOutline.getID());
        this.customOutlines.put(customOutline.getID(), (Outline)customOutline);
        this.saveOutlineLoadMap();
        File dir = this.getDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, customOutline.getName() + ".json_new");
        File file2 = new File(dir, customOutline.getName() + ".json");
        try {
            NBTTagCompound nbtTagCompound = ((Outline)customOutline).writeToNBT();
            NBTJsonUtil.SaveFile((File)file, (NBTTagCompound)nbtTagCompound);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            PacketHandler.Instance.sendToAll(new DBCInfoSync(3, EnumPacketClient.SYNC_UPDATE, nbtTagCompound, -1).generatePacket());
        }
        catch (Exception e) {
            LogWriter.except((Exception)e);
        }
        return this.customOutlines.get(customOutline.getID());
    }

    @Override
    public void deleteOutlineFile(String name) {
        File file2;
        File dir = this.getDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((file2 = new File(dir, name + ".json")).exists()) {
            file2.delete();
        }
    }

    private void loadOutlines() {
        this.customOutlines.clear();
        File dir = this.getDir();
        if (!dir.exists()) {
            dir.mkdir();
        } else {
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                try {
                    Outline outline = new Outline();
                    outline.readFromNBT(NBTJsonUtil.LoadFile((File)file));
                    outline.name = file.getName().substring(0, file.getName().length() - 5);
                    if (outline.id == -1) {
                        outline.id = this.getUnusedId();
                    }
                    int originalID = outline.id;
                    int setID = outline.id;
                    while (!(!this.bootOrder.containsKey(setID) && !this.customOutlines.containsKey(setID) || this.bootOrder.containsKey(setID) && this.bootOrder.get(setID).equals(outline.name))) {
                        ++setID;
                    }
                    outline.id = setID;
                    if (originalID != setID) {
                        LogWriter.info((Object)("Found Custom Outline ID Mismatch: " + outline.name + ", New ID: " + setID));
                        outline.save();
                    }
                    this.customOutlines.put(outline.id, outline);
                }
                catch (Exception e) {
                    LogWriter.error((Object)("Error loading: " + file.getAbsolutePath()), (Exception)e);
                }
            }
        }
        this.saveOutlineLoadMap();
    }

    @Override
    public boolean hasName(String newName) {
        if (newName.trim().isEmpty()) {
            return true;
        }
        for (Outline outline : this.customOutlines.values()) {
            if (!outline.name.equals(newName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IOutline get(String name) {
        return this.getOutlineFromName(name);
    }

    @Override
    public IOutline get(int id) {
        return this.customOutlines.get(id);
    }

    @Override
    public boolean has(String name) {
        return this.getOutlineFromName(name) != null;
    }

    @Override
    public boolean has(int id) {
        return this.get(id) != null;
    }

    @Override
    public void delete(int id) {
        if (!this.customOutlines.containsKey(id)) {
            return;
        }
        Outline foundOutline = this.customOutlines.remove(id);
        if (foundOutline != null && foundOutline.name != null) {
            File dir = this.getDir();
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json") || !file.getName().equals(foundOutline.name + ".json")) continue;
                file.delete();
                PacketHandler.Instance.sendToAll(new DBCInfoSync(3, EnumPacketClient.SYNC_REMOVE, new NBTTagCompound(), foundOutline.getID()).generatePacket());
                break;
            }
            this.saveOutlineLoadMap();
        }
    }

    @Override
    public void delete(String name) {
        Outline foundOutline;
        Outline delete = (Outline)this.getOutlineFromName(name);
        if (delete != null && (foundOutline = this.customOutlines.remove(delete.getID())) != null && foundOutline.name != null) {
            File dir = this.getDir();
            for (File file : dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".json") || !file.getName().equals(foundOutline.name + ".json")) continue;
                file.delete();
                PacketHandler.Instance.sendToAll(new DBCInfoSync(3, EnumPacketClient.SYNC_REMOVE, new NBTTagCompound(), foundOutline.getID()).generatePacket());
                break;
            }
            this.saveOutlineLoadMap();
        }
    }

    private File getDir() {
        return new File(CustomNpcs.getWorldSaveDirectory(), "customoutlines");
    }

    public int getUnusedId() {
        for (int catid : this.customOutlines.keySet()) {
            if (catid <= this.lastUsedID) continue;
            this.lastUsedID = catid;
        }
        ++this.lastUsedID;
        return this.lastUsedID;
    }

    @Override
    public String[] getNames() {
        String[] names = new String[this.customOutlines.size()];
        int i = 0;
        for (Outline outline : this.customOutlines.values()) {
            names[i] = outline.name.toLowerCase();
            ++i;
        }
        return names;
    }

    @Override
    public IOutline[] getOutlines() {
        ArrayList<Outline> outlines = new ArrayList<Outline>(this.customOutlines.values());
        return outlines.toArray(new IOutline[0]);
    }

    @Override
    public IOutline getOutlineFromName(String outlineName) {
        for (Map.Entry<Integer, Outline> entryOutline : this.customOutlines.entrySet()) {
            if (!entryOutline.getValue().name.equalsIgnoreCase(outlineName)) continue;
            return entryOutline.getValue();
        }
        return null;
    }

    public File getMapDir() {
        File dir = CustomNpcs.getWorldSaveDirectory();
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir;
    }

    public void readCustomOutlineMap() {
        this.bootOrder.clear();
        try {
            File file = new File(this.getMapDir(), "customoutlines.dat");
            if (file.exists()) {
                this.loadCustomOutlineMap(file);
            }
        }
        catch (Exception e) {
            try {
                File file = new File(this.getMapDir(), "customoutlines.dat_old");
                if (file.exists()) {
                    this.loadCustomOutlineMap(file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readCustomOutlineMap(DataInputStream stream) throws IOException {
        NBTTagCompound nbtCompound = CompressedStreamTools.func_74794_a((DataInputStream)stream);
        this.readMapNBT(nbtCompound);
    }

    private void loadCustomOutlineMap(File file) throws IOException {
        DataInputStream var1 = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        this.readCustomOutlineMap(var1);
        var1.close();
    }

    public void readMapNBT(NBTTagCompound compound) {
        this.lastUsedID = compound.func_74762_e("lastID");
        NBTTagList list = compound.func_150295_c("CustomOutlines", 10);
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = list.func_150305_b(i);
                String outlineName = nbttagcompound.func_74779_i("Name");
                Integer key = nbttagcompound.func_74762_e("ID");
                this.bootOrder.put(key, outlineName);
            }
        }
    }

    public NBTTagCompound writeMapNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList outlineList = new NBTTagList();
        for (Integer key : this.customOutlines.keySet()) {
            Outline outline = this.customOutlines.get(key);
            if (outline.getName().isEmpty()) continue;
            NBTTagCompound outlineCompound = new NBTTagCompound();
            outlineCompound.func_74778_a("Name", outline.getName());
            outlineCompound.func_74768_a("ID", key.intValue());
            outlineList.func_74742_a((NBTBase)outlineCompound);
        }
        nbt.func_74782_a("CustomOutlines", (NBTBase)outlineList);
        nbt.func_74768_a("lastID", this.lastUsedID);
        return nbt;
    }

    public void saveOutlineLoadMap() {
        try {
            File saveDir = this.getMapDir();
            File file = new File(saveDir, "customoutlines.dat_new");
            File file1 = new File(saveDir, "customoutlines.dat_old");
            File file2 = new File(saveDir, "customoutlines.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeMapNBT(), (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LogWriter.except((Exception)e);
        }
    }

    public static OutlineController getInstance() {
        return Instance;
    }
}

