/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.controllers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kamkeel.npcdbc.api.effect.IStatusEffectHandler;
import kamkeel.npcdbc.data.statuseffect.CustomEffect;
import kamkeel.npcdbc.data.statuseffect.PlayerEffect;
import kamkeel.npcdbc.data.statuseffect.StatusEffect;
import kamkeel.npcdbc.data.statuseffect.types.Bloated;
import kamkeel.npcdbc.data.statuseffect.types.Chocolated;
import kamkeel.npcdbc.data.statuseffect.types.Darkness;
import kamkeel.npcdbc.data.statuseffect.types.Exhausted;
import kamkeel.npcdbc.data.statuseffect.types.FruitOfMight;
import kamkeel.npcdbc.data.statuseffect.types.Meditation;
import kamkeel.npcdbc.data.statuseffect.types.NamekRegen;
import kamkeel.npcdbc.data.statuseffect.types.Overpower;
import kamkeel.npcdbc.data.statuseffect.types.PotaraFusion;
import kamkeel.npcdbc.data.statuseffect.types.RegenHealth;
import kamkeel.npcdbc.data.statuseffect.types.RegenKi;
import kamkeel.npcdbc.data.statuseffect.types.RegenStamina;
import kamkeel.npcdbc.data.statuseffect.types.Zenkai;
import kamkeel.npcdbc.util.Utility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.api.entity.IPlayer;

public class StatusEffectController
implements IStatusEffectHandler {
    public static StatusEffectController Instance = new StatusEffectController();
    public HashMap<Integer, StatusEffect> standardEffects = new HashMap();
    public HashMap<Integer, CustomEffect> customEffects = new HashMap();
    public ConcurrentHashMap<UUID, Map<Integer, PlayerEffect>> playerEffects = new ConcurrentHashMap();

    public static StatusEffectController getInstance() {
        return Instance;
    }

    public void load() {
        this.playerEffects.clear();
        this.standardEffects.put(1, new RegenHealth());
        this.standardEffects.put(2, new RegenKi());
        this.standardEffects.put(3, new RegenStamina());
        this.standardEffects.put(4, new NamekRegen());
        this.standardEffects.put(5, new FruitOfMight());
        this.standardEffects.put(6, new Bloated());
        this.standardEffects.put(7, new Meditation());
        this.standardEffects.put(8, new Overpower());
        this.standardEffects.put(9, new Chocolated());
        this.standardEffects.put(10, new Darkness());
        this.standardEffects.put(11, new Zenkai());
        this.standardEffects.put(12, new PotaraFusion());
        this.standardEffects.put(13, new Exhausted());
        this.standardEffects.put(14, new Exhausted());
        this.standardEffects.put(15, new Exhausted());
        this.standardEffects.put(16, new Exhausted());
    }

    public void runEffects(EntityPlayer player) {
        Map<Integer, PlayerEffect> current = this.getPlayerEffects(player);
        for (int active : current.keySet()) {
            StatusEffect effect = this.get(active);
            if (effect == null) continue;
            effect.runEffect(player, current.get(active));
        }
    }

    public void killEffects(EntityPlayer player) {
        Map<Integer, PlayerEffect> current = this.getPlayerEffects(player);
        Iterator<Map.Entry<Integer, PlayerEffect>> iterator = current.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, PlayerEffect> entry = iterator.next();
            StatusEffect effect = this.get(entry.getKey());
            if (effect != null) {
                if (!effect.lossOnDeath) continue;
                effect.kill(player, entry.getValue());
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    public StatusEffect getFromName(String name) {
        for (StatusEffect effect : this.standardEffects.values()) {
            if (!effect.getName().equalsIgnoreCase(name)) continue;
            return effect;
        }
        return null;
    }

    public StatusEffect get(int id) {
        StatusEffect statusEffect = this.standardEffects.get(id);
        if (statusEffect == null) {
            statusEffect = this.customEffects.get(id);
        }
        return statusEffect;
    }

    public Map<Integer, PlayerEffect> getPlayerEffects(EntityPlayer player) {
        UUID playerId = Utility.getUUID((Entity)player);
        if (!this.playerEffects.containsKey(playerId)) {
            this.playerEffects.put(playerId, new ConcurrentHashMap());
        }
        return this.playerEffects.get(Utility.getUUID((Entity)player));
    }

    public void applyEffect(EntityPlayer player, int id) {
        StatusEffect parent = this.get(id);
        if (parent != null) {
            PlayerEffect playerEffect = new PlayerEffect(id, parent.length, 1);
            this.applyEffect(player, playerEffect);
        }
    }

    public void applyEffect(EntityPlayer player, int id, int duration) {
        StatusEffect parent = this.get(id);
        if (parent != null) {
            PlayerEffect playerEffect = new PlayerEffect(id, duration, 1);
            this.applyEffect(player, playerEffect);
        }
    }

    public void applyEffect(EntityPlayer player, PlayerEffect effect) {
        if (effect == null) {
            return;
        }
        StatusEffect parent = this.get(effect.id);
        if (parent != null) {
            Map<Object, Object> currentEffects = new ConcurrentHashMap();
            UUID uuid = Utility.getUUID((Entity)player);
            if (this.playerEffects.containsKey(uuid)) {
                currentEffects = this.playerEffects.get(Utility.getUUID((Entity)player));
            } else {
                this.playerEffects.put(uuid, currentEffects);
            }
            currentEffects.put(effect.id, effect);
            parent.init(player, effect);
        }
    }

    public void removeEffect(EntityPlayer player, PlayerEffect effect) {
        if (effect == null) {
            return;
        }
        Map<Object, Object> currentEffects = new ConcurrentHashMap();
        UUID uuid = Utility.getUUID((Entity)player);
        if (this.playerEffects.containsKey(uuid)) {
            currentEffects = this.playerEffects.get(Utility.getUUID((Entity)player));
        } else {
            this.playerEffects.put(uuid, currentEffects);
        }
        if (currentEffects.containsKey(effect.id)) {
            StatusEffect parent = this.get(effect.id);
            if (parent != null) {
                parent.runout(player, effect);
                parent.kill(player, effect);
            }
            currentEffects.remove(effect.id);
        }
    }

    @Override
    public boolean hasEffect(IPlayer player, int id) {
        if (player == null || player.getMCEntity() == null) {
            return false;
        }
        return this.hasEffect((EntityPlayer)player.getMCEntity(), id);
    }

    @Override
    public int getEffectDuration(IPlayer player, int id) {
        if (player == null || player.getMCEntity() == null) {
            return -1;
        }
        return this.getEffectDuration((EntityPlayer)player.getMCEntity(), id);
    }

    @Override
    public void applyEffect(IPlayer player, int id, int duration, byte level) {
        if (player == null || player.getMCEntity() == null) {
            return;
        }
        this.applyEffect((EntityPlayer)player.getMCEntity(), id, duration, level);
    }

    @Override
    public void removeEffect(IPlayer player, int id) {
        if (player == null || player.getMCEntity() == null) {
            return;
        }
        this.removeEffect((EntityPlayer)player.getMCEntity(), id);
    }

    @Override
    public void clearEffects(IPlayer player) {
        if (player == null || player.getMCEntity() == null) {
            return;
        }
        this.clearEffects((Entity)player.getMCEntity());
    }

    public void clearEffects(Entity player) {
        Map<Integer, PlayerEffect> effects = this.playerEffects.get(player.func_110124_au());
        if (effects != null) {
            effects.clear();
        }
    }

    public boolean hasEffect(EntityPlayer player, int id) {
        UUID uuid = Utility.getUUID((Entity)player);
        if (!this.playerEffects.containsKey(uuid)) {
            return false;
        }
        Map<Integer, PlayerEffect> currentEffects = this.playerEffects.get(uuid);
        return currentEffects.containsKey(id);
    }

    public int getEffectDuration(EntityPlayer player, int id) {
        Map<Object, Object> currentEffects = new ConcurrentHashMap();
        UUID uuid = Utility.getUUID((Entity)player);
        if (this.playerEffects.containsKey(uuid)) {
            currentEffects = this.playerEffects.get(uuid);
        } else {
            this.playerEffects.put(uuid, currentEffects);
        }
        if (currentEffects.containsKey(id)) {
            return ((PlayerEffect)currentEffects.get((Object)Integer.valueOf((int)id))).duration;
        }
        return -1;
    }

    public void applyEffect(EntityPlayer player, int id, int duration, byte level) {
        if (player == null || id <= 0) {
            return;
        }
        Map<Object, Object> currentEffects = new ConcurrentHashMap();
        UUID uuid = Utility.getUUID((Entity)player);
        if (this.playerEffects.containsKey(uuid)) {
            currentEffects = this.playerEffects.get(Utility.getUUID((Entity)player));
        } else {
            this.playerEffects.put(uuid, currentEffects);
        }
        StatusEffect parent = this.get(id);
        if (parent != null) {
            PlayerEffect playerEffect = new PlayerEffect(id, duration, level);
            currentEffects.put(id, playerEffect);
            parent.init(player, playerEffect);
        }
    }

    public void removeEffect(EntityPlayer player, int id) {
        if (player == null || id <= 0) {
            return;
        }
        Map<Object, Object> currentEffects = new ConcurrentHashMap();
        UUID uuid = Utility.getUUID((Entity)player);
        if (this.playerEffects.containsKey(uuid)) {
            currentEffects = this.playerEffects.get(Utility.getUUID((Entity)player));
        } else {
            this.playerEffects.put(uuid, currentEffects);
        }
        if (currentEffects.containsKey(id)) {
            PlayerEffect current = (PlayerEffect)currentEffects.get(id);
            StatusEffect parent = this.get(current.id);
            if (parent != null) {
                parent.runout(player, current);
                parent.kill(player, current);
            }
            currentEffects.remove(id);
        }
    }

    public void decrementEffects(EntityPlayer player) {
        Iterator<PlayerEffect> iterator = this.getPlayerEffects(player).values().iterator();
        while (iterator.hasNext()) {
            PlayerEffect effect = iterator.next();
            if (effect == null) {
                iterator.remove();
                continue;
            }
            if (effect.duration == -100) continue;
            if (effect.duration <= 0) {
                StatusEffect parent = Instance.get(effect.id);
                if (parent != null) {
                    parent.runout(player, effect);
                    parent.kill(player, effect);
                }
                iterator.remove();
                continue;
            }
            --effect.duration;
        }
    }
}

