/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.aura;

import kamkeel.npcdbc.api.aura.IAuraDisplay;
import kamkeel.npcdbc.api.outline.IOutline;
import kamkeel.npcdbc.constants.enums.EnumAuraTypes2D;
import kamkeel.npcdbc.constants.enums.EnumAuraTypes3D;
import kamkeel.npcdbc.controllers.OutlineController;
import kamkeel.npcdbc.data.aura.Aura;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.util.ValueUtil;

public class AuraDisplay
implements IAuraDisplay {
    public Aura parent;
    public EnumAuraTypes3D type = EnumAuraTypes3D.Base;
    public EnumAuraTypes2D type2D = EnumAuraTypes2D.Default;
    public String texture1 = "";
    public String texture2 = "";
    public String texture3 = "";
    public int color1 = -1;
    public int color2 = -1;
    public int color3 = -1;
    public int alpha = -1;
    public int speed = -1;
    public float size = 1.0f;
    public boolean hasLightning = false;
    public int lightningColor = -1;
    public int lightningAlpha = -1;
    public int lightningSpeed = -1;
    public int lightningIntensity = -1;
    public int kaiokenColor = -1;
    public int kaiokenAlpha = -1;
    public boolean hasKaiokenAura = true;
    public boolean kaiokenOverrides = true;
    public float kaiokenSize = 1.0f;
    public boolean overrideDBCAura = false;
    public boolean copyDBCSuperformColors = false;
    public boolean kettleModeCharging;
    public boolean kettleModeEnabled;
    public String auraSound = "jinryuudragonbc:DBC.aura";
    public String kaiokenSound = "";
    public int outlineID = -1;
    public boolean outlineAlwaysOn;

    public AuraDisplay(Aura parent) {
        this.parent = parent;
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound rendering = compound.func_74775_l("rendering");
        EnumAuraTypes3D auraTypes3D = EnumAuraTypes3D.getEnumFromName(rendering.func_74779_i("type"));
        this.type = auraTypes3D == null ? EnumAuraTypes3D.Base : auraTypes3D;
        EnumAuraTypes2D auraTypes2D = EnumAuraTypes2D.getEnumFromName(rendering.func_74779_i("type2D"));
        this.type2D = auraTypes2D == null ? EnumAuraTypes2D.Default : auraTypes2D;
        this.texture1 = rendering.func_74764_b("texture1") ? rendering.func_74779_i("texture1") : "";
        this.texture2 = rendering.func_74764_b("texture2") ? rendering.func_74779_i("texture2") : "";
        this.texture3 = rendering.func_74764_b("texture3") ? rendering.func_74779_i("texture3") : "";
        this.speed = rendering.func_74764_b("speed") ? rendering.func_74762_e("speed") : -1;
        this.size = rendering.func_74764_b("size") ? rendering.func_74760_g("size") : 1.0f;
        this.copyDBCSuperformColors = !rendering.func_74764_b("copyDBCSuperformColors") || rendering.func_74767_n("copyDBCSuperformColors");
        this.color1 = rendering.func_74764_b("color1") ? rendering.func_74762_e("color1") : -1;
        this.color2 = rendering.func_74764_b("color2") ? rendering.func_74762_e("color2") : -1;
        this.color3 = rendering.func_74764_b("color3") ? rendering.func_74762_e("color3") : -1;
        this.alpha = rendering.func_74764_b("alpha") ? rendering.func_74762_e("alpha") : -1;
        this.hasLightning = rendering.func_74764_b("hasLightning") && rendering.func_74767_n("hasLightning");
        this.lightningColor = rendering.func_74764_b("lightningColor") ? rendering.func_74762_e("lightningColor") : -1;
        this.lightningAlpha = rendering.func_74764_b("lightningAlpha") ? rendering.func_74762_e("lightningAlpha") : -1;
        this.lightningSpeed = rendering.func_74764_b("lightningSpeed") ? rendering.func_74762_e("lightningSpeed") : -1;
        this.lightningIntensity = rendering.func_74764_b("lightningIntensity") ? rendering.func_74762_e("lightningIntensity") : -1;
        this.kaiokenColor = rendering.func_74764_b("kaiokenColor") ? rendering.func_74762_e("kaiokenColor") : -1;
        this.kaiokenAlpha = rendering.func_74764_b("kaiokenAlpha") ? rendering.func_74762_e("kaiokenAlpha") : -1;
        this.kaiokenSize = rendering.func_74764_b("kaiokenSize") ? rendering.func_74760_g("kaiokenSize") : 1.0f;
        this.hasKaiokenAura = !rendering.func_74764_b("kaiokenOn") || rendering.func_74767_n("kaiokenOn");
        this.kaiokenOverrides = !rendering.func_74764_b("kaiokenOverrides") || rendering.func_74767_n("kaiokenOverrides");
        this.overrideDBCAura = rendering.func_74764_b("overrideDBCAura") && rendering.func_74767_n("overrideDBCAura");
        this.kettleModeCharging = rendering.func_74764_b("kettleModeCharging") && rendering.func_74767_n("kettleModeCharging");
        this.kettleModeEnabled = rendering.func_74764_b("kettleMode") && rendering.func_74767_n("kettleMode");
        this.auraSound = rendering.func_74764_b("auraSound") ? rendering.func_74779_i("auraSound") : "jinryuudragonbc:DBC.aura";
        this.kaiokenSound = rendering.func_74764_b("kaiokenSound") ? rendering.func_74779_i("kaiokenSound") : "";
        this.outlineID = rendering.func_74764_b("outlineID") ? rendering.func_74762_e("outlineID") : -1;
        this.outlineAlwaysOn = rendering.func_74767_n("outlineAlwaysOn");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound rendering = new NBTTagCompound();
        rendering.func_74778_a("type", this.type.getName());
        rendering.func_74778_a("type2D", this.type2D.name);
        rendering.func_74778_a("texture1", this.texture1);
        rendering.func_74778_a("texture2", this.texture2);
        rendering.func_74778_a("texture3", this.texture3);
        rendering.func_74768_a("speed", this.speed);
        rendering.func_74776_a("size", this.size);
        rendering.func_74757_a("copyDBCSuperformColors", this.copyDBCSuperformColors);
        rendering.func_74768_a("color1", this.color1);
        rendering.func_74768_a("color2", this.color2);
        rendering.func_74768_a("color3", this.color3);
        rendering.func_74768_a("alpha", this.alpha);
        rendering.func_74757_a("hasLightning", this.hasLightning);
        rendering.func_74768_a("lightningColor", this.lightningColor);
        rendering.func_74768_a("lightningAlpha", this.lightningAlpha);
        rendering.func_74768_a("lightningSpeed", this.lightningSpeed);
        rendering.func_74768_a("lightningIntensity", this.lightningIntensity);
        rendering.func_74768_a("kaiokenColor", this.kaiokenColor);
        rendering.func_74768_a("kaiokenAlpha", this.kaiokenAlpha);
        rendering.func_74776_a("kaiokenSize", this.kaiokenSize);
        rendering.func_74757_a("kaiokenOn", this.hasKaiokenAura);
        rendering.func_74757_a("kaiokenOverrides", this.kaiokenOverrides);
        rendering.func_74757_a("overrideDBCAura", this.overrideDBCAura);
        rendering.func_74757_a("kettleModeCharging", this.kettleModeCharging);
        rendering.func_74757_a("kettleMode", this.kettleModeEnabled);
        rendering.func_74778_a("auraSound", this.auraSound);
        rendering.func_74778_a("kaiokenSound", this.kaiokenSound);
        rendering.func_74768_a("outlineID", this.outlineID);
        rendering.func_74757_a("outlineAlwaysOn", this.outlineAlwaysOn);
        compound.func_74782_a("rendering", (NBTBase)rendering);
        return compound;
    }

    @Override
    public boolean getKettleModeEnabled() {
        return this.kettleModeEnabled;
    }

    @Override
    public void setKettleModeEnabled(boolean set) {
        this.kettleModeEnabled = set;
    }

    @Override
    public boolean getKettleModeCharging() {
        return this.kettleModeCharging;
    }

    @Override
    public void setKettleModeCharging(boolean set) {
        this.kettleModeCharging = set;
    }

    @Override
    public boolean getOverrideDBCAura() {
        return this.overrideDBCAura;
    }

    @Override
    public Aura setOverrideDBCAura(boolean override) {
        this.overrideDBCAura = override;
        return this.parent;
    }

    @Override
    public void toggleKaioken(boolean toggle) {
        this.hasKaiokenAura = toggle;
    }

    @Override
    public float getKaiokenSize() {
        return this.kaiokenSize;
    }

    @Override
    public void setKaiokenSize(float size) {
        this.kaiokenSize = size;
    }

    @Override
    public String getKaiokenSound() {
        return this.kaiokenSound;
    }

    @Override
    public void setKaiokenSound(String soundDirectory) {
        this.kaiokenSound = soundDirectory;
    }

    @Override
    public boolean hasSound() {
        return this.auraSound.length() > 3 && !this.auraSound.equals("jinryuudragonbc:DBC.aura");
    }

    @Override
    public String getAuraSound() {
        return this.auraSound.isEmpty() ? null : this.auraSound;
    }

    @Override
    public void setAuraSound(String soundDirectory) {
        this.auraSound = soundDirectory;
    }

    public String getFinalSound(EnumAuraTypes3D type) {
        String sound = this.auraSound;
        if (this.auraSound.equalsIgnoreCase("default")) {
            sound = "jinryuudragonbc:DBC.aura";
            if (type == EnumAuraTypes3D.None) {
                sound = "";
            }
            if (type == EnumAuraTypes3D.SaiyanGod || type == EnumAuraTypes3D.UltimateArco) {
                sound = "jinryuudragonbc:1610.aurag";
            } else if (type == EnumAuraTypes3D.UI) {
                sound = "jinryuudragonbc:DBC5.aura_ui";
            } else if (type == EnumAuraTypes3D.GoD) {
                sound = "jinryuudragonbc:DBC5.aura_destroyer";
            } else if (type == EnumAuraTypes3D.SaiyanBlue || type == EnumAuraTypes3D.SaiyanRose) {
                sound = "jinryuudragonbc:1610.aurab";
            } else if (type == EnumAuraTypes3D.SaiyanBlueEvo || type == EnumAuraTypes3D.SaiyanRoseEvo) {
                sound = "npcdbc:aura.ssbeaura";
            }
        }
        return sound;
    }

    public String getFinalKKSound() {
        if (!this.hasKaiokenAura) {
            return null;
        }
        String sound = null;
        if (!this.kaiokenSound.equalsIgnoreCase("nosound")) {
            if (this.kaiokenSound.isEmpty() && !this.kaiokenOverrides) {
                sound = "jinryuudragonbc:1610.aurabk";
            } else if (this.kaiokenOverrides) {
                sound = "jinryuudragonbc:DBC.aura";
            } else if (this.kaiokenSound.length() > 3) {
                sound = this.kaiokenSound;
            }
        }
        return sound;
    }

    @Override
    public boolean isKaiokenToggled() {
        return this.hasKaiokenAura;
    }

    @Override
    public String getType() {
        return this.type.getName();
    }

    @Override
    public void setType(String type) {
        EnumAuraTypes3D s = EnumAuraTypes3D.getEnumFromName(type.toLowerCase());
        if (s == null) {
            throw new CustomNPCsException("Invalid type! Legal types: %s", new Object[]{String.join((CharSequence)", ", EnumAuraTypes3D.getAllNames())});
        }
        this.type = s;
    }

    @Override
    public String getType2D() {
        return this.type2D.name;
    }

    @Override
    public void setType2D(String type2D) {
        EnumAuraTypes2D s = EnumAuraTypes2D.getEnumFromName(type2D.toLowerCase());
        if (s == null) {
            throw new CustomNPCsException("Invalid type! Legal types: %s", new Object[]{String.join((CharSequence)", ", EnumAuraTypes2D.getAllNames())});
        }
        this.type2D = s;
    }

    @Override
    public String getTexture(String textureType) {
        return null;
    }

    @Override
    public void setTexture(String textureType, String textureLocation) {
    }

    @Override
    public boolean hasColor(String colorType) {
        switch (colorType.toLowerCase()) {
            case "color1": {
                return this.color1 > -1;
            }
            case "color2": {
                return this.color2 > -1;
            }
            case "color3": {
                return this.color3 > -1;
            }
            case "lightning": {
                return this.lightningColor > -1;
            }
            case "kaioken": {
                return this.kaiokenColor > -1;
            }
        }
        throw new CustomNPCsException("Invalid type! Legal types: color1, color2, color3, lightningColor, kaioken", new Object[0]);
    }

    @Override
    public void setColor(String colorType, int color) {
        switch (colorType.toLowerCase()) {
            case "color1": {
                this.color1 = color;
                break;
            }
            case "color2": {
                this.color2 = color;
                break;
            }
            case "color3": {
                this.color3 = color;
                break;
            }
            case "lightning": {
                this.lightningColor = color;
                break;
            }
            case "kaioken": {
                this.kaiokenColor = color;
                break;
            }
            default: {
                throw new CustomNPCsException("Invalid type! Legal types: color1, color2, color3, lightning, kaioken", new Object[0]);
            }
        }
    }

    @Override
    public int getColor(String colorType) {
        switch (colorType.toLowerCase()) {
            case "color1": {
                return this.color1;
            }
            case "color2": {
                return this.color2;
            }
            case "color3": {
                return this.color3;
            }
            case "lightning": {
                return this.lightningColor;
            }
            case "kaioken": {
                return this.kaiokenColor;
            }
        }
        throw new CustomNPCsException("Invalid type! Legal types: color1, color2, color3, lightningColor, kaioken", new Object[0]);
    }

    @Override
    public boolean hasAlpha(String type) {
        switch (type.toLowerCase()) {
            case "aura": {
                return this.alpha > -1;
            }
            case "lightning": {
                return this.lightningAlpha > -1;
            }
            case "kaioken": {
                return this.kaiokenAlpha > -1;
            }
        }
        throw new CustomNPCsException("Invalid type! Legal types:  aura, lightning, kaioken", new Object[0]);
    }

    @Override
    public int getAlpha(String type) {
        switch (type.toLowerCase()) {
            case "aura": {
                return this.alpha;
            }
            case "lightning": {
                return this.lightningAlpha;
            }
            case "kaioken": {
                return this.kaiokenAlpha;
            }
        }
        throw new CustomNPCsException("Invalid type! Legal types: aura, lightning, kaioken", new Object[0]);
    }

    @Override
    public void setAlpha(String type, int value) {
        switch (type.toLowerCase()) {
            case "aura": {
                this.alpha = value;
                break;
            }
            case "lightning": {
                this.lightningAlpha = value;
                break;
            }
            case "kaioken": {
                this.kaiokenAlpha = value;
                break;
            }
            default: {
                throw new CustomNPCsException("Invalid type! Legal types: aura, lightning, kaioken", new Object[0]);
            }
        }
    }

    @Override
    public void hasLightning(boolean hasLightning) {
        this.hasLightning = hasLightning;
    }

    @Override
    public boolean getHasLightning() {
        return this.hasLightning;
    }

    @Override
    public int getLightningSpeed() {
        return this.lightningSpeed;
    }

    @Override
    public void setLightningSpeed(int lightningSpeed) {
        this.lightningSpeed = lightningSpeed;
    }

    @Override
    public int getLightningIntensity() {
        return this.lightningIntensity;
    }

    @Override
    public void setLightningIntensity(int lightningIntensity) {
        if (lightningIntensity != -1) {
            lightningIntensity = ValueUtil.clamp((int)lightningIntensity, (int)1, (int)8);
        }
        this.lightningIntensity = lightningIntensity;
    }

    @Override
    public boolean hasSize() {
        return this.size != 1.0f;
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public void setSize(float size) {
        this.size = ValueUtil.clamp((float)size, (float)0.05f, (float)10.0f);
    }

    @Override
    public boolean hasSpeed() {
        return this.speed > 0;
    }

    @Override
    public int getSpeed() {
        return this.speed;
    }

    @Override
    public void setSpeed(int speed) {
        this.speed = speed;
    }

    @Override
    public boolean getOutlineAlwaysOn() {
        return this.outlineAlwaysOn;
    }

    @Override
    public void setOutlineAlwaysOn(boolean alwaysOn) {
        this.outlineAlwaysOn = alwaysOn;
    }

    @Override
    public void setOutline(int id) {
        this.outlineID = OutlineController.Instance.has(id) ? id : -1;
    }

    @Override
    public void setOutline(IOutline outline) {
        int id = outline != null ? outline.getID() : -1;
        this.setOutline(id);
    }

    @Override
    public IAuraDisplay save() {
        if (this.parent != null) {
            this.parent.save();
        }
        return this;
    }

    @Override
    public boolean doesAuraCopyDBCSuperformColors() {
        return this.copyDBCSuperformColors;
    }

    @Override
    public void setDoesAuraCopyDBCSuperformColors(boolean copyDBCSuperformColors) {
        this.copyDBCSuperformColors = copyDBCSuperformColors;
    }
}

