/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.dbcdata;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import kamkeel.npcdbc.controllers.BonusController;
import kamkeel.npcdbc.data.PlayerBonus;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DBCDataBonus {
    private final DBCData data;

    public DBCDataBonus(DBCData dbcData) {
        this.data = dbcData;
    }

    public Map<String, PlayerBonus> getCurrentBonuses() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (this.data.currentBonuses == null) {
                this.data.currentBonuses = new HashMap<String, PlayerBonus>();
            }
            return this.data.currentBonuses;
        }
        return BonusController.getInstance().getPlayerBonus(this.data.player);
    }

    public float[] getMultiBonus() {
        float[] bonuses = new float[3];
        for (PlayerBonus playerBonus : this.getCurrentBonuses().values()) {
            if (playerBonus.type != 0) continue;
            bonuses[0] = bonuses[0] + playerBonus.strength;
            bonuses[1] = bonuses[1] + playerBonus.dexterity;
            bonuses[2] = bonuses[2] + playerBonus.willpower;
        }
        return bonuses;
    }

    public float[] getFlatBonus() {
        float[] bonuses = new float[5];
        for (PlayerBonus playerBonus : this.getCurrentBonuses().values()) {
            if (playerBonus.type != 1) continue;
            bonuses[0] = bonuses[0] + playerBonus.strength;
            bonuses[1] = bonuses[1] + playerBonus.dexterity;
            bonuses[2] = bonuses[2] + playerBonus.willpower;
            bonuses[3] = bonuses[3] + playerBonus.constituion;
            bonuses[4] = bonuses[4] + playerBonus.spirit;
        }
        return bonuses;
    }

    public void saveBonusNBT(NBTTagCompound nbt) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (PlayerBonus bonus : this.getCurrentBonuses().values()) {
            nbttaglist.func_74742_a((NBTBase)bonus.writeBonusData(new NBTTagCompound()));
        }
        nbt.func_74782_a("addonBonus", (NBTBase)nbttaglist);
    }
}

