/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.form;

import JinRyuu.JRMCore.JRMCoreH;
import kamkeel.npcdbc.api.aura.IAura;
import kamkeel.npcdbc.api.form.IFormDisplay;
import kamkeel.npcdbc.api.outline.IOutline;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.controllers.OutlineController;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.scripted.CustomNPCsException;
import noppes.npcs.util.ValueUtil;

public class FormDisplay
implements IFormDisplay {
    private final Form parent;
    public float formSize = 1.0f;
    public boolean keepOriginalSize = true;
    public String hairCode = "";
    public String hairType = "";
    public int hairColor = -1;
    public int eyeColor = -1;
    public int auraColor = -1;
    public int kiBarColor = -1;
    public String bodyType = "";
    public int bodyCM = -1;
    public int bodyC1 = -1;
    public int bodyC2 = -1;
    public int bodyC3 = -1;
    public int furColor = -1;
    public boolean hasBodyFur = false;
    public boolean hasArcoMask = false;
    public boolean effectMajinHair = false;
    public boolean isBerserk;
    public boolean hasEyebrows = true;
    public int auraID = -1;
    public int outlineID = -1;

    public FormDisplay(Form parent) {
        this.parent = parent;
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound rendering = compound.func_74775_l("rendering");
        this.auraColor = rendering.func_74762_e("auraColor");
        this.eyeColor = rendering.func_74762_e("eyeColor");
        this.hairColor = rendering.func_74762_e("hairColor");
        this.kiBarColor = rendering.func_74762_e("kiBarColor");
        this.furColor = rendering.func_74762_e("furColor");
        this.hairCode = rendering.func_74779_i("hairCode");
        this.hairType = rendering.func_74779_i("hairType");
        this.bodyType = rendering.func_74779_i("bodyType");
        this.bodyCM = rendering.func_74762_e("bodyCM");
        this.bodyC1 = rendering.func_74762_e("bodyC1");
        this.bodyC2 = rendering.func_74762_e("bodyC2");
        this.bodyC3 = rendering.func_74762_e("bodyC3");
        this.hasArcoMask = rendering.func_74767_n("hasArcoMask");
        this.effectMajinHair = rendering.func_74767_n("effectMajinHair");
        this.hasBodyFur = rendering.func_74767_n("hasBodyFur");
        this.isBerserk = rendering.func_74767_n("isBerserk");
        this.hasEyebrows = !rendering.func_74764_b("hasEyebrows") ? true : rendering.func_74767_n("hasEyebrows");
        this.formSize = rendering.func_74760_g("formSize");
        this.keepOriginalSize = rendering.func_74767_n("keepOriginalSize");
        this.auraID = rendering.func_74764_b("auraID") ? rendering.func_74762_e("auraID") : -1;
        this.outlineID = rendering.func_74764_b("outlineID") ? rendering.func_74762_e("outlineID") : -1;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound rendering = new NBTTagCompound();
        rendering.func_74768_a("auraColor", this.auraColor);
        rendering.func_74768_a("eyeColor", this.eyeColor);
        rendering.func_74768_a("hairColor", this.hairColor);
        rendering.func_74768_a("kiBarColor", this.kiBarColor);
        rendering.func_74778_a("hairCode", this.hairCode);
        rendering.func_74778_a("hairType", this.hairType);
        rendering.func_74778_a("bodyType", this.bodyType);
        rendering.func_74768_a("furColor", this.furColor);
        rendering.func_74768_a("bodyCM", this.bodyCM);
        rendering.func_74768_a("bodyC1", this.bodyC1);
        rendering.func_74768_a("bodyC2", this.bodyC2);
        rendering.func_74768_a("bodyC3", this.bodyC3);
        rendering.func_74757_a("hasArcoMask", this.hasArcoMask);
        rendering.func_74757_a("effectMajinHair", this.effectMajinHair);
        rendering.func_74757_a("hasBodyFur", this.hasBodyFur);
        rendering.func_74757_a("isBerserk", this.isBerserk);
        rendering.func_74757_a("hasEyebrows", this.hasEyebrows);
        rendering.func_74776_a("formSize", this.formSize);
        rendering.func_74757_a("keepOriginalSize", this.keepOriginalSize);
        rendering.func_74768_a("auraID", this.auraID);
        rendering.func_74768_a("outlineID", this.outlineID);
        compound.func_74782_a("rendering", (NBTBase)rendering);
        return compound;
    }

    public int getFurColor(DBCData data) {
        int c1;
        int n = c1 = data.skinType == 1 ? JRMCoreH.dnsBodyC1((String)data.DNS) : JRMCoreH.dnsBodyC1_0((String)data.DNS);
        if (c1 != 6498048 && this.furColor == -1) {
            return c1;
        }
        if (this.furColor == -1) {
            return 14292268;
        }
        return this.furColor;
    }

    public boolean hasHairCol(DBCData data) {
        return this.hairColor != -1 && data.Race != 3;
    }

    public int getHairColor(DBCData data) {
        if (data.Race == 3) {
            return this.bodyCM;
        }
        return this.hairColor;
    }

    @Override
    public boolean getKeepOriginalSize() {
        return this.keepOriginalSize;
    }

    @Override
    public void setKeepOriginalSize(boolean keepOriginalSize) {
        this.keepOriginalSize = keepOriginalSize;
    }

    @Override
    public String getHairCode() {
        return this.hairCode;
    }

    @Override
    public void setHairCode(String hairCode) {
        if (hairCode.length() != 786 && hairCode.length() != 784 && hairCode.length() != 392) {
            hairCode = "";
        }
        this.hairCode = hairCode;
    }

    @Override
    public String getBodyType() {
        return this.bodyType;
    }

    @Override
    public void setBodyType(String type) {
        String s = type.toLowerCase();
        if (!(s.equals("firstform") || s.equals("secondform") || s.equals("thirdform") || s.equals("finalform") || s.equals("ultimatecooler") || s.equals("golden") || s.equals(""))) {
            throw new CustomNPCsException("Invalid type! Legal: firstform, secondform, thirdform, finalform, ultimatecooler, golden", new Object[0]);
        }
        this.bodyType = s;
    }

    @Override
    public boolean isBerserk() {
        return this.isBerserk;
    }

    @Override
    public void setBerserk(boolean isBerserk) {
        this.isBerserk = isBerserk;
    }

    @Override
    public boolean hasEyebrows() {
        return this.hasEyebrows;
    }

    @Override
    public void hasEyebrows(boolean has) {
        this.hasEyebrows = has;
    }

    @Override
    public float getSize() {
        return this.formSize;
    }

    @Override
    public void setSize(float size) {
        this.formSize = ValueUtil.clamp((float)size, (float)0.2f, (float)3.0f);
    }

    @Override
    public boolean hasSize() {
        return this.formSize != 1.0f;
    }

    @Override
    public boolean hasColor(String type) {
        switch (type.toLowerCase()) {
            case "kibar": {
                return this.kiBarColor != -1;
            }
            case "aura": {
                return this.auraColor != -1;
            }
            case "hair": {
                return this.hairColor != -1;
            }
            case "eye": {
                return this.eyeColor != -1;
            }
            case "bodycm": {
                return this.bodyCM != -1;
            }
            case "bodyc1": {
                return this.bodyC1 != -1;
            }
            case "bodyc2": {
                return this.bodyC2 != -1;
            }
            case "bodyc3": {
                return this.bodyC3 != -1;
            }
            case "fur": {
                return this.furColor != -1;
            }
        }
        throw new CustomNPCsException("Invalid type! Legal types: kiBar, aura, hair, eye, bodycm, bodyc1, bodyc2, bodyc3, fur", new Object[0]);
    }

    @Override
    public void setColor(String type, int color) {
        switch (type.toLowerCase()) {
            case "kibar": {
                this.kiBarColor = color;
                break;
            }
            case "aura": {
                this.auraColor = color;
                break;
            }
            case "hair": {
                this.hairColor = color;
                break;
            }
            case "eye": {
                this.eyeColor = color;
                break;
            }
            case "bodycm": {
                this.bodyCM = color;
                break;
            }
            case "bodyc1": {
                this.bodyC1 = color;
                break;
            }
            case "bodyc2": {
                this.bodyC2 = color;
                break;
            }
            case "bodyc3": {
                this.bodyC3 = color;
                break;
            }
            case "fur": {
                this.furColor = color;
                break;
            }
            default: {
                throw new CustomNPCsException("Invalid type! Legal types: kiBar, aura, hair, eye, bodycm, bodyc1, bodyc2, bodyc3, fur", new Object[0]);
            }
        }
    }

    @Override
    public void setHairType(String type) {
        String s = type.toLowerCase();
        if (!(s.equals("base") || s.equals("ssj") || s.equals("ssj2") || s.equals("ssj3") || s.equals("ssj4") || s.equals("oozaru") || s.equals("raditz") || s.equals(""))) {
            this.hairType = "";
            throw new CustomNPCsException("Invalid type!", new Object[0]);
        }
        this.hairType = s;
    }

    @Override
    public String getHairType(String type) {
        String s = type.toLowerCase();
        if (s.equals("base") || s.equals("ssj") || s.equals("ssj2") || s.equals("ssj3") || s.equals("ssj4") || s.equals("oozaru") || s.equals("raditz") || s.equals("")) {
            return this.hairType;
        }
        throw new CustomNPCsException("Invalid type!", new Object[0]);
    }

    @Override
    public int getColor(String type) {
        switch (type.toLowerCase()) {
            case "kibar": {
                return this.kiBarColor;
            }
            case "aura": {
                return this.auraColor;
            }
            case "hair": {
                return this.hairColor;
            }
            case "eye": {
                return this.eyeColor;
            }
            case "bodycm": {
                return this.bodyCM;
            }
            case "bodyc1": {
                return this.bodyC1;
            }
            case "bodyc2": {
                return this.bodyC2;
            }
            case "bodyc3": {
                return this.bodyC3;
            }
            case "fur": {
                return this.furColor;
            }
        }
        throw new CustomNPCsException("Invalid type! Legal types: kiBar, aura, hair, eye, bodycm, bodyc1, bodyc2, bodyc3, fur", new Object[0]);
    }

    @Override
    public boolean hasArcoMask() {
        return this.hasArcoMask;
    }

    @Override
    public void hasArcoMask(boolean hasMask) {
        this.hasArcoMask = hasMask;
    }

    @Override
    public boolean hasBodyFur() {
        return this.hasBodyFur;
    }

    @Override
    public void hasBodyFur(boolean hasFur) {
        this.hasBodyFur = hasFur;
    }

    @Override
    public boolean effectMajinHair() {
        return this.effectMajinHair;
    }

    @Override
    public void setEffectMajinHair(boolean effect) {
        this.effectMajinHair = effect;
    }

    @Override
    public boolean hasAura() {
        boolean has = AuraController.getInstance().has(this.auraID);
        if (!has && this.auraID > -1) {
            this.auraID = -1;
        }
        return has;
    }

    @Override
    public IAura getAura() {
        return AuraController.getInstance().get(this.auraID);
    }

    @Override
    public void setAura(IAura aura) {
        this.auraID = aura.getID();
    }

    @Override
    public void setAura(int auraID) {
        this.auraID = auraID;
    }

    public Aura getAur() {
        return (Aura)AuraController.getInstance().get(this.auraID);
    }

    @Override
    public void setOutline(int id) {
        this.outlineID = OutlineController.Instance.has(id) ? id : -1;
    }

    @Override
    public void setOutline(IOutline outline) {
        int id = outline != null ? outline.getID() : -1;
        this.setOutline(id);
    }

    @Override
    public IFormDisplay save() {
        if (this.parent != null) {
            this.parent.save();
        }
        return this;
    }
}

