/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.npc;

import kamkeel.npcdbc.api.npc.IDBCStats;
import kamkeel.npcdbc.config.ConfigDBCGeneral;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;

public class DBCStats
implements IDBCStats {
    public boolean enabled = ConfigDBCGeneral.STATS_BY_DEFAULT;
    public boolean friendlyFist = false;
    public boolean ignoreDex = false;
    public boolean ignoreBlock = false;
    public boolean ignoreEndurance = false;
    public boolean ignoreKiProtection = false;
    public boolean ignoreFormReduction = false;
    public boolean hasDefensePenetration = false;
    public int defensePenetration = 10;
    public int friendlyFistTime = 6;
    public byte release = (byte)100;
    private boolean canBeLockedOn = true;
    private EntityNPCInterface npc;

    public DBCStats(EntityNPCInterface npc) {
        this.npc = npc;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("DBCStatsEnabled", this.enabled);
        nbttagcompound.func_74757_a("DBCCanBeLockedOn", this.canBeLockedOn);
        if (this.friendlyFistTime <= 0) {
            this.friendlyFistTime = 6;
        }
        if (this.enabled) {
            NBTTagCompound dbcStats = new NBTTagCompound();
            dbcStats.func_74757_a("DBCFriendlyFist", this.friendlyFist);
            dbcStats.func_74768_a("DBCFriendlyFistTime", this.friendlyFistTime);
            dbcStats.func_74757_a("DBCIgnoreDex", this.ignoreDex);
            dbcStats.func_74757_a("DBCIgnoreBlock", this.ignoreBlock);
            dbcStats.func_74757_a("DBCIgnoreEndurance", this.ignoreEndurance);
            dbcStats.func_74757_a("DBCIgnoreKiProtection", this.ignoreKiProtection);
            dbcStats.func_74757_a("DBCIgnoreFormReduction", this.ignoreFormReduction);
            dbcStats.func_74757_a("DBCIsDefensePen", this.hasDefensePenetration);
            dbcStats.func_74768_a("DBCDefensePen", this.defensePenetration);
            dbcStats.func_74774_a("DBCRelease", this.release);
            nbttagcompound.func_74782_a("DBCStats", (NBTBase)dbcStats);
        } else {
            nbttagcompound.func_82580_o("DBCStats");
        }
        return nbttagcompound;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.enabled = nbttagcompound.func_74767_n("DBCStatsEnabled");
        if (nbttagcompound.func_74764_b("DBCCanBeLockedOn")) {
            this.setLockOnState(nbttagcompound.func_74767_n("DBCCanBeLockedOn"));
        } else {
            this.setLockOnState(true);
        }
        if (this.enabled) {
            NBTTagCompound dbcStats = nbttagcompound.func_74775_l("DBCStats");
            this.friendlyFist = dbcStats.func_74767_n("DBCFriendlyFist");
            this.friendlyFistTime = dbcStats.func_74762_e("DBCFriendlyFistTime");
            this.ignoreDex = dbcStats.func_74767_n("DBCIgnoreDex");
            this.ignoreBlock = dbcStats.func_74767_n("DBCIgnoreBlock");
            this.ignoreEndurance = dbcStats.func_74767_n("DBCIgnoreEndurance");
            this.ignoreKiProtection = dbcStats.func_74767_n("DBCIgnoreKiProtection");
            this.ignoreFormReduction = dbcStats.func_74767_n("DBCIgnoreFormReduction");
            this.hasDefensePenetration = dbcStats.func_74767_n("DBCIsDefensePen");
            this.defensePenetration = dbcStats.func_74762_e("DBCDefensePen");
            this.release = dbcStats.func_74771_c("DBCRelease");
        } else {
            nbttagcompound.func_82580_o("DBCStats");
        }
        if (this.friendlyFistTime <= 0) {
            this.friendlyFistTime = 6;
        }
    }

    @Override
    public void setRelease(byte release) {
        this.release = release;
    }

    @Override
    public byte getRelease() {
        return this.release;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isFriendlyFist() {
        return this.friendlyFist;
    }

    @Override
    public void setFriendlyFist(boolean friendlyFist) {
        this.friendlyFist = friendlyFist;
    }

    @Override
    public int getFriendlyFistAmount() {
        return this.friendlyFistTime;
    }

    @Override
    public void setFriendlyFistAmount(int seconds) {
        this.friendlyFistTime = ValueUtil.clamp((int)seconds, (int)1, (int)60);
    }

    @Override
    public boolean isIgnoreDex() {
        return this.ignoreDex;
    }

    @Override
    public void setIgnoreDex(boolean ignoreDex) {
        this.ignoreDex = ignoreDex;
    }

    @Override
    public boolean isIgnoreBlock() {
        return this.ignoreBlock;
    }

    @Override
    public void setIgnoreBlock(boolean ignoreBlock) {
        this.ignoreBlock = ignoreBlock;
    }

    @Override
    public boolean isIgnoreEndurance() {
        return this.ignoreEndurance;
    }

    @Override
    public void setIgnoreEndurance(boolean ignoreEndurance) {
        this.ignoreEndurance = ignoreEndurance;
    }

    @Override
    public boolean isIgnoreKiProtection() {
        return this.ignoreKiProtection;
    }

    @Override
    public void setIgnoreKiProtection(boolean ignoreKiProtection) {
        this.ignoreKiProtection = ignoreKiProtection;
    }

    @Override
    public boolean isIgnoreFormReduction() {
        return this.ignoreFormReduction;
    }

    @Override
    public void setIgnoreFormReduction(boolean ignoreFormReduction) {
        this.ignoreFormReduction = ignoreFormReduction;
    }

    @Override
    public boolean hasDefensePenetration() {
        return this.hasDefensePenetration;
    }

    @Override
    public void setHasDefensePenetration(boolean hasDefensePenetration) {
        this.hasDefensePenetration = hasDefensePenetration;
    }

    @Override
    public int getDefensePenetration() {
        return this.defensePenetration;
    }

    @Override
    public void setDefensePenetration(int defensePenetration) {
        this.defensePenetration = defensePenetration;
    }

    @Override
    public boolean canBeLockedOn() {
        if (this.npc != null) {
            return this.npc.func_70096_w().func_75679_c(31) == 1;
        }
        return this.canBeLockedOn;
    }

    @Override
    public void setLockOnState(boolean canBeLockedOn) {
        this.canBeLockedOn = canBeLockedOn;
        if (this.npc != null) {
            this.npc.func_70096_w().func_75692_b(31, (Object)(canBeLockedOn ? 1 : 0));
        }
    }
}

