/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.statuseffect;

import kamkeel.npcdbc.api.effect.IPlayerEffect;
import kamkeel.npcdbc.controllers.StatusEffectController;
import kamkeel.npcdbc.data.statuseffect.StatusEffect;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.entity.IPlayer;

public class PlayerEffect
implements IPlayerEffect {
    public int id;
    public int duration;
    public byte level;

    public PlayerEffect(int id, int duration, byte level) {
        this.id = id;
        this.duration = duration;
        this.level = level;
    }

    public static PlayerEffect readEffectData(NBTTagCompound nbt) {
        int id = nbt.func_74762_e("Id");
        if (id > 0) {
            boolean found;
            boolean bl = found = StatusEffectController.getInstance().standardEffects.containsKey(id) || StatusEffectController.getInstance().customEffects.containsKey(id);
            if (found) {
                byte level = nbt.func_74771_c("Level");
                int dur = nbt.func_74762_e("Dur");
                return new PlayerEffect(id, dur, level);
            }
        }
        return null;
    }

    public NBTTagCompound writeEffectData(NBTTagCompound nbt) {
        nbt.func_74768_a("Id", this.id);
        nbt.func_74774_a("Level", this.level);
        nbt.func_74768_a("Dur", this.duration);
        return nbt;
    }

    @Override
    public void kill() {
        this.duration = 0;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public byte getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(byte level) {
        this.level = level;
    }

    @Override
    public String getName() {
        StatusEffect effect = StatusEffectController.getInstance().get(this.id);
        if (effect != null) {
            return effect.getName();
        }
        return "UNKNOWN";
    }

    @Override
    public void performEffect(IPlayer player) {
        StatusEffect effect;
        if (player != null && player.getMCEntity() != null && player.getMCEntity() instanceof EntityPlayer && (effect = StatusEffectController.getInstance().get(this.id)) != null) {
            effect.process((EntityPlayer)player.getMCEntity(), this);
        }
    }
}

