/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.statuseffect.types;

import kamkeel.npcdbc.constants.enums.EnumPotaraTypes;
import kamkeel.npcdbc.controllers.BonusController;
import kamkeel.npcdbc.data.PlayerBonus;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.statuseffect.PlayerEffect;
import kamkeel.npcdbc.data.statuseffect.StatusEffect;
import net.minecraft.entity.player.EntityPlayer;

public class PotaraFusion
extends StatusEffect {
    public PotaraFusion() {
        this.name = "Potara";
        this.id = 12;
        this.icon = "npcdbc:textures/gui/icons.png";
        this.iconX = 176;
        this.iconY = 0;
    }

    @Override
    public void init(EntityPlayer player, PlayerEffect playerEffect) {
        EnumPotaraTypes potaraTypes = EnumPotaraTypes.getPotaraFromMeta(playerEffect.level);
        float bonusMulti = potaraTypes.getMulti();
        if (bonusMulti > 0.0f) {
            PlayerBonus bonus = new PlayerBonus(this.name, 0, bonusMulti, bonusMulti, bonusMulti);
            BonusController.getInstance().applyBonus(player, bonus);
        }
    }

    @Override
    public void kill(EntityPlayer player, PlayerEffect playerEffect) {
        BonusController.getInstance().removeBonus(player, this.name);
    }

    @Override
    public void process(EntityPlayer player, PlayerEffect playerEffect) {
        boolean isFused;
        DBCData dbcData = DBCData.get(player);
        boolean bl = isFused = dbcData.containsSE(10) || dbcData.containsSE(11);
        if (!isFused) {
            playerEffect.kill();
            BonusController.getInstance().removeBonus(player, this.name);
        }
    }
}

