/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.items.capsules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kamkeel.npcdbc.config.ConfigCapsules;
import kamkeel.npcdbc.constants.enums.EnumRegenCapsules;
import kamkeel.npcdbc.controllers.CapsuleController;
import kamkeel.npcdbc.controllers.StatusEffectController;
import kamkeel.npcdbc.scripted.DBCEventHooks;
import kamkeel.npcdbc.scripted.DBCPlayerEvent;
import kamkeel.npcdbc.util.PlayerDataUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;

public class ItemRegenCapsule
extends Item {
    protected IIcon[] icons;

    public ItemRegenCapsule() {
        this.func_77625_d(ConfigCapsules.RegenCapsuleMaxStack);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a((CreativeTabs)CustomItems.tabMisc);
    }

    public String func_77667_c(ItemStack stack) {
        int metadata = stack.func_77960_j();
        EnumRegenCapsules regenCapsule = EnumRegenCapsules.values()[metadata];
        return "item.npcdbc:" + regenCapsule.getName().toLowerCase() + "_regencapsule";
    }

    public void func_94581_a(IIconRegister reg) {
        this.icons = new IIcon[EnumRegenCapsules.count()];
        String prefix = "npcdbc:regencapsules/";
        for (EnumRegenCapsules regenCapsule : EnumRegenCapsules.values()) {
            this.icons[regenCapsule.getMeta()] = reg.func_94245_a(prefix + regenCapsule.getName().toLowerCase());
        }
    }

    public IIcon func_77617_a(int meta) {
        if (meta >= 0 && meta < EnumRegenCapsules.count()) {
            return this.icons[meta];
        }
        return this.icons[0];
    }

    public EnumRarity func_77613_e(ItemStack item) {
        int rarity = item.func_77960_j() % 3 + 1;
        if (rarity >= EnumRarity.values().length) {
            return EnumRarity.epic;
        }
        return EnumRarity.values()[rarity];
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (EnumRegenCapsules regenCapsule : EnumRegenCapsules.values()) {
            list.add(new ItemStack(item, 1, regenCapsule.getMeta()));
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        if (world.field_72995_K) {
            return itemStack;
        }
        int meta = itemStack.func_77960_j();
        if (meta < 0 || meta >= EnumRegenCapsules.count()) {
            meta = 0;
        }
        EnumRegenCapsules regenCapsules = EnumRegenCapsules.values()[meta];
        UUID playerUUID = player.func_110124_au();
        long remainingTime = CapsuleController.canUseRegenCapsule(playerUUID, meta);
        if (remainingTime > 0L) {
            player.func_146105_b((IChatComponent)new ChatComponentText("\u00a7fCapsule is on cooldown for " + remainingTime + " seconds"));
            return itemStack;
        }
        if (DBCEventHooks.onCapsuleUsedEvent(new DBCPlayerEvent.CapsuleUsedEvent(PlayerDataUtil.getIPlayer(player), 4, meta))) {
            return itemStack;
        }
        StatusEffectController.getInstance().applyEffect(player, regenCapsules.getStatusEffectId(), regenCapsules.getEffectTime(), (byte)regenCapsules.getStrength());
        itemStack.func_77979_a(1);
        if (itemStack.field_77994_a <= 0) {
            player.func_71028_bD();
        }
        CapsuleController.setRegenCapsule(playerUUID, meta);
        return itemStack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 100;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        int meta = itemStack.func_77960_j();
        if (meta < 0 || meta >= EnumRegenCapsules.count()) {
            meta = 0;
        }
        EnumRegenCapsules regenCapsules = EnumRegenCapsules.values()[meta];
        HashMap<Integer, Integer> regenStrength = CapsuleController.Instance.capsuleStrength.get(4);
        HashMap<Integer, Integer> regenCooldown = CapsuleController.Instance.capsuleCooldowns.get(4);
        HashMap<Integer, Integer> regenTimes = CapsuleController.Instance.capsuleEffectTimes.get(4);
        par3List.add(StatCollector.func_74837_a((String)"capsule.effect", (Object[])new Object[]{StatusEffectController.getInstance().get(regenCapsules.getStatusEffectId()).getName(), regenStrength.get(meta), regenTimes.get(meta)}));
        par3List.add(StatCollector.func_74837_a((String)"capsule.cooldown", (Object[])new Object[]{regenCooldown.get(meta)}));
    }
}

