/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.mixins.late.impl.npc;

import JinRyuu.JRMCore.JRMCoreH;
import kamkeel.addon.DBCAddon;
import kamkeel.npcdbc.constants.DBCDamageSource;
import kamkeel.npcdbc.controllers.DBCSyncController;
import kamkeel.npcdbc.data.npc.DBCStats;
import kamkeel.npcdbc.mixins.late.INPCDisplay;
import kamkeel.npcdbc.mixins.late.INPCStats;
import kamkeel.npcdbc.mixins.late.IPlayerDBCInfo;
import kamkeel.npcdbc.scripted.DBCEventHooks;
import kamkeel.npcdbc.scripted.DBCPlayerEvent;
import kamkeel.npcdbc.util.DBCUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import noppes.npcs.NpcDamageSource;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={DBCAddon.class})
public class MixinDBCAddon {
    @Shadow(remap=false)
    public boolean supportEnabled;

    @Overwrite(remap=false)
    public void dbcCopyData(EntityLivingBase copied, EntityLivingBase entity) {
        if (!this.supportEnabled) {
            return;
        }
        if (entity instanceof EntityNPCInterface && copied instanceof EntityNPCInterface) {
            EntityNPCInterface receiverNPC = (EntityNPCInterface)entity;
            EntityNPCInterface npc = (EntityNPCInterface)copied;
            INPCStats stats = (INPCStats)npc.stats;
            INPCStats receiverStats = (INPCStats)receiverNPC.stats;
            INPCDisplay display = (INPCDisplay)npc.display;
            INPCDisplay receiverDisplay = (INPCDisplay)receiverNPC.display;
            NBTTagCompound dbcStats = new NBTTagCompound();
            stats.getDBCStats().writeToNBT(dbcStats);
            receiverStats.getDBCStats().readFromNBT(dbcStats);
            receiverDisplay.getDBCDisplay().setEnabled(display.getDBCDisplay().isEnabled());
            receiverDisplay.getDBCDisplay().setFormAuraTypes(display.getDBCDisplay().getFormAuraTypes());
        }
    }

    @Overwrite(remap=false)
    public boolean canDBCAttack(EntityNPCInterface npc, float attackStrength, Entity receiver) {
        if (!this.supportEnabled) {
            return false;
        }
        DBCStats dbcStats = ((INPCStats)npc.stats).getDBCStats();
        return dbcStats.enabled && receiver instanceof EntityPlayer && attackStrength > 0.0f;
    }

    @Overwrite(remap=false)
    public void doDBCDamage(EntityNPCInterface npc, float attackStrength, Entity receiver) {
        if (npc.isRemote()) {
            return;
        }
        if (attackStrength <= 0.0f) {
            return;
        }
        if (!(receiver instanceof EntityPlayer)) {
            return;
        }
        if (npc.stats instanceof INPCStats) {
            NpcDamageSource damageSource;
            EntityPlayer player = (EntityPlayer)receiver;
            DBCStats dbcStats = ((INPCStats)npc.stats).getDBCStats();
            int damageToHP = DBCUtils.calculateDBCStatDamage(player, (int)attackStrength, dbcStats);
            DBCPlayerEvent.DamagedEvent damagedEvent = new DBCPlayerEvent.DamagedEvent(player, damageToHP, (DamageSource)(damageSource = new NpcDamageSource("mob", (Entity)npc)), DBCDamageSource.NPC);
            if (DBCEventHooks.onDBCDamageEvent(damagedEvent)) {
                return;
            }
            DBCUtils.lastSetDamage = (int)damagedEvent.damage;
            DBCUtils.doDBCDamage(player, damageToHP, dbcStats, (DamageSource)damageSource);
        }
    }

    @Overwrite(remap=false)
    public boolean isKO(EntityNPCInterface npc, EntityPlayer player) {
        if (npc.isRemote()) {
            return false;
        }
        if (npc.stats instanceof INPCStats) {
            DBCStats dbcStats = ((INPCStats)npc.stats).getDBCStats();
            if (dbcStats.enabled && dbcStats.isFriendlyFist()) {
                int currentKO = JRMCoreH.getInt((EntityPlayer)player, (String)"jrmcHar4va");
                return currentKO > 0;
            }
        }
        return false;
    }

    @Overwrite(remap=false)
    public void writeToNBT(PlayerData playerData, NBTTagCompound nbtTagCompound) {
        ((IPlayerDBCInfo)playerData).getPlayerDBCInfo().saveNBTData(nbtTagCompound);
    }

    @Overwrite(remap=false)
    public void readFromNBT(PlayerData playerData, NBTTagCompound nbtTagCompound) {
        ((IPlayerDBCInfo)playerData).getPlayerDBCInfo().loadNBTData(nbtTagCompound);
    }

    @Overwrite(remap=false)
    public void syncPlayer(EntityPlayerMP playerMP) {
        DBCSyncController.syncPlayer(playerMP);
    }
}

