/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import java.util.Hashtable;
import java.util.Map;
import kamkeel.npcdbc.CustomNpcPlusDBC;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.packets.CapsuleInfo;
import kamkeel.npcdbc.network.packets.DBCInfoSync;
import kamkeel.npcdbc.network.packets.DBCSetFlight;
import kamkeel.npcdbc.network.packets.DBCSetValPacket;
import kamkeel.npcdbc.network.packets.DBCUpdateLockOn;
import kamkeel.npcdbc.network.packets.LoginInfo;
import kamkeel.npcdbc.network.packets.PingPacket;
import kamkeel.npcdbc.network.packets.PlaySound;
import kamkeel.npcdbc.network.packets.SendChat;
import kamkeel.npcdbc.network.packets.StopSound;
import kamkeel.npcdbc.network.packets.TransformPacket;
import kamkeel.npcdbc.network.packets.TurboPacket;
import kamkeel.npcdbc.network.packets.aura.DBCGetAura;
import kamkeel.npcdbc.network.packets.aura.DBCRemoveAura;
import kamkeel.npcdbc.network.packets.aura.DBCRequestAura;
import kamkeel.npcdbc.network.packets.aura.DBCSaveAura;
import kamkeel.npcdbc.network.packets.aura.DBCSelectAura;
import kamkeel.npcdbc.network.packets.aura.DBCSetAura;
import kamkeel.npcdbc.network.packets.form.DBCGetForm;
import kamkeel.npcdbc.network.packets.form.DBCRemoveForm;
import kamkeel.npcdbc.network.packets.form.DBCRequestForm;
import kamkeel.npcdbc.network.packets.form.DBCRequestFormWheel;
import kamkeel.npcdbc.network.packets.form.DBCSaveForm;
import kamkeel.npcdbc.network.packets.form.DBCSaveFormWheel;
import kamkeel.npcdbc.network.packets.form.DBCSelectForm;
import kamkeel.npcdbc.network.packets.outline.DBCGetOutline;
import kamkeel.npcdbc.network.packets.outline.DBCRemoveOutline;
import kamkeel.npcdbc.network.packets.outline.DBCRequestOutline;
import kamkeel.npcdbc.network.packets.outline.DBCSaveOutline;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.world.WorldServer;

public final class PacketHandler {
    public static PacketHandler Instance;
    public Map<String, AbstractPacket> map = new Hashtable<String, AbstractPacket>();
    public Map<String, FMLEventChannel> channels = new Hashtable<String, FMLEventChannel>();

    public PacketHandler() {
        this.map.put("NPC|Ping", new PingPacket());
        this.map.put("NPC|Transform", new TransformPacket());
        this.map.put("NPC|SetValue", new DBCSetValPacket());
        this.map.put("NPC|Sync", new DBCInfoSync());
        this.map.put("NPC|SelectForm", new DBCSelectForm());
        this.map.put("NPC|SelectAura", new DBCSelectAura());
        this.map.put("NPC|SetAura", new DBCSetAura());
        this.map.put("NPC|RequestAura", new DBCRequestAura());
        this.map.put("NPC|GetAura", new DBCGetAura());
        this.map.put("NPC|RequestForm", new DBCRequestForm());
        this.map.put("NPC|GetForm", new DBCGetForm());
        this.map.put("NPC|CapInfo", new CapsuleInfo());
        this.map.put("NPC|Login", new LoginInfo());
        this.map.put("NPC|SendChat", new SendChat());
        this.map.put("NPC|PlaySound", new PlaySound());
        this.map.put("NPC|StopSound", new StopSound());
        this.map.put("NPC|SaveForm", new DBCSaveForm());
        this.map.put("NPC|RemForm", new DBCRemoveForm());
        this.map.put("NPC|SetFlight", new DBCSetFlight());
        this.map.put("NPC|RemAura", new DBCRemoveAura());
        this.map.put("NPC|SaveAura", new DBCSaveAura());
        this.map.put("NPC|RequestOutline", new DBCRequestOutline());
        this.map.put("NPC|RemOutline", new DBCRemoveOutline());
        this.map.put("NPC|GetOutline", new DBCGetOutline());
        this.map.put("NPC|SaveOutline", new DBCSaveOutline());
        this.map.put("NPC|LockOnUpdate", new DBCUpdateLockOn());
        this.map.put("NPC|RequestFormWheel", new DBCRequestFormWheel());
        this.map.put("NPC|SaveFormWheel", new DBCSaveFormWheel());
        this.map.put("NPC|ToggleTurbo", new TurboPacket());
        this.register();
    }

    public void register() {
        for (String channel : this.map.keySet()) {
            FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channel);
            eventChannel.register((Object)this);
            this.channels.put(channel, eventChannel);
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        try {
            this.map.get(event.packet.channel()).receiveData(event.packet.payload(), (EntityPlayer)((NetHandlerPlayServer)event.handler).field_147369_b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            this.map.get(event.packet.channel()).receiveData(event.packet.payload(), CustomNpcPlusDBC.proxy.getClientPlayer());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendToPlayer(FMLProxyPacket packet, EntityPlayerMP player) {
        if (packet != null && CustomNpcPlusDBC.side() == Side.SERVER) {
            this.channels.get(packet.channel()).sendTo(packet, player);
        }
    }

    public void sendToServer(FMLProxyPacket packet) {
        if (packet != null) {
            packet.setTarget(Side.SERVER);
            this.channels.get(packet.channel()).sendToServer(packet);
        }
    }

    public void sendToTrackingPlayers(Entity entity, FMLProxyPacket packet) {
        if (packet != null && CustomNpcPlusDBC.side() == Side.SERVER) {
            EntityTracker tracker = ((WorldServer)entity.field_70170_p).func_73039_n();
            tracker.func_151248_b(entity, (Packet)packet);
        }
    }

    public void sendAround(Entity entity, double range, FMLProxyPacket packet) {
        if (packet != null && CustomNpcPlusDBC.side() == Side.SERVER) {
            this.channels.get(packet.channel()).sendToAllAround(packet, new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, range));
        }
    }

    public void sendToAll(FMLProxyPacket packet) {
        if (packet != null && CustomNpcPlusDBC.side() == Side.SERVER) {
            this.channels.get(packet.channel()).sendToAll(packet);
        }
    }
}

