/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets;

import JinRyuu.DragonBC.common.DBCConfig;
import JinRyuu.JRMCore.server.config.dbc.JGConfigRaces;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import kamkeel.npcdbc.client.ClientCache;
import kamkeel.npcdbc.config.ConfigDBCEffects;
import kamkeel.npcdbc.config.ConfigDBCGameplay;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.util.ByteBufUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class LoginInfo
extends AbstractPacket {
    public static final String packetName = "NPC|Login";
    private final float ma;
    private final float spi;
    private final float war;
    private final boolean chargeDex = ConfigDBCGameplay.EnableChargingDex;
    private final boolean transformBypass;
    private final double kiProtectionValue;
    private final double kiFistValue;
    private final boolean kiRevamp;
    private final float divineMulti;
    private final int maxAbsorptionLevel;

    public LoginInfo() {
        this.ma = ConfigDBCGameplay.MartialArtistCharge;
        this.spi = ConfigDBCGameplay.SpiritualistCharge;
        this.war = ConfigDBCGameplay.WarriorCharge;
        this.transformBypass = ConfigDBCGameplay.InstantTransform;
        this.kiProtectionValue = DBCConfig.ccnfKDd;
        this.kiFistValue = DBCConfig.ccnfKFd;
        this.kiRevamp = ConfigDBCGameplay.RevampKiCharging;
        this.divineMulti = ConfigDBCEffects.getDivineMulti();
        this.maxAbsorptionLevel = JGConfigRaces.CONFIG_MAJIN_ABSORPTON_MAX_LEVEL;
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        out.writeBoolean(this.chargeDex);
        out.writeFloat(this.ma);
        out.writeFloat(this.spi);
        out.writeFloat(this.war);
        out.writeBoolean(this.transformBypass);
        out.writeDouble(this.kiProtectionValue);
        out.writeDouble(this.kiFistValue);
        out.writeBoolean(this.kiRevamp);
        out.writeFloat(this.divineMulti);
        out.writeInt(this.maxAbsorptionLevel);
        HashMap<Integer, HashMap<String, Boolean>> divineRaces = ConfigDBCEffects.getDivineApplicableForms();
        NBTTagList divineApplicableRaces = new NBTTagList();
        for (int i : divineRaces.keySet()) {
            HashMap<String, Boolean> divineForms = divineRaces.get(i);
            if (divineForms == null) continue;
            NBTTagCompound divineApplicableForms = new NBTTagCompound();
            for (String form : divineForms.keySet()) {
                divineApplicableForms.func_74757_a(form, divineForms.getOrDefault(form, false).booleanValue());
            }
            divineApplicableRaces.func_74742_a((NBTBase)divineApplicableForms);
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("divineRaces", (NBTBase)divineApplicableRaces);
        ByteBufUtils.writeNBT(out, compound);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        if (player.field_70170_p.field_72995_K) {
            ClientCache.hasChargingDex = in.readBoolean();
            float martialArtist = in.readFloat();
            float spiritualist = in.readFloat();
            float warrior = in.readFloat();
            ClientCache.chargingDexValues.put(0, Float.valueOf(martialArtist));
            ClientCache.chargingDexValues.put(1, Float.valueOf(spiritualist));
            ClientCache.chargingDexValues.put(2, Float.valueOf(warrior));
            ClientCache.allowTransformBypass = in.readBoolean();
            DBCConfig.cnfKDd = in.readDouble();
            DBCConfig.cnfKFd = in.readDouble();
            ClientCache.kiRevamp = in.readBoolean();
            ClientCache.divineMulti = in.readFloat();
            ClientCache.maxAbsorptionLevel = in.readInt();
            ClientCache.divineApplicableForms.clear();
            NBTTagCompound compound = ByteBufUtils.readNBT(in);
            NBTTagList divineRaces = compound.func_150295_c("divineRaces", 10);
            for (int i = 0; i < divineRaces.func_74745_c(); ++i) {
                NBTTagCompound forms = divineRaces.func_150305_b(i);
                HashMap<String, Boolean> formMap = new HashMap<String, Boolean>();
                for (String key : forms.func_150296_c()) {
                    formMap.put(key, forms.func_74767_n(key));
                }
                ClientCache.divineApplicableForms.put(i, formMap);
            }
        }
    }
}

