/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.aura;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.DBCAddonPermissions;
import kamkeel.npcdbc.network.NetworkUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;

public class DBCRemoveAura
extends AbstractPacket {
    public static final String packetName = "NPC|RemAura";
    private int auraID;

    public DBCRemoveAura(int auraID) {
        this.auraID = auraID;
    }

    public DBCRemoveAura() {
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.auraID);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        if (!CustomNpcsPermissions.hasPermission((EntityPlayer)player, (CustomNpcsPermissions.Permission)DBCAddonPermissions.GLOBAL_DBCAURA)) {
            return;
        }
        int auraID = in.readInt();
        AuraController.getInstance().delete(auraID);
        NetworkUtility.sendCustomAuraDataAll((EntityPlayerMP)player);
        NBTTagCompound compound = new Aura().writeToNBT();
        Server.sendData((EntityPlayerMP)((EntityPlayerMP)player), (EnumPacketClient)EnumPacketClient.GUI_DATA, (Object[])new Object[]{compound});
    }
}

