/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.aura;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.NetworkUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;

public final class DBCRequestAura
extends AbstractPacket {
    public static final String packetName = "NPC|RequestAura";
    private int auraID;
    private boolean onlyPlayers;

    public DBCRequestAura(int auraID, boolean players) {
        this.auraID = auraID;
        this.onlyPlayers = players;
    }

    public DBCRequestAura() {
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.auraID);
        out.writeBoolean(this.onlyPlayers);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        this.auraID = in.readInt();
        this.onlyPlayers = in.readBoolean();
        if (this.auraID != -1) {
            Aura aura = (Aura)AuraController.getInstance().get(this.auraID);
            if (aura != null) {
                NBTTagCompound compound = aura.writeToNBT();
                compound.func_74778_a("PACKETTYPE", "Aura");
                Server.sendData((EntityPlayerMP)((EntityPlayerMP)player), (EnumPacketClient)EnumPacketClient.GUI_DATA, (Object[])new Object[]{compound});
            }
        } else if (this.onlyPlayers) {
            NetworkUtility.sendPlayersAuras((EntityPlayer)((EntityPlayerMP)player));
        } else {
            NetworkUtility.sendCustomAuraDataAll((EntityPlayerMP)player);
        }
    }
}

