/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.aura;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.DBCAddonPermissions;
import kamkeel.npcdbc.network.NetworkUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.Server;

public class DBCSaveAura
extends AbstractPacket {
    public static final String packetName = "NPC|SaveAura";
    private String prevName;
    private NBTTagCompound aura;

    public DBCSaveAura(NBTTagCompound compound, String prev) {
        this.aura = compound;
        this.prevName = prev;
    }

    public DBCSaveAura() {
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        Server.writeString((ByteBuf)out, (String)this.prevName);
        Server.writeNBT((ByteBuf)out, (NBTTagCompound)this.aura);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        if (!CustomNpcsPermissions.hasPermission((EntityPlayer)player, (CustomNpcsPermissions.Permission)DBCAddonPermissions.GLOBAL_DBCAURA)) {
            return;
        }
        String prevName = Server.readString((ByteBuf)in);
        if (!prevName.isEmpty()) {
            AuraController.getInstance().deleteAuraFile(prevName);
        }
        Aura aura = new Aura();
        aura.readFromNBT(Server.readNBT((ByteBuf)in));
        AuraController.getInstance().saveAura(aura);
        NetworkUtility.sendCustomAuraDataAll((EntityPlayerMP)player);
    }
}

