/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.form;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.NetworkUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;

public final class DBCRequestForm
extends AbstractPacket {
    public static final String packetName = "NPC|RequestForm";
    private int formID;
    private boolean onlyPlayers;
    private boolean menuName;

    public DBCRequestForm(int formID, boolean players, boolean menuName) {
        this.formID = formID;
        this.onlyPlayers = players;
        this.menuName = menuName;
    }

    public DBCRequestForm() {
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.formID);
        out.writeBoolean(this.onlyPlayers);
        out.writeBoolean(this.menuName);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        this.formID = in.readInt();
        this.onlyPlayers = in.readBoolean();
        this.menuName = in.readBoolean();
        if (this.formID != -1) {
            Form customForm = (Form)FormController.getInstance().get(this.formID);
            if (customForm != null) {
                NBTTagCompound compound = customForm.writeToNBT();
                compound.func_74778_a("PACKETTYPE", "Form");
                Server.sendData((EntityPlayerMP)((EntityPlayerMP)player), (EnumPacketClient)EnumPacketClient.GUI_DATA, (Object[])new Object[]{compound});
            }
        } else if (this.onlyPlayers) {
            NetworkUtility.sendPlayersForms(player, this.menuName);
        } else {
            NetworkUtility.sendCustomFormDataAll((EntityPlayerMP)player);
        }
    }
}

