/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.form;

import JinRyuu.JRMCore.JRMCoreH;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.config.ConfigDBCGameplay;
import kamkeel.npcdbc.constants.DBCForm;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.data.PlayerDBCInfo;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.NetworkUtility;
import kamkeel.npcdbc.util.PlayerDataUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerData;

public final class DBCSelectForm
extends AbstractPacket {
    public static final String packetName = "NPC|SelectForm";
    private int formID;
    private boolean isDBC;

    public DBCSelectForm(int formID, boolean isDBC) {
        this.formID = formID;
        this.isDBC = isDBC;
    }

    public DBCSelectForm() {
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.formID);
        out.writeBoolean(this.isDBC);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        int formID = in.readInt();
        boolean isDBC = in.readBoolean();
        PlayerData playerData = PlayerDataController.Instance.getPlayerData(player);
        PlayerDBCInfo formData = PlayerDataUtil.getDBCInfo(playerData);
        NBTTagCompound compound = new NBTTagCompound();
        if (formID == -1 && (isDBC ? formData.selectedDBCForm == -1 : formData.selectedForm == -1)) {
            return;
        }
        if (isDBC && formID != -1) {
            if (formID == formData.selectedDBCForm) {
                return;
            }
            DBCData dbc = DBCData.get(player);
            int selected = 0;
            formData.tempSelectedDBCForm = selected = formID;
            formData.selectedDBCForm = selected;
            formData.selectedForm = -1;
            if (selected == 21) {
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)0);
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)11);
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)16);
                JRMCoreH.PlyrSettingsOn((EntityPlayer)player, (int)6);
            } else if (selected >= 31 && selected <= 36) {
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)6);
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)11);
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)16);
                JRMCoreH.PlyrSettingsOn((EntityPlayer)player, (int)0);
            } else if (selected >= 41 && selected <= 51) {
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)0);
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)6);
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)16);
                JRMCoreH.PlyrSettingsOn((EntityPlayer)player, (int)11);
            } else if (selected == 24) {
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)0);
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)6);
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)11);
                JRMCoreH.PlyrSettingsOn((EntityPlayer)player, (int)16);
            } else {
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)0);
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)6);
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)11);
                JRMCoreH.PlyrSettingsRem((EntityPlayer)player, (int)16);
            }
            if (formID != -1) {
                NetworkUtility.sendServerMessage(player, "\u00a7a", "npcdbc.formSelect", " ", DBCForm.getMenuName(dbc.Race, formID, dbc.isForm(26)));
            }
        } else if (formID != -1 && FormController.getInstance().has(formID)) {
            if (formID == formData.selectedForm) {
                return;
            }
            Form form = (Form)FormController.getInstance().get(formID);
            if (form != null && formData.hasFormUnlocked(formID)) {
                if (form.hasParent() && form.fromParentOnly) {
                    if (ConfigDBCGameplay.InstantTransform) {
                        boolean canInstant = form.mastery.canInstantTransform(formData.getFormLevel(formID));
                        if (!canInstant) {
                            NetworkUtility.sendServerMessage(player, "\u00a7c", "npcdbc.notEnoughMastery");
                            compound.func_74757_a("Skip", true);
                            Server.sendData((EntityPlayerMP)((EntityPlayerMP)player), (EnumPacketClient)EnumPacketClient.GUI_DATA, (Object[])new Object[]{compound});
                            return;
                        }
                    } else {
                        NetworkUtility.sendServerMessage(player, "\u00a7c", "npcdbc.cannotTransformDirect");
                        compound.func_74757_a("Skip", true);
                        Server.sendData((EntityPlayerMP)((EntityPlayerMP)player), (EnumPacketClient)EnumPacketClient.GUI_DATA, (Object[])new Object[]{compound});
                        return;
                    }
                }
                formData.selectedForm = formID;
                formData.tempSelectedDBCForm = -1;
                formData.selectedDBCForm = -1;
                NetworkUtility.sendServerMessage(player, "\u00a7a", "npcdbc.formSelect", " ", form.getMenuName());
                compound = form.writeToNBT();
            }
        } else {
            formData.tempSelectedDBCForm = -1;
            formData.selectedDBCForm = -1;
            formData.selectedForm = -1;
            NetworkUtility.sendServerMessage(player, "\u00a79", "npcdbc.clearedSelection");
        }
        formData.updateClient();
        Server.sendData((EntityPlayerMP)((EntityPlayerMP)player), (EnumPacketClient)EnumPacketClient.GUI_DATA, (Object[])new Object[]{compound});
        DBCData.get(player).saveNBTData(true);
    }
}

