/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.outline;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.controllers.OutlineController;
import kamkeel.npcdbc.data.outline.Outline;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.NetworkUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;

public final class DBCRequestOutline
extends AbstractPacket {
    public static final String packetName = "NPC|RequestOutline";
    private int outlineID;

    public DBCRequestOutline(int outlineID) {
        this.outlineID = outlineID;
    }

    public DBCRequestOutline() {
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.outlineID);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        this.outlineID = in.readInt();
        if (this.outlineID != -1) {
            Outline customOutline = (Outline)OutlineController.getInstance().get(this.outlineID);
            if (customOutline != null) {
                NBTTagCompound compound = customOutline.writeToNBT();
                compound.func_74778_a("PACKETTYPE", "Outline");
                Server.sendData((EntityPlayerMP)((EntityPlayerMP)player), (EnumPacketClient)EnumPacketClient.GUI_DATA, (Object[])new Object[]{compound});
            }
        } else {
            NetworkUtility.sendCustomOutlineDataAll((EntityPlayerMP)player);
        }
    }
}

