/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.outline;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.controllers.OutlineController;
import kamkeel.npcdbc.data.outline.Outline;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.DBCAddonPermissions;
import kamkeel.npcdbc.network.NetworkUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.Server;

public class DBCSaveOutline
extends AbstractPacket {
    public static final String packetName = "NPC|SaveOutline";
    private String prevName;
    private NBTTagCompound outline;

    public DBCSaveOutline(NBTTagCompound compound, String prev) {
        this.outline = compound;
        this.prevName = prev;
    }

    public DBCSaveOutline() {
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        Server.writeString((ByteBuf)out, (String)this.prevName);
        Server.writeNBT((ByteBuf)out, (NBTTagCompound)this.outline);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        if (!CustomNpcsPermissions.hasPermission((EntityPlayer)player, (CustomNpcsPermissions.Permission)DBCAddonPermissions.GLOBAL_DBCAURA)) {
            return;
        }
        String prevName = Server.readString((ByteBuf)in);
        if (!prevName.isEmpty()) {
            OutlineController.getInstance().deleteOutlineFile(prevName);
        }
        Outline outline = new Outline();
        outline.readFromNBT(Server.readNBT((ByteBuf)in));
        OutlineController.getInstance().saveOutline(outline);
        NetworkUtility.sendCustomOutlineDataAll((EntityPlayerMP)player);
    }
}

